/*
 * Decompiled with CFR 0.152.
 */
package rjw.util;

import java.awt.geom.Point2D;
import rjw.pluggablerobot.Math2;
import rjw.util.Vector;
import robocode.Rules;
import robocode.util.Utils;

public class Particle {
    protected Point2D.Double _p;
    protected Vector _v;

    protected Particle() {
    }

    public Particle(Point2D.Double p, Vector v) {
        this._p = p;
        this._v = v;
    }

    public Particle(double x, double y, double t, double v) {
        this._p = new Point2D.Double(x, y);
        this._v = new Vector(t, v);
    }

    public Particle project(int ticks) {
        double dx = this._v.d() * Math.sin(this._v.t()) * (double)ticks;
        double dy = this._v.d() * Math.cos(this._v.t()) * (double)ticks;
        return new Particle(new Point2D.Double(this._p.x + dx, this._p.y + dy), this._v);
    }

    public double getAbsoluteTargetBearing(Particle target) {
        return Math2.getAbsoluteTargetBearing(this._p, target.p());
    }

    public double getRelativeTargetBearing(Particle target) {
        return Utils.normalRelativeAngle((double)(this.getAbsoluteTargetBearing(target) - this._v.t));
    }

    public double getAbsoluteBearing(double relativeBearing) {
        return Utils.normalAbsoluteAngle((double)(this._v.t + relativeBearing));
    }

    public double getLinearTargetingBearing(Point2D.Double bulletOrigin, double power) {
        Point2D.Double target;
        double radius;
        double bv = Rules.getBulletSpeed((double)power);
        int tick = 0;
        while (!((radius = (double)(++tick) * bv) >= bulletOrigin.distance(target = this.project(tick).p()))) {
        }
        return Math2.getAbsoluteTargetBearing(bulletOrigin, target);
    }

    public int getTargetOrbitDirection(Particle target) {
        if (target.v().d == 0.0) {
            return 0;
        }
        double curAngle = this.getAbsoluteTargetBearing(target);
        double nextAngle = this.getAbsoluteTargetBearing(target.project(1));
        double angle = Utils.normalRelativeAngle((double)(nextAngle - curAngle));
        return (int)Math.signum(angle);
    }

    public double getAbsoluteOrbitHeading(Particle target, int direction) {
        int dir = direction >= 0 ? 1 : -1;
        return this.getAbsoluteTargetBearing(target) + 1.5707963267948966 * (double)dir;
    }

    public double getDistance(Particle target) {
        return this._p.distance(target.p());
    }

    public Vector getTargetVector(Particle target) {
        return new Vector(this.getRelativeTargetBearing(target), this.getDistance(target));
    }

    public Point2D.Double p() {
        return this._p;
    }

    public Vector v() {
        return this._v;
    }
}

