/*
 * Decompiled with CFR 0.152.
 */
package EFD;

import EFD.CircularMovement;
import EFD.EFDUtils;
import EFD.GFGun;
import EFD.MovementWave;
import EFD.RamMovement;
import EFD.Statistics;
import EFD.WaveSurfing;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import robocode.AdvancedRobot;
import robocode.BattleEndedEvent;
import robocode.BulletHitBulletEvent;
import robocode.BulletHitEvent;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.HitWallEvent;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;

public class AdvancedEFD
extends AdvancedRobot {
    public CircularMovement mov = new CircularMovement(this);
    public RamMovement rmov = new RamMovement(this);
    public WaveSurfing waveSurfing = new WaveSurfing(this);
    public Statistics statistics = new Statistics(this);
    public GFGun gfGun = new GFGun(this);
    public double MAX_CORNER_DISTANCE;
    public double MAX_DISTANCE;
    public double MAX_WALL_DISTANCE;
    public boolean RAMMING_MODE = false;
    public Point2D.Double position;
    public double eEnergy = 100.0;
    public double absBearing = 0.0;

    public void run() {
        this.MAX_CORNER_DISTANCE = Math.sqrt(Math.pow(this.getBattleFieldWidth() / 2.0 - 18.0, 2.0) + Math.pow(this.getBattleFieldHeight() / 2.0 - 18.0, 2.0));
        this.MAX_DISTANCE = Math.sqrt(Math.pow(this.getBattleFieldWidth() - 36.0, 2.0) + Math.pow(this.getBattleFieldHeight() - 36.0, 2.0));
        this.MAX_WALL_DISTANCE = Math.min(this.getBattleFieldWidth() / 2.0 - 18.0, this.getBattleFieldHeight() / 2.0 - 18.0);
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        Point2D.Double center = new Point2D.Double(this.getBattleFieldWidth() / 2.0, this.getBattleFieldHeight() / 2.0);
        this.position = new Point2D.Double(this.getX(), this.getY());
        while (true) {
            if (this.getRadarTurnRemainingRadians() == 0.0) {
                this.setTurnRadarRightRadians(1000.0);
                this.position = new Point2D.Double(this.getX(), this.getY());
                this.mov.move(this.position, center, 150.0, 1, 50);
            }
            this.execute();
        }
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        this.absBearing = EFDUtils.normaliseAngle(this.getHeadingRadians() + e.getBearingRadians());
        this.position = new Point2D.Double(this.getX(), this.getY());
        this.statistics.update(e);
        this.eEnergy = e.getEnergy();
        double eEnergyChange = this.eEnergy - this.eEnergy;
        if (eEnergyChange < 3.01 && eEnergyChange > 0.09 && this.statistics.log.size() > 2) {
            this.statistics.currentMovementWaves.add(new MovementWave(e, eEnergyChange, this, this.statistics.createMovementDatapoint(eEnergyChange)));
            ++Statistics.enemyBulletsShot;
        }
        this.RAMMING_MODE = this.eEnergy <= 1.0 && this.getEnergy() > 30.0;
        double bulletPower = this.RAMMING_MODE ? Math.min(this.eEnergy / 5.0, this.gfGun.evalBulletPower(this.statistics.log.get(0).getEnemyDistance())) : this.gfGun.evalBulletPower(this.statistics.log.get(0).getEnemyDistance());
        this.gfGun.aim(e, bulletPower);
        if (this.RAMMING_MODE && this.eEnergy > 0.4 || !this.RAMMING_MODE && this.getEnergy() > 0.1) {
            this.gfGun.tryToFire(e, bulletPower);
        }
        this.setTurnRadarRightRadians(Utils.normalRelativeAngle((double)(e.getBearingRadians() + this.getHeadingRadians() - this.getRadarHeadingRadians())) * 2.0);
        if (this.RAMMING_MODE) {
            this.rmov.move();
        } else {
            this.waveSurfing.doSurfing();
        }
    }

    public void onBulletHit(BulletHitEvent e) {
        double bulletPower = e.getBullet().getPower();
        double bulletDamage = bulletPower * 4.0;
        if (bulletPower > 1.0) {
            bulletDamage += 2.0 * (bulletPower - 1.0);
        }
        this.eEnergy -= bulletDamage;
        this.statistics.registerBulletHit(e);
    }

    public void onHitByBullet(HitByBulletEvent e) {
        double bulletPower = e.getBullet().getPower();
        this.eEnergy += 3.0 * bulletPower;
        this.statistics.registerHitByBullet(e);
    }

    public void onBulletHitBullet(BulletHitBulletEvent e) {
        this.waveSurfing.registerBulletHitBullet(e);
    }

    public void onHitRobot(HitRobotEvent e) {
        this.eEnergy -= 0.6;
    }

    public void onHitWall(HitWallEvent e) {
        ++Statistics.wallHits;
    }

    public void onBattleEnded(BattleEndedEvent e) {
        this.statistics.displayStats();
    }

    public void onPaint(Graphics2D g) {
        g.setColor(Color.GRAY);
        g.drawRect(18, 18, (int)this.getBattleFieldWidth() - 36, (int)this.getBattleFieldHeight() - 36);
        Point2D.Double aim = EFDUtils.projectPoint(this.position, this.getGunHeadingRadians(), 1000.0);
        g.drawLine((int)this.position.x, (int)this.position.y, (int)aim.x, (int)aim.y);
    }
}

