/*
 * Decompiled with CFR 0.152.
 */
package jekl.gunnery.guns;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import jekl.Jekyl;
import jekl.gunnery.guns.Fire;
import jekl.gunnery.util.FiringAssistant;
import jekl.gunnery.util.WaveBullet;
import jekl.intelligence.Enemy;
import jekl.navigation.util.BattleMap;
import robocode.RobocodeFileOutputStream;
import robocode.util.Utils;

public class WaveFire
implements Fire {
    private static Jekyl ar;
    private static final double GUESS_FACTORS = 31.0;
    private static float[][][][] statBuffer;
    private static HashMap opponents;
    private ArrayList waves;
    private int distanceIndex;
    private int latVelIndex;
    private int accellIndex;
    private int wallIndex;
    private int targetDirection = 1;
    private double firePower;
    private double maxShootAngle;
    private Enemy target;
    private long eventTime;
    private static String currentTarget;
    private BattleMap bm;

    static {
        statBuffer = null;
        opponents = null;
    }

    public WaveFire(Jekyl _ar) {
        ar = _ar;
        this.bm = new BattleMap(_ar);
        this.waves = new ArrayList();
    }

    public void doTurn(FiringAssistant fa) {
        this.target = ar.getTarget();
        this.firePower = fa.calculateFirePower(this.target);
        currentTarget = this.target.getName();
        if (statBuffer == null || !this.target.getName().equalsIgnoreCase(currentTarget)) {
            this.initializeStats(this.target.getName());
        }
        double tVelocity = this.target.getVelocity();
        double latVel = tVelocity * Math.sin(this.target.getHeading() - this.target.getAbsBearing());
        double accelDiff = Math.round(Math.abs(tVelocity) - Math.abs(this.target.getLastVelocity()));
        this.accellIndex = accelDiff == 0.0 ? 0 : (accelDiff > 0.0 ? 2 : 1);
        this.eventTime = ar.getTime() - 1L;
        this.distanceIndex = fa.getDistanceIndex(this.firePower, this.target);
        this.latVelIndex = (int)(Math.abs(latVel) / 3.0);
        this.wallIndex = this.bm.getBattleField().contains(this.target.getX() + Math.sin(this.target.getHeading()) * (this.target.getVelocity() * 10.0), this.target.getY() + Math.cos(this.target.getHeading()) * (this.target.getVelocity() * 10.0)) ? 0 : 1;
        this.targetDirection = latVel >= 0.0 ? 1 : -1;
        this.doFire(this.firePower);
    }

    public void doStats(WaveBullet w) {
        if (statBuffer == null || !ar.getTarget().getName().equalsIgnoreCase(currentTarget)) {
            this.initializeStats(ar.getTarget().getName());
        }
        float[] stats = statBuffer[w.getAccelIndex()][w.getLatVelIndex()][w.getDistanceIndex()];
        int i = 0;
        while (i < stats.length) {
            int n = i++;
            stats[n] = stats[n] * 0.98f;
        }
        int n = w.getGuessIndex();
        stats[n] = stats[n] + 0.01f;
        if ((double)(w.getGuessIndex() + 1) <= 30.0) {
            int n2 = w.getGuessIndex() + 1;
            stats[n2] = stats[n2] + 0.006f;
        }
        if (w.getGuessIndex() - 1 >= 0) {
            int n3 = w.getGuessIndex() - 1;
            stats[n3] = stats[n3] + 0.006f;
        }
    }

    private double doFire(double firePower) {
        Enemy target = ar.getTarget();
        ar.setTurnGunRightRadians(Utils.normalRelativeAngle((double)(target.getAbsBearing() - ar.getGunHeadingRadians() + this.getGuessAngle(this.getShotIndex(), firePower))));
        return firePower;
    }

    private int getShotIndex() {
        float[] buffer = statBuffer[this.accellIndex][this.latVelIndex][this.distanceIndex];
        return this.getHighestIndex(buffer, 3);
    }

    private double getGuessAngle(int guessIndex, double firePower) {
        if (this.target.getEnergy() == 0.0) {
            return 0.0;
        }
        double guessFactor = ((double)guessIndex - 15.0) / 15.0;
        return guessFactor * Math.asin(8.0 / (20.0 - 3.0 * firePower)) * (double)this.targetDirection;
    }

    private int getBestIndex(float[] stats) {
        int bestIndex = stats.length / 2;
        int i = 0;
        while (i < stats.length) {
            if (stats[i] > stats[bestIndex]) {
                bestIndex = i;
            }
            ++i;
        }
        return bestIndex;
    }

    private int getHighestIndex(float[] stats, int window) {
        float highestTotal = 0.0f;
        int highestIndex = stats.length / 2;
        float total = 0.0f;
        int i = 0;
        while (i < stats.length) {
            total = 0.0f;
            int j = Math.max(0, i - window / 2);
            while (j < Math.min(stats.length, i + window / 2)) {
                total = (float)((double)total + (double)stats[j] * this.kernelDistribution(Math.abs(i - j), window));
                ++j;
            }
            if (total > highestTotal) {
                highestTotal = total;
                highestIndex = i;
            }
            ++i;
        }
        return highestIndex;
    }

    private double kernelDistribution(int distance, int window) {
        return 1.0 / (1.0 + (double)distance / (double)window);
    }

    private void initializeStats(String target) {
        statBuffer = this.decompressData(this.getFileName());
        if (statBuffer == null) {
            statBuffer = this.doInit();
        }
    }

    private float[][][][] doInit() {
        if (WaveFire.ar.DEBUG) {
            System.out.println("Wave Fire Initializing");
        }
        float[][][][] stats = new float[3][3][11][31];
        return stats;
    }

    public void saveData() {
        if (ar.getProps().getProperty("usedata", "true").equalsIgnoreCase("true")) {
            this.compressData(statBuffer, this.getFileName());
        }
    }

    private String getFileName() {
        if (this.target.getName().indexOf(" ") >= 0) {
            return String.valueOf(this.target.getName().substring(0, this.target.getName().indexOf(" "))) + ".zip";
        }
        return String.valueOf(this.target.getName()) + ".zip";
    }

    public synchronized void compressData(float[][][][] buffer, String fileName) {
        block20: {
            if (WaveFire.ar.DEBUG) {
                System.out.println("Compressing Data");
            }
            byte[][][][] compressedData = new byte[3][3][11][31];
            float largestVal = 0.0f;
            int i = 0;
            while (i < 3) {
                int j = 0;
                while (j < 3) {
                    int k = 0;
                    while (k < 11) {
                        int l = 0;
                        while (l < 31) {
                            if (buffer[i][j][k][l] > largestVal) {
                                largestVal = statBuffer[i][j][k][l];
                            }
                            ++l;
                        }
                        ++k;
                    }
                    ++j;
                }
                ++i;
            }
            float magic = largestVal / 255.0f;
            int i2 = 0;
            while (i2 < 3) {
                int j = 0;
                while (j < 3) {
                    int k = 0;
                    while (k < 11) {
                        int l = 0;
                        while (l < 31) {
                            compressedData[i2][j][k][l] = (byte)(buffer[i2][j][k][l] / magic);
                            ++l;
                        }
                        ++k;
                    }
                    ++j;
                }
                ++i2;
            }
            ObjectOutputStream oos = null;
            try {
                try {
                    File f = ar.getDataFile(fileName);
                    if (f.exists()) {
                        f.delete();
                    }
                    oos = new ObjectOutputStream(new GZIPOutputStream((OutputStream)new RobocodeFileOutputStream(f)));
                    oos.writeObject(new Float(magic));
                    oos.writeObject(compressedData);
                    oos.close();
                }
                catch (IOException e) {
                    if (WaveFire.ar.DEBUG) {
                        System.out.println("Error Writing");
                        e.printStackTrace();
                    }
                }
            }
            catch (Throwable throwable) {
                block19: {
                    Object var8_13 = null;
                    try {
                        oos.close();
                    }
                    catch (Exception e) {
                        if (!WaveFire.ar.DEBUG) break block19;
                        e.printStackTrace();
                    }
                }
                throw throwable;
            }
            Object var8_14 = null;
            try {
                oos.close();
            }
            catch (Exception e) {
                if (!WaveFire.ar.DEBUG) break block20;
                e.printStackTrace();
            }
        }
    }

    private float[][][][] decompressData(String fileName) {
        block9: {
            if (WaveFire.ar.DEBUG) {
                System.out.println("Decompressing Data");
            }
            try {
                ObjectInputStream ois = new ObjectInputStream(new GZIPInputStream(new FileInputStream(ar.getDataFile(fileName))));
                float[][][][] retVal = new float[3][3][11][31];
                float magic = ((Float)ois.readObject()).floatValue();
                byte[][][][] compressedData = (byte[][][][])ois.readObject();
                ois.close();
                int i = 0;
                while (i < 3) {
                    int j = 0;
                    while (j < 3) {
                        int k = 0;
                        while (k < 11) {
                            int l = 0;
                            while (l < 31) {
                                retVal[i][j][k][l] = (float)(compressedData[i][j][k][l] & 0xFF) * magic;
                                ++l;
                            }
                            ++k;
                        }
                        ++j;
                    }
                    ++i;
                }
                return retVal;
            }
            catch (IOException e) {
                if (WaveFire.ar.DEBUG) {
                    System.out.println("File IO Error Reading");
                    e.printStackTrace();
                }
            }
            catch (ClassNotFoundException e) {
                if (!WaveFire.ar.DEBUG) break block9;
                System.out.println("Class Not Found Excep");
            }
        }
        return null;
    }
}

