/*
 * Decompiled with CFR 0.152.
 */
package ags.muse.physics;

import ags.util.Range;
import ags.util.points.AbsolutePoint;
import ags.util.points.RelativePoint;
import java.util.ArrayList;
import java.util.List;

public class WaveIntersect {
    public static Range getHitRange(AbsolutePoint origin, double radius, double speed, double referenceAngle, AbsolutePoint p) {
        if (Math.abs(origin.distance(p) - radius) > Math.sqrt(648.0) + speed) {
            return null;
        }
        ArrayList<AbsolutePoint> possiblepoints = new ArrayList<AbsolutePoint>();
        double bottom = p.y - 18.0;
        double top = p.y + 18.0;
        double left = p.x - 18.0;
        double right = p.x + 18.0;
        double lastradius = radius - speed;
        possiblepoints.addAll(WaveIntersect.XCircleIntersect(origin, lastradius, left, bottom, top));
        possiblepoints.addAll(WaveIntersect.XCircleIntersect(origin, radius, left, bottom, top));
        possiblepoints.addAll(WaveIntersect.XCircleIntersect(origin, lastradius, right, bottom, top));
        possiblepoints.addAll(WaveIntersect.XCircleIntersect(origin, radius, right, bottom, top));
        possiblepoints.addAll(WaveIntersect.YCircleIntersect(origin, lastradius, bottom, left, right));
        possiblepoints.addAll(WaveIntersect.YCircleIntersect(origin, radius, bottom, left, right));
        possiblepoints.addAll(WaveIntersect.YCircleIntersect(origin, lastradius, top, left, right));
        possiblepoints.addAll(WaveIntersect.YCircleIntersect(origin, radius, top, left, right));
        AbsolutePoint c1 = AbsolutePoint.fromXY(left, bottom);
        AbsolutePoint c2 = AbsolutePoint.fromXY(left, top);
        AbsolutePoint c3 = AbsolutePoint.fromXY(right, top);
        AbsolutePoint c4 = AbsolutePoint.fromXY(right, bottom);
        if (WaveIntersect.intersects(origin, radius, speed, c1)) {
            possiblepoints.add(c1);
        }
        if (WaveIntersect.intersects(origin, radius, speed, c2)) {
            possiblepoints.add(c2);
        }
        if (WaveIntersect.intersects(origin, radius, speed, c3)) {
            possiblepoints.add(c3);
        }
        if (WaveIntersect.intersects(origin, radius, speed, c4)) {
            possiblepoints.add(c4);
        }
        Range r = null;
        for (AbsolutePoint point : possiblepoints) {
            double relAngle = RelativePoint.fromPP(origin, point).getDirDist(referenceAngle);
            r = r != null ? r.grow(relAngle) : new Range(relAngle);
        }
        return r;
    }

    private static boolean intersects(AbsolutePoint origin, double radius, double speed, AbsolutePoint p) {
        double d = origin.distance(p);
        return d <= radius && d >= radius - speed;
    }

    private static List<AbsolutePoint> XCircleIntersect(AbsolutePoint origin, double r, double x, double miny, double maxy) {
        ArrayList<AbsolutePoint> intersects = new ArrayList<AbsolutePoint>();
        double dx = x - origin.x;
        double D = r * r - dx * dx;
        if (D < 0.0) {
            return intersects;
        }
        double d = Math.sqrt(D);
        double y1 = origin.y + d;
        if (y1 >= miny && y1 <= maxy) {
            intersects.add(AbsolutePoint.fromXY(x, y1));
        }
        if (D == 0.0) {
            return intersects;
        }
        double y2 = origin.y - d;
        if (y2 >= miny && y2 <= maxy) {
            intersects.add(AbsolutePoint.fromXY(x, y2));
        }
        return intersects;
    }

    private static List<AbsolutePoint> YCircleIntersect(AbsolutePoint origin, double r, double y, double minx, double maxx) {
        ArrayList<AbsolutePoint> intersects = new ArrayList<AbsolutePoint>();
        double dy = y - origin.y;
        double D = r * r - dy * dy;
        if (D < 0.0) {
            return intersects;
        }
        double d = Math.sqrt(D);
        double x1 = origin.x + d;
        if (x1 >= minx && x1 <= maxx) {
            intersects.add(AbsolutePoint.fromXY(x1, y));
        }
        if (D == 0.0) {
            return intersects;
        }
        double x2 = origin.x - d;
        if (x2 >= minx && x2 <= maxx) {
            intersects.add(AbsolutePoint.fromXY(x2, y));
        }
        return intersects;
    }
}

