/*
 * Decompiled with CFR 0.152.
 */
package de._4geeks.robots.guns.DC.features;

import de._4geeks.robots.guns.DC.EnemyFeature;
import de._4geeks.robots.guns.manager.EnemyScan;
import robocode.AdvancedRobot;

public class WallDistanceFeature
extends EnemyFeature {
    private double max;
    private double bfHeight;
    private double bfWidth;

    public WallDistanceFeature(AdvancedRobot robot) {
        this.slices = new double[]{75.0, 125.0, 175.0};
        this.bfHeight = robot.getBattleFieldHeight();
        this.bfWidth = robot.getBattleFieldWidth();
        this.max = Math.max(this.bfHeight, this.bfWidth) / 2.0;
    }

    public double getAttributeValue(EnemyScan enemy) {
        return this.calcWallDistance(enemy.getX(), enemy.getY());
    }

    public double getAttributeValueNormalized(EnemyScan enemy) {
        return this.calcWallDistance(enemy.getX(), enemy.getY()) / this.max;
    }

    public String getFeatureName() {
        return "WallDistance";
    }

    private double calcWallDistance(double x, double y) {
        return Math.min(Math.min(x, this.bfHeight - x), Math.min(y, this.bfWidth - y));
    }
}

