/*
 * Decompiled with CFR 0.152.
 */
package kid.movement.robot;

import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.RoundRectangle2D;
import java.io.PrintStream;
import java.util.Arrays;
import kid.data.Printable;
import kid.data.RobotChooser;
import kid.movement.robot.Movement;
import kid.robot.RobotData;
import kid.robot.TeammateData;
import kid.utils.Utils;
import kid.virtual.VirtualBullet;
import robocode.Event;
import robocode.RobocodeFileOutputStream;
import robocode.Robot;

public class MinimumRiskPoint
extends Movement {
    private static final long serialVersionUID = -2185474595949395107L;
    private Point2D nextPosition;
    private RoundRectangle2D battleField;
    private final double walldist = 40.0;
    private final double cornerarc = 100.0;
    private final int NUM_OF_GENERATED_POINTS = 90;
    private final int CORNER_RISK = 2;
    private final int BOT_RISK = 100;

    public MinimumRiskPoint(Robot myRobot) {
        super(myRobot);
        this.init(myRobot);
    }

    private void init(Robot myRobot) {
        this.nextPosition = new Point2D.Double(this.robot.getX(), this.robot.getY());
        this.battleField = new RoundRectangle2D.Double(40.0, 40.0, this.robot.getBattleFieldWidth() - 80.0, this.robot.getBattleFieldHeight() - 80.0, 100.0, 100.0);
    }

    @Override
    public void inEvent(Event event) {
    }

    @Override
    public void move(RobotData[] robots, VirtualBullet[] teammateBullets) {
        this.movement.setMoveToPoint(this.getPoint(robots, teammateBullets));
    }

    public Point2D.Double[] getMove(RobotData[] robots, VirtualBullet[] teammateBullets, long time) {
        return null;
    }

    public Point2D getPoint(RobotData[] robots, VirtualBullet[] teammateBullets) {
        double myX = this.info.getX();
        double myY = this.info.getY();
        double minDist = this.info.distSq(RobotChooser.CLOSEST.getRobot(this.robot, Arrays.asList(robots)));
        minDist = Utils.sqrt(minDist);
        double pointDist = Utils.distSq(this.nextPosition, myX, myY);
        double pointRisk = Double.POSITIVE_INFINITY;
        if (pointDist > Utils.sqr(20.0)) {
            pointRisk = this.risk(this.nextPosition, robots, teammateBullets);
        }
        double dist = Utils.random(minDist / 2.0, minDist);
        double a = 0.0;
        while (a < 360.0) {
            double risk;
            double angle = Utils.random(a, a + 4.0);
            Point2D point = Utils.getPoint(myX, myY, dist, angle);
            if (this.battleField.contains(point) && (risk = this.risk(point, angle, robots, teammateBullets)) < pointRisk) {
                this.nextPosition = point;
                pointRisk = risk;
            }
            a += 4.0;
        }
        return this.nextPosition;
    }

    private double risk(Point2D point, RobotData[] robots, VirtualBullet[] teammateBullets) {
        return this.risk(point, this.info.angle(point), robots, teammateBullets);
    }

    private double risk(Point2D point, double angle, RobotData[] robots, VirtualBullet[] teammateBullets) {
        double myX = this.info.getX();
        double myY = this.info.getY();
        long time = this.info.getTime();
        double pointRisk = 0.0;
        Line2D.Double path = new Line2D.Double(myX, myY, point.getX(), point.getY());
        Printable[] printableArray = robots;
        int n = robots.length;
        int n2 = 0;
        while (n2 < n) {
            RobotData r = printableArray[n2];
            if (!r.isDead()) {
                if (path.intersects(r.getRectangle())) {
                    return Double.POSITIVE_INFINITY;
                }
                double robotRisk = 100.0;
                if (!(r instanceof TeammateData)) {
                    robotRisk = r.getEnergy();
                    robotRisk *= 1.0 + Math.abs(Utils.cos(angle - Utils.angle(myX, myY, r.getX(), r.getY())));
                } else {
                    robotRisk /= 2.0;
                }
                pointRisk += (robotRisk /= Utils.distSq(point, r.getX(), r.getY()));
            }
            ++n2;
        }
        printableArray = teammateBullets;
        n = teammateBullets.length;
        n2 = 0;
        while (n2 < n) {
            Printable b = printableArray[n2];
            double bulletRisk = 10.0;
            double heading = ((VirtualBullet)b).getHeading();
            double angleBullet = Utils.angle(myX, myY, ((VirtualBullet)b).getX(time), ((VirtualBullet)b).getY(time));
            if (Math.abs(angleBullet - heading) < Utils.maxEscapeAngle(((VirtualBullet)b).getVelocity())) {
                pointRisk += (bulletRisk /= Utils.sqr(Utils.distSq(point, ((VirtualBullet)b).getX(time), ((VirtualBullet)b).getY(time))));
            }
            ++n2;
        }
        pointRisk += (double)this.info.getOthers() / Utils.distSq(point, this.info.getBattleFieldWidth() / 2.0, this.info.getBattleFieldHeight() / 2.0);
        pointRisk += 2.0 / Utils.distSq(point, this.info.getBattleFieldWidth(), this.info.getBattleFieldHeight());
        pointRisk += 2.0 / Utils.distSq(point, 0.0, this.info.getBattleFieldHeight());
        pointRisk += 2.0 / Utils.distSq(point, 0.0, 0.0);
        return pointRisk += 2.0 / Utils.distSq(point, this.info.getBattleFieldWidth(), 0.0);
    }

    @Override
    public String getName() {
        return new String("Minimum Risk Point Movement");
    }

    @Override
    public String getType() {
        return new String("? Movement");
    }

    @Override
    public void print(PrintStream console) {
    }

    @Override
    public void print(RobocodeFileOutputStream output) {
    }
}

