/*
 * Decompiled with CFR 0.152.
 */
package jab.module;

import jab.module.BotInfo;
import jab.module.BulletInfoEnemy;
import jab.module.Gun;
import jab.module.Movement;
import jab.module.Radar;
import jab.module.SelectEnemy;
import jab.module.Special;
import jab.module.Targeting;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import robocode.Bullet;
import robocode.BulletHitBulletEvent;
import robocode.BulletHitEvent;
import robocode.BulletMissedEvent;
import robocode.Condition;
import robocode.CustomEvent;
import robocode.DeathEvent;
import robocode.Event;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.HitWallEvent;
import robocode.MessageEvent;
import robocode.RobotDeathEvent;
import robocode.Rules;
import robocode.ScannedRobotEvent;
import robocode.SkippedTurnEvent;
import robocode.TeamRobot;
import robocode.WinEvent;
import robocode.util.Utils;

public abstract class Module
extends TeamRobot {
    public static Rectangle2D.Double battleField;
    static final double BOT_WIDTH = 36.0;
    public static String[] enemyNumAssignation;
    public static int totalNumOfEnemies;
    public Radar radar;
    public Targeting targeting;
    public Movement movement;
    public Gun gun;
    public SelectEnemy selectEnemy;
    public Vector<Special> specials = new Vector();
    public double bulletPower;
    public BotInfo enemy = null;
    public Hashtable<String, BotInfo> botsInfo = new Hashtable();
    public Vector<BulletInfoEnemy> enemyBullets = new Vector();
    private static int debugOption;

    public void run() {
        this.setAdjustRadarForRobotTurn(true);
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        this.addCustomEvent(new Condition("EnemyFires"){

            public boolean test() {
                return Module.this.enemy != null && Module.this.enemy.previousEnergy > Module.this.enemy.energy && Module.this.enemy.previousEnergy - Module.this.enemy.energy <= 3.0 && !Utils.isNear((double)(Module.this.enemy.previousEnergy - Module.this.enemy.energy), (double)Rules.getBulletDamage((double)Module.this.bulletPower)) && Module.this.enemy.distance > 55.0;
            }
        });
        if (battleField == null) {
            battleField = new Rectangle2D.Double(18.0, 18.0, this.getBattleFieldWidth() - 36.0, this.getBattleFieldHeight() - 36.0);
            totalNumOfEnemies = this.getOthers() - (this.getTeammates() == null ? 0 : this.getTeammates().length);
            enemyNumAssignation = new String[totalNumOfEnemies];
        }
        this.initialize();
        while (true) {
            this.updateEnemyPositions();
            this.updateEnemyBullets();
            this.selectBehavior();
            this.executeBehavior();
            this.broadCastMyInfo();
        }
    }

    protected abstract void selectBehavior();

    protected abstract void initialize();

    private void updateEnemyPositions() {
        Rectangle2D.Double walkableBattleField = new Rectangle2D.Double(15.0, 15.0, this.getBattleFieldWidth() - 36.0 + 6.0, this.getBattleFieldHeight() - 36.0 + 6.0);
        Enumeration<BotInfo> enemies = this.botsInfo.elements();
        while (enemies.hasMoreElements()) {
            double newY;
            BotInfo botInfo = enemies.nextElement();
            double newX = Math.sin(botInfo.headingRadians) * botInfo.velocity + botInfo.x;
            Point2D.Double newPos = new Point2D.Double(newX, newY = Math.cos(botInfo.headingRadians) * botInfo.velocity + botInfo.y);
            if (!walkableBattleField.contains(newPos)) continue;
            botInfo.x = newX;
            botInfo.y = newY;
            botInfo.distance = botInfo.distance(this.getX(), this.getY());
            botInfo.bearingRadians = this.getBearing(botInfo);
        }
    }

    private void executeBehavior() {
        this.selectEnemy.select();
        this.radar.scan();
        this.gun.fire();
        this.targeting.target();
        this.movement.move();
        Iterator<Special> i = this.specials.iterator();
        while (i.hasNext()) {
            i.next().doIt();
        }
        this.execute();
    }

    private void listenEvent(Event e) {
        this.selectEnemy.listen(e);
        this.radar.listen(e);
        this.gun.listen(e);
        this.targeting.listen(e);
        this.movement.listen(e);
        Iterator<Special> i = this.specials.iterator();
        while (i.hasNext()) {
            i.next().listen(e);
        }
    }

    private void listenInputEvent(InputEvent e) {
        if (this.selectEnemy != null) {
            this.selectEnemy.listenInput(e);
        }
        if (this.radar != null) {
            this.radar.listenInput(e);
        }
        if (this.gun != null) {
            this.gun.listenInput(e);
        }
        if (this.targeting != null) {
            this.targeting.listenInput(e);
        }
        if (this.movement != null) {
            this.movement.listenInput(e);
        }
        for (Special special : this.specials) {
            if (special == null) continue;
            special.listenInput(e);
        }
    }

    public void registerBullet(Bullet bullet) {
        if (bullet != null) {
            BulletInfoEnemy friendFire = new BulletInfoEnemy();
            friendFire.isFriendFire = true;
            friendFire.isToRemove = false;
            friendFire.fromName = this.getName();
            friendFire.headingRadians = bullet.getHeadingRadians();
            friendFire.velocity = bullet.getVelocity();
            friendFire.power = bullet.getPower();
            friendFire.x = bullet.getX();
            friendFire.y = bullet.getY();
            try {
                this.broadcastMessage(friendFire);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void updateEnemyBullets() {
        Enumeration<BulletInfoEnemy> i = this.enemyBullets.elements();
        while (i.hasMoreElements()) {
            BulletInfoEnemy bullet = i.nextElement();
            bullet.x = Math.sin(bullet.headingRadians) * bullet.velocity + bullet.x;
            bullet.y = Math.cos(bullet.headingRadians) * bullet.velocity + bullet.y;
            if (battleField.contains(bullet)) continue;
            this.enemyBullets.remove(bullet);
        }
    }

    public void activate(Special special) {
        if (!this.specials.contains(special)) {
            this.specials.add(special);
        }
    }

    public void deactivate(Special special) {
        this.specials.remove(special);
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        BotInfo scanned;
        if (!this.isTeammate(e.getName())) {
            this.assignNumToEnemy(e.getName());
        }
        if ((scanned = this.botsInfo.get(e.getName())) == null) {
            scanned = new BotInfo();
        }
        scanned.teammate = this.isTeammate(e.getName());
        scanned.name = e.getName();
        scanned.bearingRadians = e.getBearingRadians();
        scanned.previousHeadingRadians = scanned.headingRadians;
        scanned.headingRadians = e.getHeadingRadians();
        scanned.distance = e.getDistance();
        scanned.x = this.getX() + e.getDistance() * Math.sin(this.getHeadingRadians() + e.getBearingRadians());
        scanned.y = this.getY() + e.getDistance() * Math.cos(this.getHeadingRadians() + e.getBearingRadians());
        scanned.velocity = e.getVelocity();
        scanned.previousEnergy = scanned.energy;
        scanned.energy = e.getEnergy();
        scanned.timeSinceLastScan = (int)e.getTime() - scanned.timeScanned;
        scanned.timeScanned = (int)e.getTime();
        this.botsInfo.put(e.getName(), scanned);
        if (!scanned.teammate) {
            try {
                this.broadcastMessage((BotInfo)scanned.clone());
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
        this.listenEvent((Event)e);
    }

    public void onCustomEvent(CustomEvent e) {
        Condition condition = e.getCondition();
        if (condition.getName().equals("EnemyFires")) {
            BulletInfoEnemy enemyBullet = new BulletInfoEnemy();
            enemyBullet.fromName = this.enemy.name;
            enemyBullet.x = this.enemy.x;
            enemyBullet.y = this.enemy.y;
            enemyBullet.power = this.enemy.previousEnergy - this.enemy.energy;
            enemyBullet.headingRadians = Utils.normalAbsoluteAngle((double)Math.atan2(this.enemy.x - this.getX(), this.enemy.y - this.getY()));
            enemyBullet.velocity = Rules.getBulletSpeed((double)enemyBullet.power);
            enemyBullet.isFriendFire = false;
            enemyBullet.isToRemove = false;
            this.enemyBullets.add(enemyBullet);
        }
        this.listenEvent((Event)e);
    }

    public void onHitByBullet(HitByBulletEvent e) {
        this.listenEvent((Event)e);
    }

    public void onHitRobot(HitRobotEvent e) {
        this.listenEvent((Event)e);
    }

    public void onHitWall(HitWallEvent e) {
        this.listenEvent((Event)e);
    }

    public void onBulletHit(BulletHitEvent e) {
        this.listenEvent((Event)e);
        Bullet bullet = e.getBullet();
        BulletInfoEnemy friendFire = new BulletInfoEnemy();
        friendFire.isFriendFire = true;
        friendFire.isToRemove = true;
        friendFire.fromName = this.getName();
        friendFire.headingRadians = bullet.getHeadingRadians();
        friendFire.velocity = bullet.getVelocity();
        friendFire.power = bullet.getPower();
        friendFire.x = bullet.getX();
        friendFire.y = bullet.getY();
        try {
            this.broadcastMessage(friendFire);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public void onBulletHitBullet(BulletHitBulletEvent e) {
        this.listenEvent((Event)e);
        Bullet bullet = e.getBullet();
        BulletInfoEnemy friendFire = new BulletInfoEnemy();
        friendFire.isFriendFire = true;
        friendFire.isToRemove = true;
        friendFire.fromName = this.getName();
        friendFire.headingRadians = bullet.getHeadingRadians();
        friendFire.velocity = bullet.getVelocity();
        friendFire.power = bullet.getPower();
        friendFire.x = bullet.getX();
        friendFire.y = bullet.getY();
        try {
            this.broadcastMessage(friendFire);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public void onBulletMissed(BulletMissedEvent e) {
        this.listenEvent((Event)e);
    }

    public void onRobotDeath(RobotDeathEvent e) {
        this.listenEvent((Event)e);
        this.botsInfo.remove(e.getName());
        this.selectEnemy.select();
    }

    public void onWin(WinEvent e) {
        this.listenEvent((Event)e);
    }

    public void onDeath(DeathEvent e) {
        this.listenEvent((Event)e);
    }

    public void onSkippedTurn(SkippedTurnEvent e) {
        System.out.println("SKIPPED TURN!!!!!!!");
        this.listenEvent((Event)e);
    }

    public void onKeyPressed(KeyEvent e) {
        int key = e.getKeyCode() - 48;
        if (key >= 0 && key <= 6) {
            debugOption = key;
        }
        this.listenInputEvent(e);
    }

    public void onKeyReleased(KeyEvent e) {
        this.listenInputEvent(e);
    }

    public void onMouseMoved(MouseEvent e) {
        this.listenInputEvent(e);
    }

    public void onMousePressed(MouseEvent e) {
        this.listenInputEvent(e);
    }

    public void onMouseReleased(MouseEvent e) {
        this.listenInputEvent(e);
    }

    public void onPaint(Graphics2D g) {
        g.setColor(Color.white);
        Enumeration<BotInfo> enemies = this.botsInfo.elements();
        while (enemies.hasMoreElements()) {
            BotInfo enemy = enemies.nextElement();
            g.draw(enemy.getBotRectangle());
        }
        if (this.enemy != null) {
            g.setColor(Color.red);
            g.draw(this.botsInfo.get(this.enemy.name).getBotRectangle());
        }
        g.setColor(Color.white);
        g.draw(battleField);
        g.drawString("Debug option= " + debugOption + "      0: All      1: SelectEnemy      2: Radar      3: Gun      4: Targeting      5: Movement      6: Specials", 15, 15);
        switch (debugOption) {
            case 0: {
                this.selectEnemy.onPaint(g);
                this.radar.onPaint(g);
                this.gun.onPaint(g);
                this.targeting.onPaint(g);
                this.movement.onPaint(g);
                Iterator<Special> i = this.specials.iterator();
                while (i.hasNext()) {
                    i.next().onPaint(g);
                }
                break;
            }
            case 1: {
                this.selectEnemy.onPaint(g);
                break;
            }
            case 2: {
                this.radar.onPaint(g);
                break;
            }
            case 3: {
                this.gun.onPaint(g);
                break;
            }
            case 4: {
                this.targeting.onPaint(g);
                break;
            }
            case 5: {
                this.movement.onPaint(g);
                break;
            }
            case 6: {
                Iterator<Special> it = this.specials.iterator();
                while (it.hasNext()) {
                    it.next().onPaint(g);
                }
                break;
            }
        }
    }

    public void onMessageReceived(MessageEvent e) {
        if (e.getMessage() instanceof BotInfo) {
            BotInfo botInfo = (BotInfo)e.getMessage();
            if (!this.isTeammate(botInfo.name)) {
                this.assignNumToEnemy(botInfo.name);
            }
            botInfo.bearingRadians = this.getBearing(botInfo);
            botInfo.distance = botInfo.distance(new Point2D.Double(this.getX(), this.getY()));
            this.botsInfo.put(botInfo.name, botInfo);
        } else if (e.getMessage() instanceof BulletInfoEnemy) {
            BulletInfoEnemy bullet = (BulletInfoEnemy)e.getMessage();
            if (!bullet.isToRemove) {
                this.enemyBullets.add(bullet);
            } else {
                Enumeration<BulletInfoEnemy> enumeration = this.enemyBullets.elements();
                while (enumeration.hasMoreElements()) {
                    BulletInfoEnemy b = enumeration.nextElement();
                    if (!b.isFriendFire || !bullet.isFriendFire || !b.fromName.equals(bullet.fromName) || b.power != bullet.power || b.headingRadians != bullet.headingRadians || !(b.distance(bullet) < 50.0)) continue;
                    this.enemyBullets.remove(b);
                }
            }
        }
        this.listenEvent((Event)e);
    }

    private void broadCastMyInfo() {
        BotInfo me = new BotInfo();
        me.teammate = true;
        me.name = this.getName();
        me.headingRadians = this.getHeadingRadians();
        me.x = this.getX();
        me.y = this.getY();
        me.velocity = this.getVelocity();
        me.energy = this.getEnergy();
        me.timeScanned = (int)this.getTime();
        try {
            this.broadcastMessage(me);
        }
        catch (IOException ex) {
            this.out.println(ex);
        }
    }

    private void assignNumToEnemy(String enemyName) {
        int i = 0;
        while (i < enemyNumAssignation.length) {
            if (enemyNumAssignation[i] == null) {
                Module.enemyNumAssignation[i] = enemyName;
                break;
            }
            ++i;
        }
    }

    public int getEnemyAssignedNum(String enemyName) {
        int i = 0;
        while (i < enemyNumAssignation.length) {
            if (enemyNumAssignation[i].equals(enemyName)) {
                return i;
            }
            ++i;
        }
        return 0;
    }

    public int getCurrentRoundScannedEnemies() {
        int counter = 0;
        Enumeration<BotInfo> botsEnum = this.botsInfo.elements();
        while (botsEnum.hasMoreElements()) {
            if (botsEnum.nextElement().teammate) continue;
            ++counter;
        }
        return counter;
    }

    public int getCurrentNumberOfEnemies() {
        int counter = 0;
        Enumeration<BotInfo> enemies = this.botsInfo.elements();
        while (enemies.hasMoreElements()) {
            BotInfo botInfo = enemies.nextElement();
            if (this.isTeammate(botInfo.name)) continue;
            ++counter;
        }
        return counter;
    }

    public int getCurrentNumberOfTeamMates() {
        int counter = 0;
        Enumeration<BotInfo> enemies = this.botsInfo.elements();
        while (enemies.hasMoreElements()) {
            BotInfo botInfo = enemies.nextElement();
            if (!this.isTeammate(botInfo.name)) continue;
            ++counter;
        }
        return counter;
    }

    public boolean isTheSameBot(String name1, String name2) {
        return name1.endsWith(")") && name2.endsWith(")") && (name1 = name1.substring(0, name1.lastIndexOf("("))).equals(name2 = name2.substring(0, name2.lastIndexOf("(")));
    }

    public int getNumberOfEnemies() {
        return this.getOthers() - (this.getTeammates() == null ? 0 : this.getTeammates().length);
    }

    public int getNumberOfTeamMates() {
        return this.getTeammates() == null ? 0 : this.getTeammates().length;
    }

    public double getBearing(Point2D.Double botInfo) {
        double thetaFireTime = Utils.normalAbsoluteAngle((double)Math.atan2(botInfo.x - this.getX(), botInfo.y - this.getY()));
        return Utils.normalRelativeAngle((double)(thetaFireTime - this.getHeadingRadians()));
    }
}

