/*
 * Decompiled with CFR 0.152.
 */
package pedersen.core;

import pedersen.core.Snapshot;
import pedersen.debug.Debug;
import pedersen.physics.StaticHeading;
import pedersen.physics.StaticPosition;
import pedersen.physics.StaticPositionImpl;
import pedersen.physics.StaticVector;
import pedersen.physics.StaticVectorImpl;
import pedersen.physics.StaticVelocity;

public class SnapshotImpl
implements Snapshot {
    private final long round;
    private final long time;
    private final StaticPosition position;
    private final StaticVector vector;
    private StaticVector vectorDelta = null;
    private final double energy;

    public SnapshotImpl(long round, long time, double _x, double _y, double _r, double _v, double _e) {
        this.round = round;
        this.time = time;
        this.position = new StaticPositionImpl(_x, _y);
        this.vector = new StaticVectorImpl(_r, _v);
        this.energy = _e;
    }

    public SnapshotImpl(Snapshot other) {
        this.round = other.getRound();
        this.time = other.getTime();
        this.position = other;
        this.vector = other;
        this.vectorDelta = other.getVectorDelta();
        this.energy = other.getEnergy();
    }

    public void debug() {
        Debug.debug("Snapshot: " + this.round + "." + this.time);
        this.position.debug();
        this.vector.debug();
        Debug.debug("energy: " + this.energy);
    }

    public long getRound() {
        return this.round;
    }

    public long getTime() {
        return this.time;
    }

    public void setVectorDelta(StaticVector newDelta) {
        this.vectorDelta = newDelta;
    }

    public StaticVector getVectorDelta() {
        return this.vectorDelta;
    }

    public double getHeadingDelta() {
        return this.vectorDelta.getHeading();
    }

    public double getVelocityDelta() {
        return this.vectorDelta.getVelocity();
    }

    public double getEnergy() {
        return this.energy;
    }

    public double getX() {
        return this.position.getX();
    }

    public double getY() {
        return this.position.getY();
    }

    public boolean equalsPosition(StaticPosition other) {
        return this.position.equalsPosition(other);
    }

    public StaticPosition getRelativePosition(StaticPosition other) {
        return this.position.getRelativePosition(other);
    }

    public StaticVector getRelativeVector(StaticPosition other) {
        return this.position.getRelativeVector(other);
    }

    public double getBearing(StaticPosition other) {
        return this.position.getBearing(other);
    }

    public double getDistance(StaticPosition other) {
        return this.position.getDistance(other);
    }

    public double getHeading() {
        return this.vector.getHeading();
    }

    public boolean equalsAngle(double other) {
        return this.vector.equalsAngle(other);
    }

    public boolean equalsAngle(StaticHeading other) {
        return this.vector.equalsAngle(other);
    }

    public double getRelativeAngle(double other) {
        return this.vector.getRelativeAngle(other);
    }

    public double getRelativeAngle(StaticHeading other) {
        return this.vector.getRelativeAngle(other);
    }

    public double getCompoundAngle(double other) {
        return this.vector.getCompoundAngle(other);
    }

    public double getCompoundAngle(StaticHeading other) {
        return this.vector.getCompoundAngle(other);
    }

    public double getVelocity() {
        return this.vector.getVelocity();
    }

    public boolean equalsVelocity(double other) {
        return this.vector.equalsVelocity(other);
    }

    public boolean equalsVelocity(StaticVelocity other) {
        return this.vector.equalsVelocity(other);
    }

    public double getRelativeVelocity(double other) {
        return this.vector.getRelativeVelocity(other);
    }

    public double getRelativeVelocity(StaticVelocity other) {
        return this.vector.getRelativeVelocity(other);
    }

    public double getCompoundVelocity(double other) {
        return this.vector.getCompoundVelocity(other);
    }

    public double getCompoundVelocity(StaticVelocity other) {
        return this.vector.getCompoundVelocity(other);
    }

    public boolean equalsVector(StaticVector other) {
        return this.vector.equalsVector(other);
    }

    public StaticVector compareVector(StaticVector other) {
        return this.vector.compareVector(other);
    }
}

