/*
 * Decompiled with CFR 0.152.
 */
package rdt.Wraith.DangerPrediction;

import rdt.Wraith.DangerPrediction.MovementCommand;
import robocode.Rules;

public final class CachedVelocityData {
    public final double Velocity;
    public final double MaxTurnDelta;
    public final double WallHitDamage;
    public final CachedVelocityData[] NextCommandResults = new CachedVelocityData[6];
    private static final double MIN_VELOCITY = -8.0;
    private static final double MAX_VELOCITY = 8.0;
    private static final double VELOCITY_ACCURACY = 0.1;
    private static final double ONE_OVER_VELOCITY_ACCURACY = 10.0;
    private static final int VELOCITY_DIVISIONS = 161;
    private static final double PI_OVER_180 = Math.PI / 180;
    private static final CachedVelocityData[] _cachedData = new CachedVelocityData[161];
    private static boolean _initialised = false;

    public CachedVelocityData(double velocity, double maxTurnDelta, double wallHitDamage) {
        this.Velocity = velocity;
        this.MaxTurnDelta = maxTurnDelta;
        this.WallHitDamage = wallHitDamage;
    }

    public static void Initialise() {
        double velocity;
        int velocityDivision;
        if (_initialised) {
            return;
        }
        for (velocityDivision = 0; velocityDivision < 161; ++velocityDivision) {
            CachedVelocityData data;
            velocity = (double)velocityDivision * 0.1 + -8.0;
            double maxTurnDelta = Math.PI / 180 * (10.0 - 0.75 * Math.abs(velocity));
            CachedVelocityData._cachedData[velocityDivision] = data = new CachedVelocityData(velocity, maxTurnDelta, Rules.getWallHitDamage((double)velocity));
        }
        for (velocityDivision = 0; velocityDivision < 161; ++velocityDivision) {
            velocity = (double)velocityDivision * 0.1 + -8.0;
            CachedVelocityData dataToFill = _cachedData[velocityDivision];
            for (int movementCommand = 0; movementCommand < 6; ++movementCommand) {
                double nextVelocity = MovementCommand.GetVelocity(movementCommand, velocity);
                int nextIndex = CachedVelocityData.GetIndex(nextVelocity);
                dataToFill.NextCommandResults[movementCommand] = _cachedData[nextIndex];
            }
        }
        _initialised = true;
    }

    private static int GetIndex(double velocity) {
        return (int)((velocity - -8.0) * 10.0 + 0.5);
    }

    public static CachedVelocityData Get(double velocity) {
        return _cachedData[CachedVelocityData.GetIndex(velocity)];
    }
}

