/*
 * Decompiled with CFR 0.152.
 */
package rdt.Wraith.Guns.GunImplementations.DC;

import java.awt.Color;
import java.awt.Graphics2D;
import rdt.Wraith.Guns.GunImplementations.DC.DCDebugGraph;
import rdt.Wraith.Guns.GunImplementations.DC.GuessFactorPayload;
import rdt.Wraith.Guns.GunImplementations.Segmented.GuessFactor.KernelDensity;
import rdt.Wraith.IDebugDrawer;
import rdt.Wraith.IRobot;
import rdt.Wraith.KDTree.KdTree;

public class DCDebug
implements IDebugDrawer {
    private final int GraphWidth = 300;
    private final int GraphHeight = 50;
    private final int GraphGap = 10;
    private final int GraphX;
    private final int BattlefieldHeight;
    private final KdTree<GuessFactorPayload> _tree;
    private final DCDebugGraph[] _graphs;
    private int _insertionIndex = 0;

    public DCDebug(IRobot robot, KdTree<GuessFactorPayload> tree) {
        this._tree = tree;
        this.BattlefieldHeight = (int)robot.getBattleFieldHeight();
        this.GraphX = (int)robot.getBattleFieldWidth() - 10 - 300;
        int numGraphs = (int)Math.floor((this.BattlefieldHeight - 20) / 60);
        this._graphs = new DCDebugGraph[numGraphs];
        int currentY = 10;
        for (int index = 0; index < numGraphs; ++index) {
            this._graphs[index] = new DCDebugGraph(this.GraphX, currentY, 300, 50);
            robot.RegisterDebugDrawer(this._graphs[index]);
            currentY += 60;
        }
        robot.RegisterDebugDrawer(this);
    }

    @Override
    public void DebugDraw(Graphics2D gfx) {
        gfx.setColor(Color.white);
        gfx.drawString("Tree Size: " + this._tree.size(), this.GraphX, this.BattlefieldHeight - 20);
    }

    public void OnDataRetrieved(KernelDensity kernelDensity) {
        this._graphs[this._insertionIndex].SetKernelDensity(kernelDensity);
        ++this._insertionIndex;
        if (this._insertionIndex >= this._graphs.length) {
            this._insertionIndex = 0;
        }
    }
}

