/*
 * Decompiled with CFR 0.152.
 */
package tk;

import robocode.AdvancedRobot;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;

public class BotOX
extends AdvancedRobot {
    private String targetRobotName;
    private double targetBearing;
    private double targetDistance;
    private boolean update;

    public void run() {
        this.setTurnRadarRightRadians(Double.POSITIVE_INFINITY);
        double v = 100.0;
        while (true) {
            if (this.update) {
                double direction;
                this.update = false;
                if (this.targetDistance > 150.0) {
                    this.setAhead(100.0);
                    direction = this.targetBearing;
                } else {
                    this.setAhead(100.0);
                    direction = this.targetBearing - 90.0;
                }
                if (this.targetDistance < 200.0) {
                    this.setFire(3.0);
                }
                if ((direction = this.normalize(direction)) > 0.0) {
                    this.setTurnRight(direction);
                } else {
                    this.setTurnLeft(-direction);
                }
                double gun = this.getHeading() - this.getGunHeading() + this.targetBearing;
                gun = this.normalize(gun);
                if (gun > 0.0) {
                    this.setTurnGunRight(gun);
                } else {
                    this.setTurnGunLeft(-gun);
                }
                System.out.println("turn: " + direction + " turn gun: " + gun);
            }
            this.execute();
        }
    }

    public void onScannedRobot(ScannedRobotEvent event) {
        if (this.targetRobotName == null) {
            this.targetRobotName = event.getName();
            System.out.println("found target: " + this.targetRobotName);
        } else if (this.targetDistance > event.getDistance()) {
            this.targetRobotName = event.getName();
        }
        if (event.getName().equals(this.targetRobotName)) {
            this.targetBearing = event.getBearing();
            this.targetDistance = event.getDistance();
            this.update = true;
        }
    }

    public void onRobotDeath(RobotDeathEvent event) {
        if (event.getName().equals(this.targetRobotName)) {
            this.targetRobotName = null;
        }
    }

    private double normalize(double deg) {
        double o = Math.floor(Math.abs(deg / 360.0));
        o = deg - Math.signum(deg) * o * 360.0;
        if (o > 180.0) {
            o -= 360.0;
        } else if (o < -180.0) {
            o += 360.0;
        }
        return o;
    }
}

