/*
 * Decompiled with CFR 0.152.
 */
package rdt199.movement;

import java.util.Enumeration;
import java.util.Vector;
import rdt199.gun.CircularMode;
import rdt199.gun.GunMode;
import rdt199.gun.ShootingLocation;
import rdt199.gun.StraightMode;
import rdt199.gun.VelocityAverageCircularMode;
import rdt199.movement.GravityBullet;
import rdt199.movement.GravityPoint;
import rdt199.movement.MoveMode;
import rdt199.movement.MovementManager;
import rdt199.util.BotFuncs;
import rdt199.util.Location;
import rdt199.util.RobotLog;
import rdt199.util.RobotSnapshot;

public class GravityDodgeMode
extends MoveMode {
    protected Vector m_Bullets = new Vector();
    protected GravityPoint m_RandomLocation;

    public GravityDodgeMode(MovementManager manager) {
        super(manager);
    }

    public double getScore() {
        if (BotFuncs.m_AdvancedRobot.getOthers() < 2) {
            return 100.0;
        }
        return 0.0;
    }

    public void update() {
        this.updateBullets();
        this.addBullets();
        BotFuncs.m_AdvancedRobot.setMaxVelocity(8.0);
        Location MyLoc = new Location(BotFuncs.m_AdvancedRobot.getX(), BotFuncs.m_AdvancedRobot.getY());
        double dTargetAngle = this.getTargetAbsBearingDegrees();
        double dTargetDistance = BotFuncs.getDistanceBetween(MyLoc, this.getTargetLocation());
        double dDistanceOffset = 300.0 - dTargetDistance;
        double dAngleOffset = 90.0 + Math.random() * 10.0 - 5.0;
        if (dTargetDistance > 350.0) {
            dAngleOffset += 10.0;
        } else if (dTargetDistance < 300.0) {
            dAngleOffset -= 10.0;
        }
        double dNormalAngle1 = BotFuncs.normaliseAbsDegrees(dTargetAngle + dAngleOffset);
        double dNormalAngle2 = BotFuncs.normaliseAbsDegrees(dTargetAngle - dAngleOffset);
        dNormalAngle1 = Math.toRadians(dNormalAngle1);
        dNormalAngle2 = Math.toRadians(dNormalAngle2);
        Location Loc1 = new Location(60.0 * Math.sin(dNormalAngle1) + MyLoc.getX(), 60.0 * Math.cos(dNormalAngle1) + MyLoc.getY());
        Location Loc2 = new Location(60.0 * Math.sin(dNormalAngle2) + MyLoc.getX(), 60.0 * Math.cos(dNormalAngle2) + MyLoc.getY());
        Loc1 = BotFuncs.adjustForWalls(Loc1);
        Loc2 = BotFuncs.adjustForWalls(Loc2);
        double dGravity1 = this.calcGravity(Loc1);
        double dGravity2 = this.calcGravity(Loc2);
        this.updateRandomPoint();
        if ((dGravity1 += this.calcRandomGravity(Loc1)) == 0.0 && (dGravity2 += this.calcRandomGravity(Loc2)) == 0.0) {
            BotFuncs.m_AdvancedRobot.setMaxVelocity(4.0);
            this.m_MoveManager.setTarget(Loc1);
            return;
        }
        if (dGravity1 < dGravity2) {
            this.m_MoveManager.setTarget(Loc1);
        } else {
            this.m_MoveManager.setTarget(Loc2);
        }
    }

    public void close() {
    }

    protected void addBullets() {
        double dFirepower = this.checkFire();
        if (dFirepower < 0.0) {
            return;
        }
        GravityBullet GB = this.getBullet(new StraightMode(BotFuncs.getSelfLog()), dFirepower);
        if (GB != null) {
            this.m_Bullets.add(GB);
        }
        if ((GB = this.getBullet(new CircularMode(BotFuncs.getSelfLog()), dFirepower)) != null) {
            this.m_Bullets.add(GB);
        }
        if ((GB = this.getBullet(new VelocityAverageCircularMode(BotFuncs.getSelfLog()), dFirepower)) != null) {
            this.m_Bullets.add(GB);
        }
    }

    protected void updateBullets() {
        Enumeration Enum2 = this.m_Bullets.elements();
        while (Enum2.hasMoreElements()) {
            GravityBullet GB = (GravityBullet)Enum2.nextElement();
            GB.update();
            if (GB.isAlive()) continue;
            this.m_Bullets.remove(GB);
        }
    }

    protected double calcGravity(Location loc) {
        Enumeration Enum2 = this.m_Bullets.elements();
        double dGravity = 0.0;
        while (Enum2.hasMoreElements()) {
            GravityBullet GB = (GravityBullet)Enum2.nextElement();
            dGravity += GB.getGravity(loc);
        }
        return dGravity += this.getTargetGravity(loc);
    }

    protected double getTargetGravity(Location loc) {
        GravityPoint GP = new GravityPoint(this.getTargetLocation(), 10000.0);
        return GP.getGravity(loc);
    }

    protected void updateRandomPoint() {
        if (BotFuncs.m_AdvancedRobot.getTime() % 20L == 0L) {
            Location Loc = new Location(BotFuncs.m_AdvancedRobot.getX() + Math.random() * 20.0 - 10.0, BotFuncs.m_AdvancedRobot.getY() + Math.random() * 20.0 - 10.0);
            this.m_RandomLocation = new GravityPoint(Loc, 10.0);
        }
    }

    protected double calcRandomGravity(Location loc) {
        if (this.m_RandomLocation != null) {
            return this.m_RandomLocation.getGravity(loc);
        }
        return 0.0;
    }

    protected double getTargetAbsBearingDegrees() {
        Location Loc = this.getTargetLocation();
        if (Loc == null) {
            return BotFuncs.m_AdvancedRobot.getHeading();
        }
        double dAngleRadians = BotFuncs.getAbsBearing(new Location(BotFuncs.m_AdvancedRobot.getX(), BotFuncs.m_AdvancedRobot.getY()), Loc);
        return Math.toDegrees(dAngleRadians);
    }

    protected Location getTargetLocation() {
        RobotLog Target = BotFuncs.getTarget();
        if (Target == null) {
            return null;
        }
        RobotSnapshot Snap = Target.get(0);
        if (Snap == null) {
            return null;
        }
        return Snap.m_Location;
    }

    protected GravityBullet getBullet(GunMode mode, double firepower) {
        mode.calcPredictedLocation(BotFuncs.getTarget().get((int)0).m_Location, firepower);
        ShootingLocation Loc = mode.getPredictedLocation();
        if (Loc == null) {
            return null;
        }
        Loc.setX(Loc.getX() + (Math.random() * 20.0 - 10.0));
        Loc.setY(Loc.getY() + (Math.random() * 20.0 - 10.0));
        return new GravityBullet(Loc, new Location(BotFuncs.m_AdvancedRobot.getX(), BotFuncs.m_AdvancedRobot.getY()), firepower);
    }

    protected double checkFire() {
        RobotLog Target = BotFuncs.getTarget();
        if (Target == null) {
            return -1.0;
        }
        RobotSnapshot Snap0 = Target.get(0);
        if (Snap0 == null) {
            return -1.0;
        }
        RobotSnapshot Snap1 = Target.get(1);
        if (Snap1 == null) {
            return -1.0;
        }
        double dEnergyDiff = Snap1.m_dEnergy - Snap0.m_dEnergy;
        if (BotFuncs.getHitTarget()) {
            dEnergyDiff -= BotFuncs.getTargetDamage();
        }
        if (dEnergyDiff >= 0.1 && dEnergyDiff <= 3.0) {
            return dEnergyDiff;
        }
        return -1.0;
    }
}

