/*
 * Decompiled with CFR 0.152.
 */
package eem.bot;

import eem.core.CoreBot;
import eem.misc.math;
import eem.misc.physics;
import eem.misc.profiler;
import java.awt.geom.Point2D;
import robocode.AdvancedRobot;
import robocode.ScannedRobotEvent;

public class botStatPoint {
    private Point2D.Double pos = new Point2D.Double(0.0, 0.0);
    private long tStamp = 0L;
    private Point2D.Double velocity = new Point2D.Double(0.0, 0.0);
    private double headingDegrees = 0.0;
    private double energy = 0.0;
    private double myBotGunHeat = 0.0;
    private double dist2WallAhead = 0.0;
    private double dist2myBot = 0.0;
    private double latteralVelocity = 0.0;

    public botStatPoint() {
    }

    public botStatPoint(AdvancedRobot advancedRobot, ScannedRobotEvent scannedRobotEvent) {
        this();
        double d;
        double d2;
        Point2D.Double double_ = new Point2D.Double();
        double_.x = advancedRobot.getX();
        double_.y = advancedRobot.getY();
        double d3 = Math.toRadians(advancedRobot.getHeading() + scannedRobotEvent.getBearing());
        this.dist2myBot = d2 = scannedRobotEvent.getDistance();
        this.pos = new Point2D.Double(double_.x + Math.sin(d3) * d2, double_.y + Math.cos(d3) * d2);
        this.tStamp = advancedRobot.getTime();
        this.headingDegrees = scannedRobotEvent.getHeading();
        double d4 = scannedRobotEvent.getVelocity();
        this.velocity = new Point2D.Double(d4 * Math.sin(Math.toRadians(this.headingDegrees)), d4 * Math.cos(Math.toRadians(this.headingDegrees)));
        this.energy = scannedRobotEvent.getEnergy();
        this.myBotGunHeat = advancedRobot.getGunHeat();
        this.dist2WallAhead = this.distanceToWallAhead();
        double d5 = scannedRobotEvent.getBearingRadians() + advancedRobot.getHeadingRadians();
        this.latteralVelocity = d = scannedRobotEvent.getVelocity() * Math.sin(scannedRobotEvent.getHeadingRadians() - d5);
    }

    public botStatPoint(CoreBot coreBot) {
        this();
        this.pos.x = coreBot.getX();
        this.pos.y = coreBot.getY();
        this.tStamp = coreBot.getTime();
        this.headingDegrees = coreBot.getHeading();
        double d = coreBot.getVelocity();
        this.velocity = new Point2D.Double(d * Math.sin(Math.toRadians(this.headingDegrees)), d * Math.cos(Math.toRadians(this.headingDegrees)));
        this.energy = coreBot.getEnergy();
        this.dist2WallAhead = this.distanceToWallAhead();
    }

    public botStatPoint(Point2D.Double double_, long l) {
        this();
        this.tStamp = l;
        this.pos = double_;
    }

    public Double getDistanceToWallAhead() {
        return this.dist2WallAhead;
    }

    public Double getDistance(Point2D.Double double_) {
        return double_.distance(this.pos);
    }

    public String format() {
        String string = "";
        string = string + "tStamp = " + this.tStamp;
        string = string + ", ";
        string = string + "position = " + this.pos;
        string = string + ", ";
        string = string + "energy = " + this.energy;
        string = string + ", ";
        string = string + "velocity = " + this.velocity;
        string = string + ", ";
        string = string + "heading = " + this.headingDegrees;
        string = string + ", ";
        string = string + "distance to " + this.whichWallAhead() + " wall ahead = " + this.getDistanceToWallAhead();
        string = string + ", ";
        string = string + "distance to myBot = " + this.dist2myBot + ", lateral velocity  = " + this.latteralVelocity;
        return string;
    }

    public long getTime() {
        return this.tStamp;
    }

    public double getEnergy() {
        return this.energy;
    }

    public double getX() {
        return this.pos.x;
    }

    public double getY() {
        return this.pos.y;
    }

    public double getHeadingDegrees() {
        return this.headingDegrees;
    }

    public double getHeadingRadians() {
        return Math.toRadians(this.headingDegrees);
    }

    public double getSpeed() {
        return this.velocity.distance(0.0, 0.0);
    }

    public Point2D.Double getVelocity() {
        return (Point2D.Double)this.velocity.clone();
    }

    public Point2D.Double getPosition() {
        return (Point2D.Double)this.pos.clone();
    }

    public double getDistanceToMyBot() {
        return this.dist2myBot;
    }

    public double getLatteralVelocity() {
        return this.latteralVelocity;
    }

    public Double getMyBotGunHeat() {
        return this.myBotGunHeat;
    }

    public boolean arePointsOfPathSimilar(botStatPoint botStatPoint2, botStatPoint botStatPoint3, botStatPoint botStatPoint4) {
        profiler.start("arePointsOfPathSimilar");
        double d = 80.0;
        double d2 = 4.0;
        double d3 = 0.2;
        double d4 = 0.5;
        double d5 = 50.0;
        double d6 = 2.0;
        double d7 = 10.0;
        double d8 = this.getSpeed();
        double d9 = this.getHeadingDegrees() - botStatPoint4.getHeadingDegrees();
        double d10 = this.getDistanceToMyBot();
        long l = this.getTime() - botStatPoint4.getTime();
        double d11 = this.getDistanceToWallAhead();
        double d12 = this.latteralVelocity;
        double d13 = botStatPoint3.getSpeed();
        double d14 = botStatPoint3.getHeadingDegrees() - botStatPoint2.getHeadingDegrees();
        double d15 = botStatPoint3.getDistanceToMyBot();
        long l2 = botStatPoint3.getTime() - botStatPoint2.getTime();
        double d16 = botStatPoint3.getDistanceToWallAhead();
        double d17 = botStatPoint3.getLatteralVelocity();
        boolean bl = true;
        if (Math.abs(d8 - d13) > d4 || Math.abs(math.shortest_arc(d9 - d14)) > d7 || Math.abs(d12 - d17) > d6) {
            bl = false;
        } else if (l != l2) {
            bl = false;
        } else if (Math.min(d16, d11) < d && Math.abs(d11 - d16) > d2) {
            bl = false;
        }
        profiler.stop("arePointsOfPathSimilar");
        return bl;
    }

    public String whichWallAhead(botStatPoint botStatPoint2) {
        return physics.whichWallAhead(botStatPoint2.getPosition(), botStatPoint2.getSpeed(), botStatPoint2.getHeadingRadians());
    }

    public String whichWallAhead() {
        return this.whichWallAhead(this);
    }

    public double distanceToWallAhead(botStatPoint botStatPoint2) {
        return physics.distanceToWallAhead(botStatPoint2.getPosition(), botStatPoint2.getSpeed(), botStatPoint2.getHeadingRadians());
    }

    public double distanceToWallAhead() {
        return this.distanceToWallAhead(this);
    }
}

