/*
 * Decompiled with CFR 0.152.
 */
package sim;

import execution.IDrawable;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import math.Vect2d;
import robocode.Rules;
import sim.BulletRay;
import util.Bounds;

public class Wave
implements IDrawable {
    public WaveKind status;
    public Point2D.Double center;
    public double outerRadius;
    public double bulletPower;
    public Vect2d bearing;
    private double _bulletVelocity;
    private double _innerRadius;
    private long _flightTime;
    public String identifier;
    private BulletRay _zero;
    private Ellipse2D.Double _innerRing;
    private Ellipse2D.Double outerRing;

    public Wave(double bulletPower, Point2D.Double position, String robotName, Vect2d bearing, long firingTime) {
        this._bulletVelocity = Rules.getBulletSpeed((double)bulletPower);
        this.bulletPower = bulletPower;
        this.bearing = bearing;
        this.bearing.setMagnitude(this._bulletVelocity);
        this._zero = new BulletRay(position, this.bearing);
        this._flightTime = 0L;
        this.center = new Point2D.Double();
        this.center.setLocation(position);
        this.status = WaveKind.Live;
        this._innerRing = new Ellipse2D.Double(this.center.getX(), this.center.getY(), 0.0, 0.0);
        this.outerRing = new Ellipse2D.Double(this.center.getX(), this.center.getY(), 0.0, 0.0);
        this.identifier = robotName + "@" + firingTime;
    }

    public void Update() {
        this._innerRadius = this._bulletVelocity * (double)(++this._flightTime);
        this.outerRadius = this._innerRadius + this._bulletVelocity;
        double outerWidth = 2.0 * this.outerRadius;
        double innerWidth = 2.0 * this._innerRadius;
        this._zero.Update();
        this._innerRing.x = this.center.getX() - this._innerRadius;
        this._innerRing.y = this.center.getY() - this._innerRadius;
        this._innerRing.height = innerWidth;
        this._innerRing.width = innerWidth;
        this.outerRing.x = this.center.getX() - this.outerRadius;
        this.outerRing.y = this.center.getY() - this.outerRadius;
        this.outerRing.height = outerWidth;
        this.outerRing.width = outerWidth;
    }

    public boolean contains(Bounds box) {
        return box.InsideCircle(this._innerRing);
    }

    public boolean intersects(Bounds box) {
        return box.IntersectsCircle(this.outerRing) || box.IntersectsCircle(this._innerRing);
    }

    public double getOuterEdgeDistance(double x, double y) {
        return this.center.distance(x, y) - this.outerRadius;
    }

    @Override
    public void Draw(Graphics2D e) {
        Color previous = e.getColor();
        if (this.status == WaveKind.Neutralized) {
            e.setColor(Color.GRAY);
        }
        e.draw(this.outerRing);
        e.setColor(previous);
        this._zero.Draw(e);
    }

    public static enum WaveKind {
        Live,
        Neutralized,
        Speculative,
        Crested;

    }
}

