/*
 * Decompiled with CFR 0.152.
 */
package jcs;

import java.awt.Color;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import robocode.AdvancedRobot;
import robocode.BulletHitEvent;
import robocode.Condition;
import robocode.DeathEvent;
import robocode.HitByBulletEvent;
import robocode.ScannedRobotEvent;
import robocode.WinEvent;
import robocode.util.Utils;

public class Megatron
extends AdvancedRobot {
    static final double MAX_VELOCITY = 8.0;
    static final double MAX_WALL_SMOOTH_TRIES = 150.0;
    static final double PI = Math.PI;
    static final int SEARCH_DEPTH = 30;
    static final int MOVEMENT_LENGTH = 150;
    static final int BULLET_SPEED = 11;
    static final int MAX_RANGE = 900;
    static final int SEARCH_END_BUFFER = 111;
    static final int DISTANCE_BINS = 5;
    static final int VELOCITY_BINS = 5;
    static final int WALL_INDEXES = 4;
    static final int VCHANGE_TIME_INDEXES = 6;
    static final int FACTORS = 31;
    static final int MIDDLE_FACTOR = 15;
    static int[][][][][][] gunFactors = new int[5][5][5][6][4][31];
    static int[][][][] moveFactors = new int[5][5][5][31];
    static int[] locationBins = new int[31];
    static double dangerForward;
    static double dangerReverse;
    static double dangerStop;
    static EnemyBulletBin currentShot;
    static int hisShots;
    static int myShots;
    static int myHits;
    static int hisHits;
    static double powerLost;
    static double powerGained;
    static Enemy target;
    static double fieldWidth;
    static double fieldHeight;
    static double tWidth;
    static Rectangle2D fieldRectangle;
    static Point2D robotLocation;
    static Point2D enemyLocation;
    static double enemyAbsoluteBearing;
    static double enemyDistance;
    static int distanceIndex;
    static int velocityIndex;
    static int enemyTimeSinceVChange;
    static double enemyBearingDirection;
    static double firePower;
    static double maxPower;
    static boolean triedToRam;
    static int lastRobotVelocityIndex;
    static double robotVelocity;
    static int enemyHits;
    static double[] arcLength;
    static int historyIndex;
    static StringBuffer patternMatcher;

    public void run() {
        this.setAdjustRadarForGunTurn(true);
        this.setAdjustGunForRobotTurn(true);
        target = new Enemy();
        Megatron.target.distance = 100000.0;
        fieldWidth = this.getBattleFieldWidth();
        fieldHeight = this.getBattleFieldHeight();
        fieldRectangle = new Rectangle2D.Double(tWidth, tWidth, fieldWidth - tWidth * 2.0, fieldHeight - tWidth * 2.0);
        triedToRam = false;
        this.setColors(Color.red, Color.orange, Color.yellow);
        currentShot = null;
        this.turnRadarRightRadians(Math.PI * 2);
        while (true) {
            this.doFirePower();
            this.doScanner();
            this.execute();
        }
    }

    void doFirePower() {
        double myAvgHitPower = powerGained / (double)(myHits + 1);
        double hisAvgHitPower = powerLost / (double)(hisHits + 1);
        double hitPercent = (double)myHits / (double)(myShots + 1);
        double hisPercent = (double)hisHits / (double)(hisShots + 1);
        firePower = Megatron.target.distance < 200.0 ? 3.0 : 1.9;
        if (hitPercent > hisPercent && myAvgHitPower < hisAvgHitPower) {
            firePower *= hisAvgHitPower * 2.5 / myAvgHitPower;
        }
        if (hitPercent > 0.33) {
            firePower = 3.0;
        } else if (firePower > 3.0) {
            firePower = 3.0;
        }
        firePower = Math.min(this.getEnergy() / 4.0, firePower);
        maxPower = firePower = Math.min(Megatron.target.energy + 0.2, firePower);
        if (hitPercent < 0.15 && hitPercent < hisPercent && myAvgHitPower > hisAvgHitPower) {
            firePower *= hisAvgHitPower * 0.5 / myAvgHitPower;
        }
        if (firePower < 0.1) {
            firePower = 0.1;
        }
        if (maxPower < 0.1) {
            maxPower = 0.1;
        }
    }

    void doScanner() {
        double radarOffset;
        if (this.getTime() - Megatron.target.ctime > 4L) {
            radarOffset = Math.PI * 4;
        } else {
            radarOffset = this.getRadarHeadingRadians() - (1.5707963267948966 - Math.atan2(Megatron.target.y - this.getY(), Megatron.target.x - this.getX()));
            radarOffset = (radarOffset = this.NormaliseBearing(radarOffset)) < 0.0 ? (radarOffset -= 0.15707963267948966) : (radarOffset += 0.15707963267948966);
        }
        this.setTurnRadarLeftRadians(radarOffset);
    }

    public void onHitByBullet(HitByBulletEvent e) {
        double power = e.getPower();
        EnemyBulletBin wave = currentShot;
        if (wave != null) {
            wave.registerVisits(++enemyHits);
        }
        Megatron.target.energy += power * 3.0;
        powerLost += power;
        ++hisHits;
    }

    public void onBulletHit(BulletHitEvent e) {
        double power = e.getBullet().getPower();
        double damage = Math.max(4.0 * power, 6.0 * power - 2.0);
        Megatron.target.energy -= damage;
        powerGained += power;
        ++myHits;
    }

    public void onWin(WinEvent e) {
        double myAvgHitPower = powerGained / (double)(myHits + 1);
        double hisAvgHitPower = powerLost / (double)(hisHits + 1);
        int hitPercent = myHits * 100 / (myShots + 1);
        int hisPercent = hisHits * 100 / (hisShots + 1);
        this.out.println("My% " + hitPercent + "  His%= " + hisPercent + "  Me=" + myAvgHitPower + "  him=" + hisAvgHitPower);
        this.out.println("Shots taken " + myShots + "  Detected " + hisShots);
        this.out.println("Hits " + myHits + "   Been hit " + hisHits);
    }

    public void onDeath(DeathEvent e) {
        double myAvgHitPower = powerGained / (double)(myHits + 1);
        double hisAvgHitPower = powerLost / (double)(hisHits + 1);
        int hitPercent = myHits * 100 / (myShots + 1);
        int hisPercent = hisHits * 100 / (hisShots + 1);
        this.out.println("My% " + hitPercent + "  His%= " + hisPercent + "  Me=" + myAvgHitPower + "  him=" + hisAvgHitPower);
        this.out.println("Shots taken " + myShots + "  Detected " + hisShots);
        this.out.println("Hits " + myHits + "   Been hit " + hisHits);
        if (triedToRam) {
            this.out.println("===BAD MOVE...RAMMING===");
        }
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        double absbearing_rad = (this.getHeadingRadians() + e.getBearingRadians()) % (Math.PI * 2);
        Megatron.target.name = e.getName();
        Megatron.target.ctime = this.getTime();
        Megatron.target.distance = e.getDistance();
        Megatron.target.deltaEnergy = Megatron.target.energy - e.getEnergy();
        Megatron.target.energy = e.getEnergy();
        Megatron.target.speedDelta = Megatron.target.speed - e.getVelocity();
        Megatron.target.speed = e.getVelocity();
        Megatron.target.x = this.getX() + Math.sin(absbearing_rad) * Megatron.target.distance;
        Megatron.target.y = this.getY() + Math.cos(absbearing_rad) * Megatron.target.distance;
        BulletBin wave = new BulletBin();
        EnemyBulletBin ew = new EnemyBulletBin();
        ew.gunLocation = new Point2D.Double(enemyLocation.getX(), enemyLocation.getY());
        ew.startBearing = ew.gunBearing(robotLocation);
        if (Megatron.target.deltaEnergy > 0.0 && Megatron.target.deltaEnergy <= 3.0) {
            Megatron.target.firePower = Megatron.target.deltaEnergy;
            ew.dodgeThisScan = true;
            ++hisShots;
        }
        ew.bulletVelocity = 20.0 - 3.0 * Megatron.target.firePower;
        double direction = this.robotBearingDirection(ew.startBearing);
        ew.bearingDirection = Math.asin(8.0 / ew.bulletVelocity) * direction / 15.0;
        distanceIndex = (int)Math.min(4.0, enemyDistance / 180.0);
        int[][] nArray = moveFactors[distanceIndex][lastRobotVelocityIndex];
        lastRobotVelocityIndex = (int)Math.abs(robotVelocity / 2.0);
        ew.visits = nArray[lastRobotVelocityIndex];
        robotVelocity = this.getVelocity();
        ew.targetLocation = robotLocation;
        robotLocation.setLocation(new Point2D.Double(this.getX(), this.getY()));
        enemyAbsoluteBearing = this.getHeadingRadians() + e.getBearingRadians();
        wave.gunLocation = new Point2D.Double(this.getX(), this.getY());
        enemyLocation.setLocation(Megatron.project(wave.gunLocation, enemyAbsoluteBearing, enemyDistance));
        wave.targetLocation = enemyLocation;
        enemyDistance = e.getDistance();
        ew.advance(2);
        this.addCustomEvent(ew);
        if (Megatron.target.speedDelta != 0.0) {
            enemyTimeSinceVChange = 0;
        }
        wave.bulletVelocity = 20.0 - 3.0 * firePower;
        if (Megatron.target.speed != 0.0) {
            enemyBearingDirection = 0.7 * (double)Megatron.sign(Megatron.target.speed * Math.sin(e.getHeadingRadians() - enemyAbsoluteBearing));
        }
        wave.bearingDirection = enemyBearingDirection / 15.0;
        wave.startBearing = enemyAbsoluteBearing;
        int wallIndex = 0;
        while (++wallIndex < 4 && fieldRectangle.contains(Megatron.project(wave.gunLocation, wave.startBearing + wave.bearingDirection * ((double)wallIndex * 5.5), enemyDistance))) {
        }
        int[][][][] nArray2 = gunFactors[distanceIndex][velocityIndex];
        velocityIndex = (int)Math.abs(Megatron.target.speed / 2.0);
        wave.visits = nArray2[velocityIndex][(int)Megatron.minMax(Math.pow(enemyTimeSinceVChange++, 0.45) - 1.0, 0.0, 5.0)][--wallIndex];
        if (historyIndex > 99000) {
            patternMatcher.setLength(121);
        }
        historyIndex = patternMatcher.length();
        double targetBearing = e.getBearingRadians() + this.getHeadingRadians();
        double arcMovement = e.getVelocity() * Math.sin(e.getHeadingRadians() - targetBearing);
        Megatron.arcLength[Megatron.historyIndex + 1] = arcLength[historyIndex] + arcMovement;
        patternMatcher.append((char)arcMovement);
        int searchDepth = 30;
        int matchIndex = 0;
        double bspeed = 20.0 - 3.0 * maxPower;
        while ((matchIndex = patternMatcher.lastIndexOf(patternMatcher.substring(historyIndex - --searchDepth), historyIndex - 111)) < 0) {
        }
        matchIndex += searchDepth;
        wave.mostVisited();
        if (searchDepth >= 20) {
            this.setTurnGunRightRadians(Math.sin((arcLength[matchIndex + (int)(e.getDistance() / bspeed)] - arcLength[matchIndex]) / e.getDistance() + targetBearing - this.getGunHeadingRadians()));
            firePower = maxPower;
        } else {
            this.setTurnGunRightRadians(Utils.normalRelativeAngle((double)(enemyAbsoluteBearing - this.getGunHeadingRadians() + wave.bearingDirection * (double)(wave.mostVisited() - 15))));
        }
        this.addCustomEvent(wave);
        if (this.getEnergy() >= firePower && this.getGunHeat() == 0.0 && firePower > 0.0 && Math.abs(this.getGunTurnRemainingRadians()) < Math.atan2(tWidth, enemyDistance)) {
            this.setFire(firePower);
            ++myShots;
        }
        if (dangerReverse < dangerForward) {
            direction = -direction;
        }
        double angle = wave.gunBearing(Megatron.wallSmoothedDestination(robotLocation, direction)) - this.getHeadingRadians();
        this.setAhead(Math.cos(angle) * 100.0);
        this.setTurnRightRadians(Math.tan(angle));
        dangerStop = 0.0;
        dangerReverse = 0.0;
        dangerForward = 0.0;
    }

    static Point2D wallSmoothedDestination(Point2D location, double direction) {
        Point2D destination;
        double smoothing;
        int i = 1;
        do {
            for (smoothing = 0.0; !fieldRectangle.contains(destination = Megatron.project(location, Megatron.absoluteBearing(location, enemyLocation) - direction * ((1.25 - smoothing / 100.0) * Math.PI / 2.0), 135.0)) && smoothing < 150.0; smoothing += 1.0) {
            }
            direction = -direction;
        } while (i-- > 0 && distanceIndex < 1 && smoothing > 27.0);
        return destination;
    }

    void updateDirectionStats(EnemyBulletBin wave) {
        dangerReverse += wave.danger(this.waveImpactLocation(wave, -1.0, 5.0));
        dangerForward += wave.danger(this.waveImpactLocation(wave, 1.0, 0.0));
        dangerStop += wave.danger(this.waveImpactLocation(wave, 0.0, 2.0));
    }

    Point2D waveImpactLocation(EnemyBulletBin wave, double direction, double timeOffset) {
        Point2D impactLocation = new Point2D.Double(this.getX(), this.getY());
        double time = timeOffset;
        while (wave.distanceFromTarget(impactLocation = Megatron.project(impactLocation, Megatron.absoluteBearing(impactLocation, Megatron.wallSmoothedDestination(impactLocation, direction * this.robotBearingDirection(wave.gunBearing(robotLocation)))), 8.0), (int)(time += 1.0)) > -10.0) {
        }
        return impactLocation;
    }

    double robotBearingDirection(double enemyBearing) {
        return Megatron.sign(this.getVelocity() * Math.sin(this.getHeadingRadians() - enemyBearing));
    }

    static Point2D project(Point2D sourceLocation, double angle, double length) {
        return new Point2D.Double(sourceLocation.getX() + Math.sin(angle) * length, sourceLocation.getY() + Math.cos(angle) * length);
    }

    static double absoluteBearing(Point2D source, Point2D target) {
        return Math.atan2(target.getX() - source.getX(), target.getY() - source.getY());
    }

    static int sign(double v) {
        return v < 0.0 ? -1 : 1;
    }

    double NormaliseBearing(double ang) {
        if (ang > Math.PI) {
            ang -= Math.PI * 2;
        }
        if (ang < -Math.PI) {
            ang += Math.PI * 2;
        }
        return ang;
    }

    static double minMax(double v, double min, double max) {
        return Math.max(min, Math.min(max, v));
    }

    static {
        hisShots = 0;
        myShots = 0;
        myHits = 0;
        hisHits = 0;
        powerLost = 0.0;
        powerGained = 0.0;
        tWidth = 18.5;
        robotLocation = new Point2D.Double();
        enemyLocation = new Point2D.Double();
        enemyHits = 100;
        arcLength = new double[100000];
        historyIndex = 0;
        patternMatcher = new StringBuffer("\u0000\u0003\u0006\u0001\u0004\u0007\u0002\u0005\b\uffff\ufffc\ufff9\ufffe\ufffb\ufff8\ufffd\ufffaThis space filler for end buffer.The numbers up top assure a 1 length match every time.  This string must be longer than SEARCH_END_BUFFER. Given my adjustments it is a bit longer than before.");
    }

    class EnemyBulletBin
    extends BulletBin {
        boolean dodgeThisScan;

        EnemyBulletBin() {
        }

        public boolean test() {
            this.advance(1);
            if (this.passed(-18.0)) {
                this.dodgeThisScan = false;
                currentShot = this;
            }
            if (this.passed(18.0)) {
                Megatron.this.removeCustomEvent(this);
            }
            if (this.dodgeThisScan) {
                Megatron.this.updateDirectionStats(this);
            }
            return false;
        }

        double danger(Point2D destination) {
            double smoothed = 0.0;
            int i = 0;
            do {
                smoothed += ((double)locationBins[i] + (double)this.visits[i] * 200.0) / Math.sqrt((double)Math.abs(this.visitingIndex(destination) - i) + 1.0);
            } while (++i < 31);
            return smoothed / Math.sqrt(Math.abs(this.distanceFromTarget(this.targetLocation, 0)) / this.bulletVelocity);
        }
    }

    class BulletBin
    extends Condition {
        double bulletVelocity;
        Point2D gunLocation;
        Point2D targetLocation;
        double startBearing;
        double bearingDirection;
        int[] visits;
        double distanceFromGun;
        double guessGoodness;

        BulletBin() {
        }

        public boolean test() {
            this.advance(1);
            if (this.passed(-18.0)) {
                if (Megatron.this.getOthers() > 0) {
                    this.registerVisits(1);
                }
                Megatron.this.removeCustomEvent(this);
            }
            return false;
        }

        public boolean passed(double distanceOffset) {
            return this.distanceFromGun > this.gunLocation.distance(this.targetLocation) + distanceOffset;
        }

        void advance(int ticks) {
            this.distanceFromGun += (double)ticks * this.bulletVelocity;
        }

        int visitingIndex(Point2D target) {
            return (int)Megatron.minMax(Math.round(Utils.normalRelativeAngle((double)(this.gunBearing(target) - this.startBearing)) / this.bearingDirection + 15.0), 0.0, 30.0);
        }

        void registerVisits(int count) {
            int index;
            int n = index = this.visitingIndex(this.targetLocation);
            this.visits[n] = this.visits[n] + count;
            int n2 = index;
            locationBins[n2] = locationBins[n2] + count;
        }

        double gunBearing(Point2D target) {
            return Megatron.absoluteBearing(this.gunLocation, target);
        }

        double distanceFromTarget(Point2D location, int timeOffset) {
            return this.gunLocation.distance(location) - this.distanceFromGun - (double)timeOffset * this.bulletVelocity;
        }

        int mostVisited() {
            int mostVisited = 15;
            int i = 30;
            int totalVisits = 0;
            int numEntries = 0;
            int visVal = 0;
            do {
                if (this.visits[i] > 0) {
                    totalVisits += this.visits[i];
                    ++numEntries;
                }
                if (this.visits[--i] <= this.visits[mostVisited]) continue;
                visVal = this.visits[i];
                mostVisited = i;
            } while (i > 0);
            if (numEntries > 0) {
                double avg = totalVisits / numEntries;
                this.guessGoodness = (double)visVal / avg;
            }
            return mostVisited;
        }
    }

    class Enemy {
        String name;
        public long ctime;
        public double distance;
        public double energy;
        public double deltaEnergy;
        public double x;
        public double y;
        public double firePower;
        public double speed;
        public double speedDelta;

        Enemy() {
        }
    }
}

