/*
 * Decompiled with CFR 0.152.
 */
package agd.radar;

import agd.radar.RadarStrategy;
import agd.util.AdvancedRobotAdapter;
import agd.util.AdvancedRobotListener;
import agd.util.Compass;
import agd.util.Coord;
import agd.util.Enemy;
import agd.util.RobotInformation;
import java.util.Map;
import robocode.AdvancedRobot;
import robocode.RadarTurnCompleteCondition;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;

public class SingleTargetRadarLock
extends AdvancedRobotAdapter
implements RadarStrategy,
AdvancedRobotListener {
    AdvancedRobot robot = null;
    RobotInformation robotinfo = null;
    Enemy target = null;
    long timeLast360 = 0L;
    static final int FULL_SCAN_PERIOD = 30;

    public SingleTargetRadarLock(RobotInformation ourrobot) {
        this.robot = ourrobot.getAdvancedRobot();
        this.robotinfo = ourrobot;
        ourrobot.addListener(this);
    }

    public void setPrimaryTarget(Enemy e) {
        this.target = e;
    }

    public void onScannedRobot(ScannedRobotEvent sre) {
        Map enemies;
        if (this.target == null && (enemies = this.robotinfo.getEnemies()).containsKey(sre.getName())) {
            this.target = (Enemy)enemies.get(sre.getName());
        }
    }

    public void onRobotDeath(RobotDeathEvent rde) {
        if (this.target != null && rde.getName() == this.target.getName()) {
            this.target = null;
        }
    }

    public double getRadarBearing() {
        RadarTurnCompleteCondition radarStationary = new RadarTurnCompleteCondition(this.robot);
        double bearing = 0.0;
        if (radarStationary.test()) {
            if (this.target == null) {
                bearing = 360.0;
                this.timeLast360 = this.robot.getTime();
            } else if (this.robot.getOthers() > 1 && this.robot.getTime() - this.timeLast360 > 30L) {
                bearing = 360.0;
                this.timeLast360 = this.robot.getTime();
            } else {
                long timeSinceLastSighting = this.robot.getTime() - this.target.getLastSighting().getScannedRobotEvent().getTime();
                double swing = 1L + Math.min(timeSinceLastSighting, 179L);
                swing = Math.max(9.0, swing);
                Coord ourPosition = this.robotinfo.getPosition();
                Coord estimatedPosition = this.target.estimateLinearPos(this.robot.getTime() + 1L);
                Compass heading = ourPosition.headingTo(estimatedPosition);
                bearing += (bearing = new Compass(this.robot.getRadarHeading()).bearingTo(heading)) < 0.0 ? 0.0 - swing : swing;
            }
        }
        return bearing;
    }

    static {
        FULL_SCAN_PERIOD = 30;
    }
}

