/*
 * Decompiled with CFR 0.152.
 */
package agd.util;

import agd.predict.Footprint;
import agd.util.Compass;
import agd.util.Coord;
import agd.util.Enemy;
import robocode.Robot;
import robocode.ScannedRobotEvent;

public class RobotSighting
implements Footprint {
    Coord theirPosition = null;
    Coord ourPosition = null;
    double ourHeading = 0.0;
    double headingToTarget = 0.0;
    double acceleration;
    ScannedRobotEvent scannedRobotEvent = null;
    Coord clipMin = null;
    Coord clipMax = null;

    public RobotSighting(ScannedRobotEvent sre, Robot me, Enemy enemy) {
        this.ourPosition = new Coord(me.getX(), me.getY());
        Compass headingToTarget = new Compass(me.getHeading() + sre.getBearing());
        this.theirPosition = this.ourPosition.applyVector(headingToTarget, sre.getDistance());
        this.scannedRobotEvent = sre;
        this.clipMin = this.theirPosition;
        this.clipMax = this.theirPosition;
        RobotSighting previousSighting = enemy.getLastSighting();
        this.acceleration = previousSighting == null ? 0.0 : (sre.getVelocity() - previousSighting.getVelocity()) / (double)(sre.getTime() - previousSighting.getTime());
    }

    public Coord getTheirPosition() {
        return this.theirPosition;
    }

    public Coord getOurPosition() {
        return this.ourPosition;
    }

    public double getHeadingToTarget() {
        return this.headingToTarget;
    }

    public ScannedRobotEvent getScannedRobotEvent() {
        return this.scannedRobotEvent;
    }

    public String toString() {
        return this.scannedRobotEvent.getName() + " " + this.scannedRobotEvent.getTime() + " ticks, at " + this.theirPosition + " (we're at " + this.ourPosition + "deg, compass bearing = " + (int)this.headingToTarget;
    }

    public void setClipMin(Coord min) {
        this.clipMin = min;
    }

    public void setClipMax(Coord max) {
        this.clipMax = max;
    }

    public Coord getClipMin() {
        return this.clipMin;
    }

    public Coord getClipMax() {
        return this.clipMax;
    }

    public long getTime() {
        return this.scannedRobotEvent.getTime();
    }

    public Coord getPosition() {
        return this.theirPosition;
    }

    public Compass getHeading() {
        return new Compass(this.scannedRobotEvent.getHeading());
    }

    public double getVelocity() {
        return this.scannedRobotEvent.getVelocity();
    }

    public double getAcceleration() {
        return this.acceleration;
    }
}

