/*
 * Decompiled with CFR 0.152.
 */
package benhorner.utility.units;

import benhorner.utility.units.Bearing;
import benhorner.utility.units.Duration;
import benhorner.utility.units.Heading;
import benhorner.utility.units.RelativeLocation;
import benhorner.utility.units.Speed;
import benhorner.utility.units.Units;

public class Velocity {
    protected Heading heading;
    protected Speed speed;

    public Velocity(Heading heading, Speed speed) {
        this.heading = heading;
        this.speed = speed;
    }

    public Velocity(double heading_degrees, double speed) {
        this(new Heading(heading_degrees), new Speed(speed));
    }

    public Heading getHeading() {
        return this.heading;
    }

    public Speed getSpeed() {
        return this.speed;
    }

    public Speed getXSpeed() {
        return this.speed.multiply(Units.sin(this.heading.toAngle()));
    }

    public Speed getYSpeed() {
        return this.speed.multiply(Units.cos(this.heading.toAngle()));
    }

    public RelativeLocation multiply(Duration duration) {
        return new RelativeLocation(this.heading, this.speed.multiply(duration));
    }

    public Bearing getMaxTurn() {
        return this.speed.getMaxTurn();
    }

    public String toString() {
        return "<" + this.heading + ", " + Math.round(this.speed.toDouble()) + ">";
    }

    public boolean equals(Object o) {
        boolean result;
        boolean bl = result = o.getClass() == this.getClass();
        if (result) {
            Velocity velocity = (Velocity)o;
            result = velocity.heading.equals(this.heading) && velocity.speed.equals(this.speed);
        }
        return result;
    }

    public int hashCode() {
        return this.heading.hashCode() * 31 + this.speed.hashCode();
    }
}

