/*
 * Decompiled with CFR 0.152.
 */
package sp.Minis;

import java.awt.Color;
import java.util.ArrayList;
import robocode.AdvancedRobot;
import robocode.HitByBulletEvent;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;

public class geneticBot
extends AdvancedRobot {
    static ArrayList<moveStrategy> mSArray = new ArrayList();
    static boolean hasMadeStrategies = false;
    int strategyNum = 35;
    int currentStrategyNum = 0;
    int refineNumber = 1;
    static moveStrategy currentMove;
    double firePower = 3.0;
    int shotCounter = 1;
    ScannedRobotEvent eScan;

    public void run() {
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        Color darkGreen = new Color(0, 100, 0);
        Color lightGreen = new Color(0, 255, 0);
        this.setColors(darkGreen, lightGreen, darkGreen);
        this.setScanColor(darkGreen);
        this.setBulletColor(lightGreen);
        while (true) {
            if (!hasMadeStrategies) {
                this.makeStrategies();
                hasMadeStrategies = true;
            }
            this.turnRadarRightRadians(Math.PI * 2);
        }
    }

    public void makeStrategies() {
        for (int i = 0; i < this.strategyNum; ++i) {
            mSArray.add(new moveStrategy());
        }
    }

    public void makeSpecializedStrategies(moveStrategy m) {
        for (int i = 0; i < this.strategyNum; ++i) {
            mSArray.add(new moveStrategy(m));
        }
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        this.eScan = e;
        double radarTurn = Utils.normalRelativeAngle((double)(e.getBearingRadians() + this.getHeadingRadians() - this.getRadarHeadingRadians()));
        if (mSArray.size() == 0) {
            this.makeSpecializedStrategies(currentMove);
            ++this.refineNumber;
        }
        if (this.getTurnRemaining() == 0.0 && this.getDistanceRemaining() == 0.0) {
            ++this.currentStrategyNum;
            if (this.currentStrategyNum >= mSArray.size() - 1) {
                this.currentStrategyNum = 0;
            }
            mSArray.get(this.currentStrategyNum).execute();
            currentMove = mSArray.get(this.currentStrategyNum);
        }
        this.firePower = 1000.0 / e.getDistance();
        double gunTurn = Utils.normalRelativeAngle((double)(this.getHeadingRadians() + e.getBearingRadians() - this.getGunHeadingRadians()));
        if (!e.getName().contains("genetic")) {
            this.setTurnRadarRightRadians(radarTurn * 2.0);
            this.setTurnGunRightRadians(this.getPredictiveShotAngle(e) / (double)this.shotCounter + gunTurn);
            if (this.getGunHeat() == 0.0) {
                this.setFire(this.firePower);
                ++this.shotCounter;
                if (this.shotCounter > 5) {
                    this.shotCounter = 1;
                }
            }
        } else {
            this.turnRadarRight(90.0);
        }
    }

    public double getPredictiveShotAngle(ScannedRobotEvent e) {
        double bVel = 20.0 - 3.0 * this.firePower;
        double absoluteBearing = this.getHeadingRadians() + e.getBearingRadians();
        double gunTurn = Utils.normalRelativeAngle((double)(e.getVelocity() * Math.sin(e.getHeadingRadians() - absoluteBearing) / bVel));
        return gunTurn;
    }

    public void onHitByBullet(HitByBulletEvent e) {
        mSArray.remove(currentMove);
    }

    public class moveStrategy {
        double aheadAmount;
        double turnAmount;

        public moveStrategy() {
            this.aheadAmount = (Math.random() - 0.5) * 500.0;
            this.turnAmount = Math.toRadians((Math.random() - 0.5) * 100.0);
        }

        public moveStrategy(moveStrategy m) {
            double randomNum = 1.0 + (Math.random() - 0.5) / (double)geneticBot.this.refineNumber;
            this.aheadAmount = m.getAheadAmount() * randomNum;
            this.turnAmount = m.getTurnAmount() * randomNum;
        }

        public double getAheadAmount() {
            return this.aheadAmount;
        }

        public double getTurnAmount() {
            return this.turnAmount;
        }

        public void execute() {
            geneticBot.this.out.println("turnamount = " + this.turnAmount);
            geneticBot.this.setTurnRightRadians(geneticBot.this.eScan.getBearingRadians() + 1.5707963267948966 + this.turnAmount);
            geneticBot.this.setAhead(this.aheadAmount);
        }
    }
}

