/*
 * Decompiled with CFR 0.152.
 */
package knackibot;

import java.util.ArrayList;
import java.util.List;
import knackibot.Enemy;
import knackibot.KnackOnOne;
import knackibot.MyUtils;
import knackibot.TargetStrategy;
import knackibot.WaveBullet;
import robocode.util.Utils;

public class GuessFactorTargeting
implements TargetStrategy {
    List<WaveBullet> g_waves = new ArrayList<WaveBullet>();
    static int[][] stats = new int[3][31];
    int direction = 1;
    private String name = "GF-Targeting";

    private double calcFirepower(Enemy enemy) {
        double firepower = 0.0;
        firepower = enemy.getEnergy() < 16.0 ? (enemy.getEnergy() < 4.0 ? enemy.getEnergy() / 4.0 : enemy.getEnergy() / 6.0) : 1.9;
        return firepower;
    }

    private int accelSegment(double deltaBearing, double oldDeltaBearing, double enemyDistance) {
        int delta = (int)Math.round(5.0 * enemyDistance * (Math.abs(deltaBearing) - Math.abs(oldDeltaBearing)));
        if (delta < 0) {
            return 0;
        }
        if (delta > 0) {
            return 2;
        }
        return 1;
    }

    @Override
    public void shoot(Enemy enemy, KnackOnOne me) {
        double absBearing = me.getHeadingRadians() + enemy.getBearingRadians();
        int i = 0;
        while (i < this.g_waves.size()) {
            WaveBullet currentWave = this.g_waves.get(i);
            if (currentWave.checkHit(enemy.getCurrentPosition().x, enemy.getCurrentPosition().y, me.getTime())) {
                this.g_waves.remove(currentWave);
                --i;
            }
            ++i;
        }
        double power = Math.min(3.0, Math.max(0.1, this.calcFirepower(enemy)));
        if (enemy.getVelocity() != 0.0) {
            this.direction = Math.sin(me.getHeadingRadians() - absBearing) * enemy.getVelocity() < 0.0 ? -1 : 1;
        }
        int[] currentStats = stats[this.accelSegment(enemy.getBearingRadians(), enemy.getLastBearingRadians(), enemy.getDistance())];
        WaveBullet newWave = new WaveBullet(me.getX(), me.getY(), absBearing, enemy.getEnergy(), this.direction, me.getTime(), currentStats);
        int bestindex = 15;
        int i2 = 0;
        while (i2 < 31) {
            if (currentStats[bestindex] < currentStats[i2]) {
                bestindex = i2;
            }
            ++i2;
        }
        double guessfactor = (double)(bestindex - (currentStats.length - 1) / 2) / (double)((currentStats.length - 1) / 2);
        double angleOffset = (double)this.direction * guessfactor * MyUtils.maxEscapeAngle(power);
        double gunAdjust = Utils.normalRelativeAngle((double)(absBearing - me.getGunHeadingRadians() + angleOffset));
        me.setTurnGunRightRadians(gunAdjust);
        if (me.getGunHeat() == 0.0 && gunAdjust < Math.atan2(9.0, enemy.getDistance()) && me.setFireBullet(power) != null) {
            this.g_waves.add(newWave);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }
}

