/*
 * Decompiled with CFR 0.152.
 */
package pa3k;

import java.util.HashMap;
import java.util.Map;
import pa3k.BulletTracking;
import pa3k.Log;
import pa3k.ScoreKeeperBin;

public class ScoreKeeper {
    public static int MAX_DISTANCE = 600;
    public static int BINS = 4;
    protected ScoreKeeperBin[] bins;
    private static Map<String, ScoreKeeperBin[]> dataIncoming = null;
    private static Map<String, ScoreKeeperBin[]> dataOutgoing = null;

    public ScoreKeeper(String string, boolean bl) {
        if (dataIncoming == null) {
            dataIncoming = new HashMap<String, ScoreKeeperBin[]>();
        }
        if (dataOutgoing == null) {
            dataOutgoing = new HashMap<String, ScoreKeeperBin[]>();
        }
        Map<String, ScoreKeeperBin[]> map = dataIncoming;
        if (bl) {
            map = dataOutgoing;
        }
        if (map.containsKey(string)) {
            this.bins = map.get(string);
        } else {
            this.bins = new ScoreKeeperBin[BINS];
            for (int i = 0; i < this.bins.length; ++i) {
                this.bins[i] = new ScoreKeeperBin();
            }
            map.put(string, this.bins);
        }
    }

    public void hit(BulletTracking bulletTracking) {
        this.getBin(bulletTracking.getSource().distance(bulletTracking.getTarget())).hit(bulletTracking.getEnergy());
    }

    private ScoreKeeperBin getBin(double d) {
        int n = (int)(d / (double)(MAX_DISTANCE / BINS));
        if (n >= BINS) {
            n = BINS - 1;
        }
        ScoreKeeperBin scoreKeeperBin = this.bins[n];
        return scoreKeeperBin;
    }

    public void miss(BulletTracking bulletTracking) {
        this.getBin(bulletTracking.getSource().distance(bulletTracking.getTarget())).miss(bulletTracking.getEnergy());
    }

    public String toString() {
        String string = MAX_DISTANCE + "(" + BINS + "):";
        for (ScoreKeeperBin scoreKeeperBin : this.bins) {
            string = string + " " + scoreKeeperBin;
        }
        return string;
    }

    public double getScore(double d) {
        ScoreKeeperBin scoreKeeperBin = this.getBin(d);
        return scoreKeeperBin.countScore();
    }

    public double getKellyCriterion(double d) {
        ScoreKeeperBin scoreKeeperBin = this.getBin(d);
        return scoreKeeperBin.countKellyCriterion();
    }

    public double getBestDistance(ScoreKeeper scoreKeeper) {
        double d = Double.MIN_VALUE;
        int n = 0;
        for (int i = 0; i < this.bins.length; ++i) {
            double d2 = 0.2;
            if (this.bins[i].getPoints() > 3 && scoreKeeper.bins[i].getPoints() > 3) {
                d2 = this.bins[i].countScore() - scoreKeeper.bins[i].countScore();
            }
            if (!(d2 > d)) continue;
            d = d2;
            n = i;
        }
        double d3 = (double)(MAX_DISTANCE / BINS) * ((double)n + 0.5);
        Log.log(4, "Desired distance " + d3 + " (" + this.bins[n].countScore() + " - " + scoreKeeper.bins[n].countScore() + ")");
        return d3;
    }

    public int getPoints(double d) {
        return this.getBin(d).getPoints();
    }

    public int getPoints() {
        int n = 0;
        for (int i = 0; i < this.bins.length; ++i) {
            n += this.bins[i].getPoints();
        }
        return n;
    }
}

