/*
 * Decompiled with CFR 0.152.
 */
package stordy;

import java.awt.Color;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.Hashtable;
import stordy.ForcePoint;
import stordy.TargetingData;
import stordy.Vec2d;
import stordy.VirtualBullet;

public class VirtualBulletHandler {
    private static VirtualBulletHandler vbh = new VirtualBulletHandler();
    private TargetingData myTargetingData;
    private Hashtable<String, TargetingData> enemyTargetingData;
    private ArrayList<VirtualBullet> virtualBullets;

    public static VirtualBulletHandler getHandler() {
        return vbh;
    }

    private VirtualBulletHandler() {
    }

    public void setup(TargetingData tg, Hashtable<String, TargetingData> etg) {
        this.myTargetingData = tg;
        this.enemyTargetingData = etg;
        this.virtualBullets = new ArrayList();
    }

    public void bulletFired(String source, double firePower, long currentTime) {
        TargetingData etg = this.enemyTargetingData.get(source);
        Vec2d myPredictedPosition = this.myTargetingData.getPredictedPosition(etg.getLastPosition(), 0, firePower);
        double bulletSpeed = 20.0 - 3.0 * firePower;
        Vec2d bulletMoveVec = myPredictedPosition.subtract(etg.getLastPosition()).normalize().multiply(bulletSpeed);
        this.virtualBullets.add(new VirtualBullet(etg.getLastPosition(), bulletMoveVec, currentTime, myPredictedPosition));
        Vec2d bulletMoveVec2 = myPredictedPosition.subtract(this.myTargetingData.getLastPosition()).normalize().multiply(bulletSpeed);
        this.virtualBullets.add(new VirtualBullet(etg.getLastPosition(), bulletMoveVec2, currentTime, this.myTargetingData.getLastPosition()));
    }

    public void drawBullets(Graphics2D g2, long cTime) {
        for (VirtualBullet b : this.virtualBullets) {
            g2.setColor(Color.red);
            Vec2d pH = b.getPredictedHitPosition();
            Vec2d pF = b.getFirePosition();
            g2.drawOval((int)pH.getX() - 4, (int)pH.getY() - 4, 8, 8);
            g2.drawLine((int)pH.getX(), (int)pH.getY(), (int)pF.getX(), (int)pF.getY());
            g2.setColor(Color.orange);
            for (ForcePoint fp : b.getGravPoints(cTime)) {
                fp.drawForce(g2);
            }
        }
    }

    public ArrayList<ForcePoint> getBulletForces(long currentTime) {
        ArrayList<ForcePoint> fpa = new ArrayList<ForcePoint>();
        for (VirtualBullet b : this.virtualBullets) {
            fpa.addAll(b.getGravPoints(currentTime));
        }
        return fpa;
    }

    public void update(long currentTime) {
        int i = 0;
        while (i < this.virtualBullets.size()) {
            if (!this.virtualBullets.get(i).stillValid(currentTime)) {
                this.virtualBullets.remove(i);
                --i;
            }
            ++i;
        }
    }
}

