/*
 * Decompiled with CFR 0.152.
 */
package eem.gun;

import eem.EvBot;
import eem.gun.baseGun;
import eem.gun.misc;
import eem.misc.logger;
import eem.misc.math;
import eem.misc.physics;
import eem.target.InfoBot;
import java.awt.Color;
import java.awt.geom.Point2D;
import robocode.util.Utils;

public class randomGun
extends baseGun {
    protected Point2D.Double randOffset;

    public randomGun(EvBot evBot) {
        this.myBot = evBot;
        this.gunName = "random";
        this.gunColor = new Color(255, 255, 255, 128);
        this.randOffset = new Point2D.Double(0.0, 0.0);
        this.calcGunSettings();
    }

    @Override
    protected Point2D.Double calcTargetFuturePosition(Point2D.Double double_, double d, InfoBot infoBot) {
        if (!this.gunHasTargetPoint) {
            this.targetFuturePosition = math.putWithinBorders(this.findTargetHitPositionWithRandomPredictor(d, infoBot), this.myBot.BattleField);
            this.randOffset.x = this.targetFuturePosition.x - infoBot.getX();
            this.randOffset.y = this.targetFuturePosition.y - infoBot.getY();
            this.gunHasTargetPoint = true;
        } else {
            this.targetFuturePosition.x = infoBot.getX() + this.randOffset.x;
            this.targetFuturePosition.y = infoBot.getY() + this.randOffset.y;
        }
        return this.targetFuturePosition;
    }

    public Point2D.Double findTargetHitPositionWithRandomPredictor(double d, InfoBot infoBot) {
        double d2;
        double d3;
        double d4;
        double d5 = physics.bulletSpeed(d);
        logger.noise("Bullet speed " + d5);
        Point2D.Double double_ = infoBot.getVelocity();
        logger.noise("Target velocity " + double_.x + ", " + double_.y);
        double d6 = Math.sqrt(double_.x * double_.x + double_.y * double_.y);
        if (!Utils.isNear((double)d6, (double)0.0)) {
            d4 = double_.x / d6;
            d3 = double_.y / d6;
        } else {
            d6 = 1.0E-5;
            double d7 = Math.PI * 2 * Math.random();
            d4 = Math.cos(d7);
            d3 = Math.sin(d7);
        }
        double d8 = infoBot.getX() + double_.x * (double)(this.myBot.getTime() - infoBot.getLastSeenTime());
        double d9 = infoBot.getY() + double_.y * (double)(this.myBot.getTime() - infoBot.getLastSeenTime());
        logger.noise("Target estimated current position Tx = " + d8 + " Ty = " + d9);
        double d10 = Math.random();
        if (d10 > 0.99) {
            d2 = 2.0 * (Math.random() - 0.5);
            d6 = (1.0 + d2 * 8.0) * d6;
        } else {
            d6 = d2 = 2.0 * this.gun_rand.nextGaussian();
        }
        logger.noise("guessed speed coefficient = " + d2);
        if (d6 == 0.0) {
            d6 = 0.1;
        }
        d6 = Math.max(-8.0, d6);
        d6 = Math.min(8.0, d6);
        double_.x = d4 * d6;
        double_.y = d3 * d6;
        Point2D.Double double_2 = misc.linear_predictor(d5, new Point2D.Double(d8, d9), double_, this.myBot.myCoord);
        double_2 = this.futureTargetWithinPhysicalLimitsBasedOnVelocity(double_2, double_);
        logger.noise("Predicted and boxed target position " + double_2.x + ", " + double_2.y);
        return double_2;
    }
}

