/*
 * Decompiled with CFR 0.152.
 */
package dmonner.xlbp.trial;

import dmonner.xlbp.Network;
import dmonner.xlbp.stat.TrialStat;
import dmonner.xlbp.trial.Step;
import dmonner.xlbp.trial.TrialRecord;
import java.util.ArrayList;
import java.util.List;

public class Trial {
    private final Network meta;
    private final List<Step> steps;
    private TrialStat evaluation;
    private TrialRecord recording;
    private boolean clear;
    private boolean evaluate;
    private boolean record;
    private boolean clearInputs;
    private boolean known;

    public Trial(Network meta) {
        this.meta = meta;
        this.steps = new ArrayList<Step>();
        this.clear = true;
        this.clearInputs = true;
        this.evaluate = true;
        this.record = true;
        this.known = false;
    }

    public void clear() {
        this.evaluation = null;
        this.recording = null;
        for (Step step : this.steps) {
            step.clear();
        }
    }

    public Step currentStep() {
        return this.steps.get(this.steps.size() - 1);
    }

    public boolean equals(Object other) {
        if (super.equals(other)) {
            return true;
        }
        if (other instanceof Trial) {
            Trial that = (Trial)other;
            if (this.steps.size() != that.steps.size()) {
                return false;
            }
            for (int i = 0; i < this.steps.size(); ++i) {
                if (this.steps.get(i).equals(that.steps.get(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public TrialStat evaluate() {
        this.evaluation = this.makeEvaluation();
        return this.evaluation;
    }

    public boolean getClear() {
        return this.clear;
    }

    public boolean getClearInputs() {
        return this.clearInputs;
    }

    public boolean getEvaluate() {
        return this.evaluate;
    }

    public boolean getKnown() {
        return this.known;
    }

    public TrialStat getLastEvaluation() {
        return this.evaluation;
    }

    public TrialRecord getLastRecording() {
        return this.recording;
    }

    public Network getMetaNetwork() {
        return this.meta;
    }

    public boolean getRecord() {
        return this.record;
    }

    public List<Step> getSteps() {
        return this.steps;
    }

    public int hashCode() {
        int code = 0;
        for (Step step : this.steps) {
            code += step.hashCode();
        }
        return code;
    }

    public void initialize() {
        this.evaluation = null;
        this.recording = null;
        this.steps.clear();
    }

    public boolean isTrainTrial() {
        return this.known;
    }

    public void log() {
        for (Step step : this.steps) {
            for (int t = 0; t < step.getNetwork().nTarget(); ++t) {
                step.addRecordLayer(step.getNetwork().getTargetLayer(t));
            }
        }
    }

    protected TrialStat makeEvaluation() {
        return new TrialStat(this);
    }

    protected TrialRecord makeRecord() {
        return new TrialRecord(this);
    }

    protected Step makeStep() {
        return new Step(this);
    }

    public Step nextStep() {
        Step step = this.makeStep();
        this.steps.add(step);
        return step;
    }

    public TrialRecord record() {
        this.recording = this.makeRecord();
        return this.recording;
    }

    public void run() {
        this.run(false);
    }

    public void run(boolean train) {
        if (this.clear) {
            this.meta.clear();
        }
        for (Step step : this.steps) {
            if (this.clearInputs) {
                this.meta.clearInputs();
            }
            if (train) {
                step.train();
                continue;
            }
            step.run();
        }
        if (this.evaluate) {
            this.evaluate();
        }
        if (this.record) {
            this.record();
        }
    }

    public void setClear(boolean clear) {
        this.clear = clear;
    }

    public void setClearInputs(boolean clearInputs) {
        this.clearInputs = clearInputs;
    }

    public void setEvaluate(boolean evaluate) {
        this.evaluate = evaluate;
        for (Step step : this.steps) {
            step.setEvaluate(evaluate);
        }
    }

    public void setKnown(boolean known) {
        this.known = known;
    }

    public void setRecord(boolean record) {
        this.record = record;
        for (Step step : this.steps) {
            step.setRecord(record);
        }
    }

    public int size() {
        return this.steps.size();
    }

    public void test() {
        this.run(false);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        return sb.toString();
    }

    public void train() {
        this.run(true);
    }
}

