/*
 * Decompiled with CFR 0.152.
 */
package mb.guns;

import java.awt.Color;
import java.awt.Graphics2D;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import mb.MBRobot;
import mb.core.Coordinates;
import mb.core.XComparer;
import mb.core.YComparer;
import mb.guns.Gun;
import mb.utils.MathUtils;
import mb.waves.Wave;
import mb.waves.WaveStorage;
import robocode.AdvancedRobot;
import robocode.Condition;
import robocode.GunTurnCompleteCondition;
import robocode.ScannedRobotEvent;

public class LinearTargetingGunExperimental
extends Gun {
    private WaveStorage waveStorage = new WaveStorage();

    public LinearTargetingGunExperimental(MBRobot me) {
        super(me);
    }

    @Override
    public void fire(ScannedRobotEvent event) {
        double bulletPower = this.getBulletPowerFromScannedDistance(event);
        Coordinates myCoords = this.getMyCoordinates();
        Coordinates enemyCoordinates = MathUtils.getEnemyCoordinates(myCoords, this.getHeading(), event.getBearing(), event.getDistance());
        Wave wave = new Wave(0L, bulletPower, myCoords, enemyCoordinates, event.getHeading(), event.getDistance());
        Coordinates future = enemyCoordinates;
        int i = 1;
        while (i < 100) {
            future = this.getFutureRobotCoordinates(event, i);
            if (wave.checkHit(future, i)) break;
            ++i;
        }
        Coordinates futureRobotCoordinates = future;
        this.paintOriginal(futureRobotCoordinates);
        List<Coordinates> diffVectors = this.waveStorage.getDiffVectors(event.getHeading(), event.getDistance());
        Coordinates diff = this.getDiffVector(diffVectors);
        futureRobotCoordinates.Add(diff);
        double angleGun = this.getGunBearingToCoordinates(futureRobotCoordinates);
        this.setTurnGunRight(angleGun);
        if (this.getGunHeat() == 0.0) {
            this.waitFor((Condition)new GunTurnCompleteCondition((AdvancedRobot)this.getRobot()));
            this.setFire(bulletPower);
        }
        this.waveStorage.newWave(this.getTime(), bulletPower, new Coordinates(this.getX(), this.getY()), futureRobotCoordinates, event.getHeading(), event.getDistance());
        this.paintDiffs(futureRobotCoordinates, diffVectors);
    }

    @Override
    public void onScannedRobot(ScannedRobotEvent event) {
        Coordinates enemyCoords = MathUtils.getEnemyCoordinates(this.getMyCoordinates(), this.getHeading(), event.getBearing(), event.getDistance());
        this.waveStorage.checkWaves(enemyCoords, this.getTime());
        super.onScannedRobot(event);
    }

    private double getGunBearingToCoordinates(Coordinates coord) {
        double x = this.getX() - coord.getX();
        double y = this.getY() - coord.getY();
        double angle = Math.toDegrees(Math.atan(y / x));
        angle = Math.signum(-x) * 90.0 - this.getGunHeading() - angle;
        if (Math.abs(angle) > 180.0) {
            angle = 360.0 - Math.abs(angle);
        }
        return angle;
    }

    private Coordinates getFutureRobotCoordinates(ScannedRobotEvent event, double time) {
        Coordinates enemy = MathUtils.getEnemyCoordinates(this.getMyCoordinates(), this.getHeading(), event.getBearing(), event.getDistance());
        enemy.xmax = this.battleFieldWidth;
        enemy.ymax = this.battleFieldHeight;
        double a2 = Math.toRadians(event.getHeading() % 360.0);
        double movedx = Math.sin(a2) * event.getVelocity() * time;
        double movedy = Math.cos(a2) * event.getVelocity() * time;
        Coordinates moved = new Coordinates(movedx, movedy);
        enemy.Add(moved);
        return enemy;
    }

    private void paintDiffs(Coordinates target, List<Coordinates> formerDiffs) {
        Graphics2D graphics = this.getRobot().getGraphics();
        graphics.setColor(Color.BLUE);
        graphics.fillOval((int)target.getX(), (int)target.getY(), 6, 6);
        graphics.setColor(Color.magenta);
        for (Coordinates diff : formerDiffs) {
            graphics.fillOval((int)(target.getX() + diff.getX()), (int)(target.getY() + diff.getY()), 3, 3);
        }
    }

    private void paintOriginal(Coordinates target) {
        Graphics2D graphics = this.getRobot().getGraphics();
        graphics.setColor(Color.yellow);
        graphics.fillOval((int)target.getX(), (int)target.getY(), 6, 6);
    }

    private Coordinates getAverage(List<Coordinates> diffVectors) {
        double averageX = 0.0;
        double averageY = 0.0;
        for (Coordinates coordinates : diffVectors) {
            averageX += coordinates.getX();
            averageY += coordinates.getY();
        }
        if (diffVectors.size() > 0) {
            averageX /= (double)diffVectors.size();
            averageY /= (double)diffVectors.size();
        }
        Coordinates average = new Coordinates(averageX, averageY);
        return average;
    }

    private Coordinates getDiffVector(List<Coordinates> diffVectors) {
        if (diffVectors.size() < 3) {
            return new Coordinates(0.0, 0.0);
        }
        if (diffVectors.size() < 6) {
            return this.getAverage(diffVectors);
        }
        return this.getMedian(diffVectors);
    }

    private Coordinates getMedian(List<Coordinates> diffVectors) {
        int n;
        double medianX = 0.0;
        double medianY = 0.0;
        Comparator<Coordinates> comparer = new XComparer();
        Collections.sort(diffVectors, comparer);
        if (diffVectors.size() % 2 == 0) {
            n = diffVectors.size() / 2;
            medianX = 0.5 * (diffVectors.get(n - 1).getX() + diffVectors.get(n).getX());
        } else {
            n = (diffVectors.size() + 1) / 2;
            medianX = diffVectors.get(n - 1).getX();
        }
        comparer = new YComparer();
        Collections.sort(diffVectors, comparer);
        if (diffVectors.size() % 2 == 0) {
            n = diffVectors.size() / 2;
            medianY = 0.5 * (diffVectors.get(n - 1).getY() + diffVectors.get(n).getY());
        } else {
            n = (diffVectors.size() + 1) / 2;
            medianY = diffVectors.get(n - 1).getY();
        }
        Coordinates median = new Coordinates(medianX, medianY);
        return median;
    }
}

