/*
 * Decompiled with CFR 0.152.
 */
package dk.tactics;

import dk.Base;
import dk.Enemy;
import dk.config.Config;
import dk.config.SemiAgressive;
import dk.tactics.Tactics;
import robocode.RobotDeathEvent;

public class BasicMelee
extends Tactics {
    protected static final int scanCountDownStart = 8;
    protected int scanCountDown = -1;
    protected int targetHoldCountDownStart = 120;
    protected int targetHoldCountDown = 0;
    protected Config config;

    public BasicMelee() {
        this(new SemiAgressive());
    }

    public BasicMelee(Config c) {
        this.config = c;
    }

    public void doStartRound(Base robot) {
        robot.setConfig(this.config);
    }

    public void setTarget(Base robot, Enemy t) {
        super.setTarget(robot, t);
        this.targetHoldCountDown = this.targetHoldCountDownStart;
    }

    public void doTurn(Base robot) {
        super.doTurn(robot);
        if (this.target_ != null) {
            --this.targetHoldCountDown;
            if (this.targetHoldCountDown <= 0) {
                this.setTarget(robot, null);
            }
        }
        if (this.target_ == null) {
            if (this.scanCountDown == -1) {
                this.scanCountDown = 8;
            } else if (this.scanCountDown == 0) {
                this.setTarget(robot, this.selectTarget(robot));
                this.scanCountDown = -1;
            } else {
                --this.scanCountDown;
            }
        }
    }

    public void onRobotDeath(Base robot, RobotDeathEvent e) {
        super.onRobotDeath(robot, e);
        Enemy deadRobot = robot.getEnemyController().getEnemy(e.getName());
        if (deadRobot == this.target_) {
            this.setTarget(robot, null);
        }
    }
}

