/*
 * Decompiled with CFR 0.152.
 */
package inonit.robocode.javascript;

import inonit.script.engine.Code;
import inonit.script.engine.Loader;
import inonit.script.rhino.Engine;
import inonit.script.rhino.MetaObject;
import inonit.script.rhino.Objects;
import inonit.script.runtime.Throwables;
import inonit.script.runtime.io.Streams;
import java.awt.AWTEvent;
import java.awt.Graphics2D;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Properties;
import org.mozilla.javascript.Callable;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.UniqueTag;
import robocode.AdvancedRobot;
import robocode.BattleEndedEvent;
import robocode.BulletHitBulletEvent;
import robocode.BulletHitEvent;
import robocode.BulletMissedEvent;
import robocode.CustomEvent;
import robocode.DeathEvent;
import robocode.Event;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.HitWallEvent;
import robocode.RobotDeathEvent;
import robocode.RoundEndedEvent;
import robocode.ScannedRobotEvent;
import robocode.SkippedTurnEvent;
import robocode.StatusEvent;
import robocode.WinEvent;

public abstract class Robot
extends AdvancedRobot {
    private Scriptable robot;
    private static final State state;
    private ArrayList<Event> events = new ArrayList();

    static Code.Loader create(final Robot r) throws IOException {
        File base;
        String sourcePropertyName = ((Object)((Object)r)).getClass().getName() + ".source";
        if (System.getProperty(sourcePropertyName) != null) {
            r.out.println("Source property specified: " + System.getProperty(sourcePropertyName));
            InputStream myPropertiesStream = ((Object)((Object)r)).getClass().getResourceAsStream(((Object)((Object)r)).getClass().getSimpleName() + ".properties");
            Properties myProperties = new Properties();
            myProperties.load(myPropertiesStream);
            String myVersion = myProperties.getProperty("robot.version");
            String sourceVersion = System.getProperty(((Object)((Object)r)).getClass().getName() + ".version");
            if (sourceVersion != null && sourceVersion.equals(myVersion) || sourceVersion == null) {
                r.out.println("Loading from source directory: " + sourcePropertyName);
                base = new File(System.getProperty(sourcePropertyName));
            } else {
                base = null;
                r.out.println("Not loading from source directory: source version=" + sourceVersion + " my version=" + myVersion);
            }
        } else {
            base = null;
            r.out.println("Not found: " + sourcePropertyName);
        }
        return new Code.Loader(){

            public String toString() {
                return "<robot>";
            }

            private File getJavaFile(String path) throws FileNotFoundException, IOException {
                r.out.println("Loading: " + path);
                File file = null;
                if (base != null) {
                    String relative = "robot/" + path;
                    if (path.equals("expression.js") || path.equals("$api.js") || path.equals("$api-flag.js") || path.equals("$api-Function.js") || path.equals("$api-Function-old.js") || path.startsWith("jrunscript/")) {
                        relative = "project/slime/loader/" + path;
                    } else if (path.equals("loader.js")) {
                        relative = "robot/inonit/robocode/javascript/loader.js";
                    } else if (path.equals("api.js")) {
                        relative = "robot/inonit/robocode/javascript/api.js";
                    } else if (path.split("/").length == 1 && path.endsWith(".js")) {
                        String namePortion = path.substring(0, path.length() - ".js".length());
                        relative = "robot/" + namePortion.replaceAll("\\.", "/") + ".js";
                    }
                    file = new File(base, relative);
                    r.out.println("Loading from: " + file);
                }
                if (file == null) {
                    r.out.println("Using data directory: " + r.getDataDirectory());
                    file = new File(r.getDataDirectory(), path.replace("/", "$"));
                }
                if (file.exists()) {
                    r.out.println("Loading " + path + " from: " + file);
                    return file;
                }
                return null;
            }

            @Override
            public Code.Loader.Resource getFile(String string) throws IOException {
                File file = this.getJavaFile(string);
                if (file == null) {
                    return null;
                }
                return Code.Loader.Resource.create(file);
            }

            @Override
            public Code.Locator getLocator() {
                return null;
            }

            @Override
            public Code.Loader.Enumerator getEnumerator() {
                return null;
            }
        };
    }

    protected Robot() {
        System.out.println("Loading object: " + (Object)((Object)this));
    }

    private Callable getCallable(String method) {
        Object presumedCallable = this.robot.get(method, this.robot);
        if (presumedCallable == UniqueTag.NOT_FOUND) {
            return null;
        }
        if (!(presumedCallable instanceof Callable)) {
            throw new IllegalArgumentException("Expected robot function property " + method + " but got " + presumedCallable);
        }
        return (Callable)presumedCallable;
    }

    public final void run() {
        try {
            for (Event event : this.events) {
                this.out.println("Robot ignored event " + event + " which happened before it was ready.");
            }
            this.robot = state.initialize(this);
            Callable run = this.getCallable("run");
            if (run == null) {
                throw new IllegalArgumentException("JavaScript robots must implement this.run()");
            }
            run.call(Context.enter(), this.robot.getParentScope(), this.robot, new Object[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void handleCallback(String method, Object object) {
        Callable callable = this.getCallable(method);
        if (callable == null) {
            return;
        }
        callable.call(Context.enter(), this.robot.getParentScope(), this.robot, new Object[]{object});
    }

    private <E extends Event> void handleEvent(String method, E e) {
        if (this.robot == null) {
            this.events.add(e);
            return;
        }
        this.handleCallback(method, e);
    }

    private <E extends AWTEvent> void handleEvent(String method, E e) {
        if (this.robot == null) {
            this.out.println("Ignoring user event because robot not ready: " + e);
            return;
        }
        this.handleCallback(method, e);
    }

    public void onCustomEvent(CustomEvent event) {
        throw new IllegalStateException("Should not be called; script robots cannot create custom events.");
    }

    public void onDeath(DeathEvent event) {
        this.handleEvent("onDeath", event);
    }

    public void onSkippedTurn(SkippedTurnEvent event) {
        this.handleEvent("onSkippedTurn", event);
    }

    public void onBulletHit(BulletHitEvent event) {
        this.handleEvent("onBulletHit", event);
    }

    public void onBulletHitBullet(BulletHitBulletEvent event) {
        this.handleEvent("onBulletHitBullet", event);
    }

    public void onBulletMissed(BulletMissedEvent event) {
        this.handleEvent("onBulletMissed", event);
    }

    public void onHitByBullet(HitByBulletEvent event) {
        this.handleEvent("onHitByBullet", event);
    }

    public void onHitRobot(HitRobotEvent event) {
        this.handleEvent("onHitRobot", event);
    }

    public void onHitWall(HitWallEvent event) {
        this.handleEvent("onHitWall", event);
    }

    public void onRobotDeath(RobotDeathEvent event) {
        this.handleEvent("onRobotDeath", event);
    }

    public void onWin(WinEvent event) {
        this.handleEvent("onWin", event);
    }

    public void onRoundEnded(RoundEndedEvent event) {
        this.handleEvent("onRoundEnded", event);
    }

    public void onBattleEnded(BattleEndedEvent event) {
        this.handleEvent("onBattleEnded", event);
    }

    public void onStatus(StatusEvent e) {
        this.handleEvent("onStatus", e);
    }

    public final void onScannedRobot(ScannedRobotEvent e) {
        this.handleEvent("onScannedRobot", e);
    }

    public void onPaint(Graphics2D g) {
        if (this.robot == null) {
            return;
        }
        this.handleCallback("onPaint", g);
    }

    public void onKeyPressed(KeyEvent e) {
        this.handleEvent("onKeyPressed", e);
    }

    public void onKeyReleased(KeyEvent e) {
        this.handleEvent("onKeyReleased", e);
    }

    public void onKeyTyped(KeyEvent e) {
        this.handleEvent("onKeyTyped", e);
    }

    public void onMouseClicked(MouseEvent e) {
        this.handleEvent("onMouseClicked", e);
    }

    public void onMouseEntered(MouseEvent e) {
        this.handleEvent("onMouseEntered", e);
    }

    public void onMouseExited(MouseEvent e) {
        this.handleEvent("onMouseExited", e);
    }

    public void onMousePressed(MouseEvent e) {
        this.handleEvent("onMousePressed", e);
    }

    public void onMouseReleased(MouseEvent e) {
        this.handleEvent("onMouseReleased", e);
    }

    public void onMouseMoved(MouseEvent e) {
        this.handleEvent("onMouseMoved", e);
    }

    public void onMouseDragged(MouseEvent e) {
        this.handleEvent("onMouseDragged", e);
    }

    public void onMouseWheelMoved(MouseWheelEvent e) {
        this.handleEvent("onMouseWheelMoved", e);
    }

    static {
        Class[] classArray = new Class[]{Objects.class, MetaObject.class, Throwables.class};
        state = new State();
    }

    public static class Host {
        private Streams streams = new Streams();
        private Engine engine;
        private Loader loader;
        private Code.Loader source;

        Host(Engine engine, final Code.Loader loader) {
            this.engine = engine;
            this.loader = new Loader(){

                @Override
                public String getCoffeeScript() throws IOException {
                    return null;
                }

                @Override
                public String getLoaderCode(String string) throws IOException {
                    Code.Loader.Resource file = loader.getFile(string);
                    if (file == null) {
                        return null;
                    }
                    return Host.this.streams.readString(file.getReader());
                }

                @Override
                public Loader.Typescript getTypescript() throws IOException {
                    return null;
                }

                @Override
                public Loader.Classes.Interface getClasspath() {
                    return null;
                }
            };
            this.source = loader;
        }

        public Engine getEngine() {
            return this.engine;
        }

        public Loader getLoader() {
            return this.loader;
        }

        public Code.Loader getSource() {
            return this.source;
        }
    }

    private static class State {
        private Scriptable script;

        private State() {
        }

        Scriptable initialize(final Robot robot) throws IOException {
            if (this.script == null) {
                Engine.Profiler debugger = null;
                if (System.getProperty("inonit.robocode.javascript.profile") != null) {
                    Engine.Profiler profiler;
                    robot.out.println("Enabling robot profiling.");
                    debugger = profiler = new Engine.Profiler();
                } else {
                    robot.out.println("Disabling robot profiling.");
                }
                Engine engine = Engine.create(debugger, new Engine.Configuration(){

                    @Override
                    public ClassLoader getApplicationClassLoader() {
                        return Robot.class.getClassLoader();
                    }

                    @Override
                    public boolean createClassLoader() {
                        return false;
                    }

                    @Override
                    public boolean canAccessEnvironment() {
                        return false;
                    }

                    @Override
                    public int getOptimizationLevel() {
                        return -1;
                    }

                    @Override
                    public File getLocalClassCache() {
                        return null;
                    }
                });
                Engine.Program program = new Engine.Program();
                Code.Loader loader = Robot.create(robot);
                Host host = new Host(engine, loader);
                try {
                    Engine.Program.Variable jsh = Engine.Program.Variable.create("$host", Engine.Program.Variable.Value.create(engine.createHostObject(host)));
                    jsh.setReadonly(true);
                    jsh.setPermanent(true);
                    jsh.setDontenum(true);
                    program.set(jsh);
                }
                catch (Engine.Errors errors) {
                    errors.dump(new Engine.Log(){

                        @Override
                        public void println(String message) {
                            System.err.println(message);
                        }
                    }, "[slime] ");
                    throw errors;
                }
                Engine.Program.Variable context = Engine.Program.Variable.create("$context", new Engine.Program.Variable.Value(){

                    @Override
                    public Object get(Context context, Scriptable scope) {
                        Scriptable rv = context.newObject(scope);
                        rv.put("_peer", rv, (Object)robot);
                        State.this.script = context.newObject(scope);
                        rv.put("robot", rv, (Object)State.this.script);
                        return rv;
                    }
                });
                context.setReadonly(true);
                context.setPermanent(true);
                context.setDontenum(true);
                program.set(context);
                program.add(Engine.Source.create("robocode://inonit/robocode/javascript/loader.js", host.getLoader().getLoaderCode("loader.js")));
                try {
                    System.err.println("Executing JavaScript program ...");
                    engine.execute(program);
                }
                catch (Engine.Errors errors) {
                    System.err.println("Caught errors.");
                    errors.dump(new Engine.Log(){

                        @Override
                        public void println(String message) {
                            robot.out.println(message);
                        }
                    }, "[slime] ");
                    errors.dump(new Engine.Log(){

                        @Override
                        public void println(String message) {
                            System.err.println(message);
                        }
                    }, "[slime] ");
                    throw errors;
                }
            }
            return this.script;
        }
    }
}

