/*
 * Decompiled with CFR 0.152.
 */
package KiraNL;

import robocode.AdvancedRobot;
import robocode.BulletHitEvent;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;

public class Chupacabra
extends AdvancedRobot {
    private static double fireTime;
    private static double previousEnergy;
    private static double changeInEnergy;
    private static double stoppedTime;
    private static int orbitDirection;
    private static final double orbitDistance = 150.0;
    private static final double orbitSpeed = 20.0;
    private static String gunpattern;

    static {
        previousEnergy = 100.0;
        orbitDirection = 1;
        gunpattern = "\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0001\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0002\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\uffff\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\ufffe\ufffc\ufffa\ufff8\ufff8\ufff8\ufff8\ufff8\ufff8\ufff8\ufff8\ufff8\ufff8\ufff8\ufff8\ufff8\ufff8\ufff8\ufff8\ufff8\ufff8\ufff8\ufff8\ufff8\ufff8\ufff8\ufff8\ufff8\ufff8\ufff8\ufff8\ufff8\ufff8\ufff8\ufff8\ufff8\ufff8\ufff8\ufff8\ufff8\ufff8\ufff8\ufff8\ufff9\ufffa\ufffb\ufffc\ufffd\ufffe\uffff\u0000\u0002\u0004\u0006\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\u0007\u0006\u0005\u0004\u0003\u0002\u0001\u0000";
    }

    public void run() {
        this.setAdjustRadarForRobotTurn(true);
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        while (true) {
            this.handleRadar(null);
            this.execute();
        }
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        this.handleRadar(e);
        double fPower = Chupacabra.limit(600.0 / e.getDistance(), 1.0, 3.0);
        this.handleGun(fPower, e);
        this.handleMovement(e);
        this.execute();
    }

    public void onHitByBullet(HitByBulletEvent e) {
        previousEnergy += 3.0 * e.getBullet().getPower();
    }

    public void onBulletHit(BulletHitEvent e) {
        previousEnergy -= 4.0 * e.getBullet().getPower() + Math.max(0.0, 2.0 * (e.getBullet().getPower() - 1.0));
    }

    public void onHitRobot(HitRobotEvent e) {
        previousEnergy -= 0.6;
    }

    private void handleRadar(ScannedRobotEvent e) {
        if (e != null) {
            double radarTurn = 1.9 * Utils.normalRelativeAngle((double)(this.getHeadingRadians() + e.getBearingRadians() - this.getRadarHeadingRadians()));
            double extraTurn = Math.min(Math.atan(5.0 / e.getDistance()), 0.7853981633974483);
            this.setTurnRadarRightRadians(radarTurn + (radarTurn < 0.0 ? -extraTurn : extraTurn));
        } else if (this.getRadarTurnRemaining() == 0.0) {
            this.setTurnRadarRightRadians(Double.POSITIVE_INFINITY);
        }
    }

    private void handleGun(double bpower, ScannedRobotEvent e) {
        double dist;
        int i;
        int n;
        int matchPos;
        int matchLen = 40;
        double angle = e.getBearingRadians();
        if (fireTime == (double)this.getTime() && this.getGunTurnRemaining() == 0.0) {
            this.setFire(bpower);
        }
        gunpattern = String.valueOf((char)Math.round(2.0 * (e.getVelocity() * Math.sin(e.getHeadingRadians() - (angle += this.getHeadingRadians()))))).concat(gunpattern);
        do {
            n = matchLen--;
            dist = e.getDistance();
            i = (int)(dist / 12.5 - 1.0);
        } while ((matchPos = gunpattern.indexOf(gunpattern.substring(0, n), i)) < 0);
        while (--i > 0) {
            angle += Math.asin((double)((short)gunpattern.charAt(--matchPos)) / dist / 2.0);
        }
        this.setTurnGunRightRadians(Utils.normalRelativeAngle((double)(angle - this.getGunHeadingRadians())));
        fireTime = this.getTime() + 1L;
    }

    private void handleMovement(ScannedRobotEvent e) {
        double bearing = e.getBearingRadians();
        double distance = e.getDistance();
        double delta = distance - 150.0;
        double spiral = this.gompertz(delta);
        double d = 20.0;
        double b = Math.sqrt(distance * distance - d * d / 4.0);
        double alpha = Math.atan2(b, d / 2.0);
        double tankTurn = bearing - alpha + spiral * (double)orbitDirection;
        if (this.stopped() && stoppedTime > (double)this.getTime()) {
            this.switchDirection();
        } else if (this.shotFired(e) && Math.round(Math.random()) == 1L) {
            this.setMaxVelocity(16.0 * Math.random() + 5.0);
            this.setTurnRight(Math.random() * 360.0 - 180.0);
            this.setAhead((Math.random() * 700.0 - 350.0) * 1.2);
            this.switchDirection();
            return;
        }
        if (distance < 100.0 && this.getEnergy() > e.getEnergy()) {
            this.setTurnRight(bearing);
            this.setAhead(distance);
        }
        this.setTurnRightRadians(tankTurn);
        this.setAhead(d * (double)orbitDirection);
    }

    private boolean shotFired(ScannedRobotEvent e) {
        double d;
        double d2 = previousEnergy;
        previousEnergy = e.getEnergy();
        changeInEnergy = d2 - previousEnergy;
        return d > 0.0 && changeInEnergy <= 3.0;
    }

    private void switchDirection() {
        stoppedTime = this.getTime() + 1L;
        orbitDirection *= -1;
    }

    private boolean stopped() {
        return this.getVelocity() == 0.0;
    }

    private double gompertz(double x) {
        return 1.5707963267948966 * Math.exp(-Math.PI * Math.exp(-x * 0.01));
    }

    private static double limit(double value, double min, double max) {
        return Math.min(max, Math.max(min, value));
    }
}

