/*
 * Decompiled with CFR 0.152.
 */
package florent.XSeries.gun.patternrecognition;

import florent.XSeries.gun.patternrecognition.Scan;
import florent.XSeries.utils.RobocodeTools;

public class ScanStats {
    private static final int GF0 = 15;
    private static final int GF1 = 30;
    private double[] hits = new double[31];
    private static final int BIN_SIZE = 8;
    private double[] distanceBin = new double[8];
    private double[] distance2Bin = new double[8];
    private double[] distance4Bin = new double[8];
    private double[] distance8Bin = new double[8];
    private double[] distance16Bin = new double[8];
    private double[] distance32Bin = new double[8];
    private double[] velocityBin = new double[8];
    private double[] accelBin = new double[8];
    private double[] angleBin = new double[8];
    private double[] wallBin = new double[8];
    private double[] wallReverseBin = new double[8];
    private double[] timerBin = new double[8];
    private double[][] distanceHits = new double[8][31];
    private double[][] distance2Hits = new double[8][31];
    private double[][] distance4Hits = new double[8][31];
    private double[][] distance8Hits = new double[8][31];
    private double[][] distance16Hits = new double[8][31];
    private double[][] distance32Hits = new double[8][31];
    private double[][] velocityHits = new double[8][31];
    private double[][] accelHits = new double[8][31];
    private double[][] angleHits = new double[8][31];
    private double[][] wallHits = new double[8][31];
    private double[][] wallReverseHits = new double[8][31];
    private double[][] timerHits = new double[8][31];
    public double[] entropies = new double[12];
    private DimensionStats[] stats;
    private double[] fastSmooth = new double[8];
    private int records = 0;
    private int hit = 0;

    public ScanStats() {
        int i = 0;
        while (i < 8) {
            this.fastSmooth[i] = Math.exp(-ScanStats.sqr(i));
            ++i;
        }
        this.stats = new DimensionStats[12];
        i = 0;
        while (i < this.stats.length) {
            this.stats[i] = new DimensionStats();
            ++i;
        }
    }

    public void record(Scan scan) {
        int index;
        int n = index = (int)RobocodeTools.bindToRange(Math.floor(scan.normalizedDistance * 8.0), 0.0, 7.0);
        this.distanceBin[n] = this.distanceBin[n] + 1.0;
        int n2 = index = (int)RobocodeTools.bindToRange(Math.floor(scan.cumul2 * 8.0), 0.0, 7.0);
        this.distance2Bin[n2] = this.distance2Bin[n2] + 1.0;
        int n3 = index = (int)RobocodeTools.bindToRange(Math.floor(scan.cumul4 * 8.0), 0.0, 7.0);
        this.distance4Bin[n3] = this.distance4Bin[n3] + 1.0;
        int n4 = index = (int)RobocodeTools.bindToRange(Math.floor(scan.cumul8 * 8.0), 0.0, 7.0);
        this.distance8Bin[n4] = this.distance8Bin[n4] + 1.0;
        int n5 = index = (int)RobocodeTools.bindToRange(Math.floor(scan.cumul16 * 8.0), 0.0, 7.0);
        this.distance16Bin[n5] = this.distance16Bin[n5] + 1.0;
        int n6 = index = (int)RobocodeTools.bindToRange(Math.floor(scan.cumul32 * 8.0), 0.0, 7.0);
        this.distance32Bin[n6] = this.distance32Bin[n6] + 1.0;
        int n7 = index = (int)RobocodeTools.bindToRange(Math.floor(scan.accel * 8.0), 0.0, 7.0);
        this.accelBin[n7] = this.accelBin[n7] + 1.0;
        int n8 = index = (int)RobocodeTools.bindToRange(Math.floor(scan.normalizedVelocity * 8.0), 0.0, 7.0);
        this.velocityBin[n8] = this.velocityBin[n8] + 1.0;
        int n9 = index = (int)RobocodeTools.bindToRange(Math.floor(scan.angle * 8.0), 0.0, 7.0);
        this.angleBin[n9] = this.angleBin[n9] + 1.0;
        int n10 = index = (int)RobocodeTools.bindToRange(Math.floor(scan.wallIndex * 8.0), 0.0, 7.0);
        this.wallBin[n10] = this.wallBin[n10] + 1.0;
        int n11 = index = (int)RobocodeTools.bindToRange(Math.floor(scan.wallIndexReverse * 8.0), 0.0, 7.0);
        this.wallReverseBin[n11] = this.wallReverseBin[n11] + 1.0;
        int n12 = index = (int)RobocodeTools.bindToRange(Math.floor(scan.lastTimer * 8.0), 0.0, 7.0);
        this.timerBin[n12] = this.timerBin[n12] + 1.0;
        ++this.records;
    }

    public void updateStats() {
        this.stats[0].update(7, 30, this.distanceHits);
        this.entropies[0] = this.stats[0].uygx;
        this.stats[1].update(7, 30, this.distance2Hits);
        this.entropies[1] = this.stats[1].uygx;
        this.stats[2].update(7, 30, this.distance4Hits);
        this.entropies[2] = this.stats[2].uygx;
        this.stats[3].update(7, 30, this.distance8Hits);
        this.entropies[3] = this.stats[3].uygx;
        this.stats[4].update(7, 30, this.distance16Hits);
        this.entropies[4] = this.stats[4].uygx;
        this.stats[5].update(7, 30, this.distance32Hits);
        this.entropies[5] = this.stats[5].uygx;
        this.stats[6].update(7, 30, this.accelHits);
        this.entropies[6] = this.stats[6].uygx;
        this.stats[7].update(7, 30, this.velocityHits);
        this.entropies[7] = this.stats[7].uygx;
        this.stats[8].update(7, 30, this.angleHits);
        this.entropies[8] = this.stats[8].uygx;
        this.stats[9].update(7, 30, this.wallHits);
        this.entropies[9] = this.stats[9].uygx;
        this.stats[10].update(7, 30, this.wallReverseHits);
        this.entropies[10] = this.stats[10].uygx;
        this.stats[11].update(7, 30, this.timerHits);
        this.entropies[11] = this.stats[11].uygx;
    }

    public void dumpStats() {
        RobocodeTools.log("distance    " + this.entropies[0] + "\t" + 1.0 / (1.0 - this.entropies[0]));
        RobocodeTools.log("distance2   " + this.entropies[1] + "\t" + 1.0 / (1.0 - this.entropies[1]));
        RobocodeTools.log("distance4   " + this.entropies[2] + "\t" + 1.0 / (1.0 - this.entropies[2]));
        RobocodeTools.log("distance8   " + this.entropies[3] + "\t" + 1.0 / (1.0 - this.entropies[3]));
        RobocodeTools.log("distance16  " + this.entropies[4] + "\t" + 1.0 / (1.0 - this.entropies[4]));
        RobocodeTools.log("distance32  " + this.entropies[5] + "\t" + 1.0 / (1.0 - this.entropies[5]));
        RobocodeTools.log("accel       " + this.entropies[6] + "\t" + 1.0 / (1.0 - this.entropies[6]));
        RobocodeTools.log("velocity    " + this.entropies[7] + "\t" + 1.0 / (1.0 - this.entropies[7]));
        RobocodeTools.log("angle       " + this.entropies[8] + "\t" + 1.0 / (1.0 - this.entropies[8]));
        RobocodeTools.log("wall        " + this.entropies[9] + "\t" + 1.0 / (1.0 - this.entropies[9]));
        RobocodeTools.log("wallReverse " + this.entropies[10] + "\t" + 1.0 / (1.0 - this.entropies[10]));
        RobocodeTools.log("timer       " + this.entropies[11] + "\t" + 1.0 / (1.1 - this.entropies[11]));
        RobocodeTools.log(RobocodeTools.doubleArrayToString(this.hits));
    }

    public double[] factors(Scan scan) {
        double[] factors = new double[12];
        double smoothedValue = 0.0;
        int index = (int)RobocodeTools.bindToRange(Math.floor(scan.normalizedDistance * 8.0), 0.0, 7.0);
        int i = 0;
        while (i < 8) {
            smoothedValue += this.fastSmooth[Math.abs(index - i)] * this.distanceBin[i];
            ++i;
        }
        factors[0] = smoothedValue / (double)this.records;
        index = (int)RobocodeTools.bindToRange(Math.floor(scan.cumul2 * 8.0), 0.0, 7.0);
        smoothedValue = 0.0;
        i = 0;
        while (i < 8) {
            smoothedValue += this.fastSmooth[Math.abs(index - i)] * this.distance2Bin[i];
            ++i;
        }
        factors[1] = smoothedValue / (double)this.records;
        index = (int)RobocodeTools.bindToRange(Math.floor(scan.cumul4 * 8.0), 0.0, 7.0);
        smoothedValue = 0.0;
        i = 0;
        while (i < 8) {
            smoothedValue += this.fastSmooth[Math.abs(index - i)] * this.distance4Bin[i];
            ++i;
        }
        factors[2] = smoothedValue / (double)this.records;
        index = (int)RobocodeTools.bindToRange(Math.floor(scan.cumul8 * 8.0), 0.0, 7.0);
        smoothedValue = 0.0;
        i = 0;
        while (i < 8) {
            smoothedValue += this.fastSmooth[Math.abs(index - i)] * this.distance8Bin[i];
            ++i;
        }
        factors[3] = smoothedValue / (double)this.records;
        index = (int)RobocodeTools.bindToRange(Math.floor(scan.cumul16 * 8.0), 0.0, 7.0);
        smoothedValue = 0.0;
        i = 0;
        while (i < 8) {
            smoothedValue += this.fastSmooth[Math.abs(index - i)] * this.distance16Bin[i];
            ++i;
        }
        factors[4] = smoothedValue / (double)this.records;
        index = (int)RobocodeTools.bindToRange(Math.floor(scan.cumul32 * 8.0), 0.0, 7.0);
        smoothedValue = 0.0;
        i = 0;
        while (i < 8) {
            smoothedValue += this.fastSmooth[Math.abs(index - i)] * this.distance32Bin[i];
            ++i;
        }
        factors[5] = smoothedValue / (double)this.records;
        index = (int)RobocodeTools.bindToRange(Math.floor(scan.accel * 8.0), 0.0, 7.0);
        smoothedValue = 0.0;
        i = 0;
        while (i < 8) {
            smoothedValue += this.fastSmooth[Math.abs(index - i)] * this.accelBin[i];
            ++i;
        }
        factors[6] = smoothedValue / (double)this.records;
        index = (int)RobocodeTools.bindToRange(Math.floor(scan.velocity * 8.0), 0.0, 7.0);
        smoothedValue = 0.0;
        i = 0;
        while (i < 8) {
            smoothedValue += this.fastSmooth[Math.abs(index - i)] * this.velocityBin[i];
            ++i;
        }
        factors[7] = smoothedValue / (double)this.records;
        index = (int)RobocodeTools.bindToRange(Math.floor(scan.angle * 8.0), 0.0, 7.0);
        smoothedValue = 0.0;
        i = 0;
        while (i < 8) {
            smoothedValue += Math.exp(-ScanStats.sqr(index - i)) * this.angleBin[i];
            ++i;
        }
        factors[8] = smoothedValue / (double)this.records;
        index = (int)RobocodeTools.bindToRange(Math.floor(scan.wallIndex * 8.0), 0.0, 7.0);
        smoothedValue = 0.0;
        i = 0;
        while (i < 8) {
            smoothedValue += Math.exp(-ScanStats.sqr(index - i)) * this.wallBin[i];
            ++i;
        }
        factors[9] = smoothedValue / (double)this.records;
        index = (int)RobocodeTools.bindToRange(Math.floor(scan.wallIndexReverse * 8.0), 0.0, 7.0);
        smoothedValue = 0.0;
        i = 0;
        while (i < 8) {
            smoothedValue += Math.exp(-ScanStats.sqr(index - i)) * this.wallReverseBin[i];
            ++i;
        }
        factors[10] = smoothedValue / (double)this.records;
        index = (int)RobocodeTools.bindToRange(Math.floor(scan.lastTimer * 8.0), 0.0, 7.0);
        smoothedValue = 0.0;
        i = 0;
        while (i < 8) {
            smoothedValue += Math.exp(-ScanStats.sqr(index - i)) * this.timerBin[i];
            ++i;
        }
        factors[11] = smoothedValue / (double)this.records;
        return factors;
    }

    public void recordHit(double gf, Scan scan) {
        int GF;
        int n = GF = (int)RobocodeTools.bindToRange(Math.round((1.0 + gf) * 15.0), 0.0, 30.0);
        this.hits[n] = this.hits[n] + 1.0;
        int index = (int)RobocodeTools.bindToRange(Math.floor(scan.normalizedDistance * 8.0), 0.0, 7.0);
        double[] dArray = this.distanceHits[index];
        int n2 = GF;
        dArray[n2] = dArray[n2] + 1.0;
        this.stats[0].update(7, 30, this.distanceHits);
        this.entropies[0] = this.stats[0].uygx;
        index = (int)RobocodeTools.bindToRange(Math.floor(scan.cumul2 * 8.0), 0.0, 7.0);
        double[] dArray2 = this.distance2Hits[index];
        int n3 = GF;
        dArray2[n3] = dArray2[n3] + 1.0;
        this.stats[1].update(7, 30, this.distance2Hits);
        this.entropies[1] = this.stats[1].uygx;
        index = (int)RobocodeTools.bindToRange(Math.floor(scan.cumul4 * 8.0), 0.0, 7.0);
        double[] dArray3 = this.distance4Hits[index];
        int n4 = GF;
        dArray3[n4] = dArray3[n4] + 1.0;
        this.stats[2].update(7, 30, this.distance4Hits);
        this.entropies[2] = this.stats[2].uygx;
        index = (int)RobocodeTools.bindToRange(Math.floor(scan.cumul8 * 8.0), 0.0, 7.0);
        double[] dArray4 = this.distance8Hits[index];
        int n5 = GF;
        dArray4[n5] = dArray4[n5] + 1.0;
        this.stats[3].update(7, 30, this.distance8Hits);
        this.entropies[3] = this.stats[3].uygx;
        index = (int)RobocodeTools.bindToRange(Math.floor(scan.cumul16 * 8.0), 0.0, 7.0);
        double[] dArray5 = this.distance16Hits[index];
        int n6 = GF;
        dArray5[n6] = dArray5[n6] + 1.0;
        this.stats[4].update(7, 30, this.distance16Hits);
        this.entropies[4] = this.stats[4].uygx;
        index = (int)RobocodeTools.bindToRange(Math.floor(scan.cumul32 * 8.0), 0.0, 7.0);
        double[] dArray6 = this.distance32Hits[index];
        int n7 = GF;
        dArray6[n7] = dArray6[n7] + 1.0;
        this.stats[5].update(7, 30, this.distance32Hits);
        this.entropies[5] = this.stats[5].uygx;
        index = (int)RobocodeTools.bindToRange(Math.floor(scan.accel * 8.0), 0.0, 7.0);
        double[] dArray7 = this.accelHits[index];
        int n8 = GF;
        dArray7[n8] = dArray7[n8] + 1.0;
        this.stats[6].update(7, 30, this.accelHits);
        this.entropies[6] = this.stats[6].uygx;
        index = (int)RobocodeTools.bindToRange(Math.floor(scan.normalizedVelocity * 8.0), 0.0, 7.0);
        double[] dArray8 = this.velocityHits[index];
        int n9 = GF;
        dArray8[n9] = dArray8[n9] + 1.0;
        this.stats[7].update(7, 30, this.velocityHits);
        this.entropies[7] = this.stats[7].uygx;
        index = (int)RobocodeTools.bindToRange(Math.floor(scan.angle * 8.0), 0.0, 7.0);
        double[] dArray9 = this.angleHits[index];
        int n10 = GF;
        dArray9[n10] = dArray9[n10] + 1.0;
        this.stats[8].update(7, 30, this.angleHits);
        this.entropies[8] = this.stats[8].uygx;
        index = (int)RobocodeTools.bindToRange(Math.floor(scan.wallIndex * 8.0), 0.0, 7.0);
        double[] dArray10 = this.wallHits[index];
        int n11 = GF;
        dArray10[n11] = dArray10[n11] + 1.0;
        this.stats[9].update(7, 30, this.wallHits);
        this.entropies[9] = this.stats[9].uygx;
        index = (int)RobocodeTools.bindToRange(Math.floor(scan.wallIndexReverse * 8.0), 0.0, 7.0);
        double[] dArray11 = this.wallReverseHits[index];
        int n12 = GF;
        dArray11[n12] = dArray11[n12] + 1.0;
        this.stats[10].update(7, 30, this.wallReverseHits);
        this.entropies[10] = this.stats[10].uygx;
        index = (int)RobocodeTools.bindToRange(Math.floor(scan.lastTimer * 8.0), 0.0, 7.0);
        double[] dArray12 = this.timerHits[index];
        int n13 = GF;
        dArray12[n13] = dArray12[n13] + 1.0;
        this.stats[11].update(7, 30, this.timerHits);
        this.entropies[11] = this.stats[11].uygx;
    }

    public void recordRollingHit(double gf, Scan scan) {
        int GF;
        double depth = 32.0;
        ++this.hit;
        int n = GF = (int)RobocodeTools.bindToRange(Math.round((1.0 + gf) * 15.0), 0.0, 30.0);
        this.hits[n] = this.hits[n] + 1.0;
        int index = (int)RobocodeTools.bindToRange(Math.floor(scan.normalizedDistance * 8.0), 0.0, 7.0);
        double[] dArray = this.distanceHits[index];
        dArray[0] = dArray[0] + 1.0;
        int i = 1;
        while (i <= 30) {
            this.distanceHits[index][GF] = RobocodeTools.rollingAverage(Math.min(this.distanceHits[index][0], depth), this.distanceHits[index][GF], i == GF ? 1 : 0);
            ++i;
        }
        this.stats[0].update(7, 30, this.distanceHits);
        this.entropies[0] = this.stats[0].uygx;
        index = (int)RobocodeTools.bindToRange(Math.floor(scan.cumul2 * 8.0), 0.0, 7.0);
        double[] dArray2 = this.distance2Hits[index];
        dArray2[0] = dArray2[0] + 1.0;
        i = 1;
        while (i <= 30) {
            this.distance2Hits[index][GF] = RobocodeTools.rollingAverage(Math.min(this.distance2Hits[index][0], depth), this.distance2Hits[index][GF], i == GF ? 1 : 0);
            ++i;
        }
        this.stats[1].update(7, 30, this.distance2Hits);
        this.entropies[1] = this.stats[1].uygx;
        index = (int)RobocodeTools.bindToRange(Math.floor(scan.cumul4 * 8.0), 0.0, 7.0);
        double[] dArray3 = this.distance4Hits[index];
        dArray3[0] = dArray3[0] + 1.0;
        i = 1;
        while (i <= 30) {
            this.distance4Hits[index][GF] = RobocodeTools.rollingAverage(Math.min(this.distance4Hits[index][0], depth), this.distance4Hits[index][GF], i == GF ? 1 : 0);
            ++i;
        }
        this.stats[2].update(7, 30, this.distance4Hits);
        this.entropies[2] = this.stats[2].uygx;
        index = (int)RobocodeTools.bindToRange(Math.floor(scan.cumul8 * 8.0), 0.0, 7.0);
        double[] dArray4 = this.distance8Hits[index];
        dArray4[0] = dArray4[0] + 1.0;
        i = 1;
        while (i <= 30) {
            this.distance8Hits[index][GF] = RobocodeTools.rollingAverage(Math.min(this.distance8Hits[index][0], depth), this.distance8Hits[index][GF], i == GF ? 1 : 0);
            ++i;
        }
        this.stats[3].update(7, 30, this.distance8Hits);
        this.entropies[3] = this.stats[3].uygx;
        index = (int)RobocodeTools.bindToRange(Math.floor(scan.cumul16 * 8.0), 0.0, 7.0);
        double[] dArray5 = this.distance16Hits[index];
        dArray5[0] = dArray5[0] + 1.0;
        i = 1;
        while (i <= 30) {
            this.distance16Hits[index][GF] = RobocodeTools.rollingAverage(Math.min(this.distance16Hits[index][0], depth), this.distance16Hits[index][GF], i == GF ? 1 : 0);
            ++i;
        }
        this.stats[4].update(7, 30, this.distance16Hits);
        this.entropies[4] = this.stats[4].uygx;
        index = (int)RobocodeTools.bindToRange(Math.floor(scan.cumul32 * 8.0), 0.0, 7.0);
        double[] dArray6 = this.distance32Hits[index];
        dArray6[0] = dArray6[0] + 1.0;
        i = 1;
        while (i <= 30) {
            this.distance32Hits[index][GF] = RobocodeTools.rollingAverage(Math.min(this.distance32Hits[index][0], depth), this.distance32Hits[index][GF], i == GF ? 1 : 0);
            ++i;
        }
        this.stats[5].update(7, 30, this.distance32Hits);
        this.entropies[5] = this.stats[5].uygx;
        index = (int)RobocodeTools.bindToRange(Math.floor(scan.accel * 8.0), 0.0, 7.0);
        double[] dArray7 = this.accelHits[index];
        dArray7[0] = dArray7[0] + 1.0;
        i = 1;
        while (i <= 30) {
            this.accelHits[index][GF] = RobocodeTools.rollingAverage(Math.min(this.accelHits[index][0], depth), this.accelHits[index][GF], i == GF ? 1 : 0);
            ++i;
        }
        this.stats[6].update(7, 30, this.accelHits);
        this.entropies[6] = this.stats[6].uygx;
        index = (int)RobocodeTools.bindToRange(Math.floor(scan.normalizedVelocity * 8.0), 0.0, 7.0);
        double[] dArray8 = this.velocityHits[index];
        dArray8[0] = dArray8[0] + 1.0;
        i = 1;
        while (i <= 30) {
            this.velocityHits[index][GF] = RobocodeTools.rollingAverage(Math.min(this.velocityHits[index][0], depth), this.velocityHits[index][GF], i == GF ? 1 : 0);
            ++i;
        }
        this.stats[7].update(7, 30, this.velocityHits);
        this.entropies[7] = this.stats[7].uygx;
        index = (int)RobocodeTools.bindToRange(Math.floor(scan.angle * 8.0), 0.0, 7.0);
        double[] dArray9 = this.angleHits[index];
        dArray9[0] = dArray9[0] + 1.0;
        i = 1;
        while (i <= 30) {
            this.angleHits[index][GF] = RobocodeTools.rollingAverage(Math.min(this.angleHits[index][0], depth), this.angleHits[index][GF], i == GF ? 1 : 0);
            ++i;
        }
        this.stats[8].update(7, 30, this.angleHits);
        this.entropies[8] = this.stats[8].uygx;
        index = (int)RobocodeTools.bindToRange(Math.floor(scan.wallIndex * 8.0), 0.0, 7.0);
        double[] dArray10 = this.wallHits[index];
        dArray10[0] = dArray10[0] + 1.0;
        i = 1;
        while (i <= 30) {
            this.wallHits[index][GF] = RobocodeTools.rollingAverage(Math.min(this.wallHits[index][0], depth), this.wallHits[index][GF], i == GF ? 1 : 0);
            ++i;
        }
        this.stats[9].update(7, 30, this.wallHits);
        this.entropies[9] = this.stats[9].uygx;
        index = (int)RobocodeTools.bindToRange(Math.floor(scan.wallIndexReverse * 8.0), 0.0, 7.0);
        double[] dArray11 = this.wallReverseHits[index];
        dArray11[0] = dArray11[0] + 1.0;
        i = 1;
        while (i <= 30) {
            this.wallReverseHits[index][GF] = RobocodeTools.rollingAverage(Math.min(this.wallReverseHits[index][0], depth), this.wallReverseHits[index][GF], i == GF ? 1 : 0);
            ++i;
        }
        this.stats[10].update(7, 30, this.wallReverseHits);
        this.entropies[10] = this.stats[10].uygx;
        index = (int)RobocodeTools.bindToRange(Math.floor(scan.lastTimer * 8.0), 0.0, 7.0);
        double[] dArray12 = this.timerHits[index];
        dArray12[0] = dArray12[0] + 1.0;
        i = 1;
        while (i <= 30) {
            this.timerHits[index][GF] = RobocodeTools.rollingAverage(Math.min(this.timerHits[index][0], depth), this.timerHits[index][GF], i == GF ? 1 : 0);
            ++i;
        }
        this.stats[11].update(7, 30, this.timerHits);
        this.entropies[11] = this.stats[11].uygx;
    }

    private static final double sqr(double val) {
        return val * val;
    }

    public static final double ent(double[] ad) {
        long l = ad.length;
        double d = 0.0;
        double d1 = 0.0;
        int i = 0;
        while ((long)i < l) {
            d += ad[i];
            d1 += ScanStats.sqr(ad[i]);
            ++i;
        }
        return Math.sqrt(((double)l * d1 - ScanStats.sqr(d)) / (double)(l * (l - 1L)));
    }

    private class DimensionStats {
        private double hx;
        private double hy;
        private double h;
        private double hygx;
        private double hxgy;
        public double uygx;
        public double uxgy;
        public double uxy;

        DimensionStats() {
        }

        public void update(int ni, int nj, double[][] nn) {
            double p;
            int j;
            double TINY = 1.0 * Math.pow(10.0, -30.0);
            double sum = 0.0;
            double[] sumi = new double[ni + 1];
            double[] sumj = new double[nj + 1];
            int i = 1;
            while (i <= ni) {
                sumi[i] = 0.0;
                j = 1;
                while (j <= nj) {
                    int n = i;
                    sumi[n] = sumi[n] + nn[i][j];
                    sum += nn[i][j];
                    ++j;
                }
                ++i;
            }
            j = 1;
            while (j <= nj) {
                sumj[j] = 0.0;
                i = 1;
                while (i <= ni) {
                    int n = j;
                    sumj[n] = sumj[n] + nn[i][j];
                    ++i;
                }
                ++j;
            }
            this.hx = 0.0;
            i = 1;
            while (i <= ni) {
                if (sumi[i] != 0.0) {
                    p = sumi[i] / sum;
                    this.hx -= p * Math.log(p);
                }
                ++i;
            }
            this.hy = 0.0;
            j = 1;
            while (j <= nj) {
                if (sumj[j] != 0.0) {
                    p = sumj[j] / sum;
                    this.hy -= p * Math.log(p);
                }
                ++j;
            }
            this.h = 0.0;
            i = 1;
            while (i <= ni) {
                j = 1;
                while (j <= nj) {
                    if (nn[i][j] != 0.0) {
                        p = nn[i][j] / sum;
                        this.h -= p * Math.log(p);
                    }
                    ++j;
                }
                ++i;
            }
            this.hygx = this.h - this.hx;
            this.hxgy = this.h - this.hy;
            this.uygx = (this.hy - this.hygx) / (this.hy + TINY);
            this.uxgy = (this.hx - this.hxgy) / (this.hx + TINY);
            this.uxy = 2.0 * (this.hx + this.hy - this.h) / (this.hx + this.hy + TINY);
        }
    }
}

