/*
 * Decompiled with CFR 0.152.
 */
package florent.XSeries.movement;

import florent.XSeries.Configuration;
import florent.XSeries.gun.TargetSelector;
import florent.XSeries.movement.MovementFactory;
import florent.XSeries.movement.MovementStrategy;
import florent.XSeries.movement.MovementType;
import florent.XSeries.movement.wavesurfing.EnemyWave;
import florent.XSeries.movement.wavesurfing.GFLog;
import florent.XSeries.radar.Enemy;
import florent.XSeries.radar.EnemyBuilder;
import florent.XSeries.radar.Tracker;
import florent.XSeries.team.Xmen;
import florent.XSeries.utils.RobocodeTools;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.HashMap;
import java.util.Vector;
import robocode.BulletHitBulletEvent;
import robocode.BulletHitEvent;
import robocode.DeathEvent;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;

public class WaveSurfing
extends MovementStrategy
implements EnemyBuilder {
    public static final boolean profiling = false;
    private Rectangle2D.Double BF;
    private Rectangle2D.Double innerBF;
    private Tracker tracker;
    private Xmen me;
    private boolean rammer = false;
    private boolean holdingFire = false;
    private boolean resumeFire = false;
    private volatile double holdFireDistance = 200.0;
    private boolean skyClear;
    private double myEnergy = 100.0;
    private double heading;
    private double velocity;
    private double time;
    private Point2D.Double myLocation = new Point2D.Double();
    private double distance;
    private Enemy enemy;
    private double dangerForward;
    private double dangerBack;
    private double dangerStop;
    private HashMap<String, GFLog> logs;
    private int score;
    private boolean flattener = false;

    public WaveSurfing(Xmen me) {
        this.tracker = Tracker.getInstance();
        this.BF = new Rectangle2D.Double(18.0, 18.0, me.getBattleFieldWidth() - 36.0, me.getBattleFieldHeight() - 36.0);
        this.innerBF = new Rectangle2D.Double(80.0, 80.0, me.getBattleFieldWidth() - 160.0, me.getBattleFieldHeight() - 160.0);
        this.me = me;
        this.logs = new HashMap();
        this.tracker.addBuilder(this);
    }

    public void endRound() {
        this.enemy.dump();
    }

    public void initRound() {
        this.synch();
    }

    public void onBulletHit(BulletHitEvent e) {
        super.onBulletHit(e);
    }

    public void onBulletHitBullet(BulletHitBulletEvent e) {
        super.onBulletHitBullet(e);
    }

    public void onHitByBullet(HitByBulletEvent e) {
        super.onHitByBullet(e);
    }

    public void onHitRobot(HitRobotEvent e) {
        super.onHitRobot(e);
    }

    public void move() {
        EnemyWave wave = this.enemy.getNearestWave(this.myLocation, this.time);
        wave = wave == null && this.distance > 150.0 ? this.enemy.lastWave : wave;
        wave = wave == null && this.me.getOthers() == 0 || this.rammer ? this.enemy.lastWave : wave;
        Point2D.Double nextDestination = null;
        if (this.goHunting()) {
            nextDestination = this.huntLocation();
        } else if (wave == null) {
            Point2D.Double newDestination = this.getNextPoint(this.enemy.myBearingDirection[0], this.myLocation, this.enemy.location);
            Point2D.Double newDestinationReverse = this.getNextPoint(-this.enemy.myBearingDirection[0], this.myLocation, this.enemy.location);
            nextDestination = Math.abs(RobocodeTools.angleBetween(this.myLocation, this.enemy.location, newDestination)) > Math.abs(RobocodeTools.angleBetween(this.myLocation, this.enemy.location, newDestinationReverse)) ? newDestination : newDestinationReverse;
        } else {
            this.updateDanger(wave);
            if (this.dangerForward > this.dangerBack) {
                nextDestination = this.getNextPoint(-this.enemy.myBearingDirection[0], this.myLocation, wave.getGunLocation());
                this.me.setMaxVelocity(8.0);
            } else {
                nextDestination = this.getNextPoint(this.enemy.myBearingDirection[0], this.myLocation, wave.getGunLocation());
                this.me.setMaxVelocity(8.0);
            }
            this.dangerBack = 0.0;
            this.dangerForward = 0.0;
            this.dangerStop = 0.0;
        }
        double theta = RobocodeTools.absoluteBearing(this.myLocation, nextDestination) - this.me.getHeadingRadians();
        this.me.setAhead(Math.cos(theta) * 100.0);
        this.me.setTurnRightRadians(Math.tan(theta));
    }

    public void onMainLoop() {
        this.synch();
        if (this.enemy != null) {
            this.skyClear = this.enemy.isSkyClear();
            this.rammer = this.enemy.isRammer();
            this.holdingFire = this.enemy.isHoldingFire();
            this.move();
        }
    }

    private void synch() {
        this.myLocation.setLocation(this.me.getX(), this.me.getY());
        this.heading = this.me.getHeadingRadians();
        this.velocity = this.me.getVelocity();
        this.time = this.me.getTime();
        this.myEnergy = this.me.getEnergy();
    }

    public void onPaint(Graphics2D e) {
        super.onPaint(e);
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        this.enemy = this.tracker.getEnemy(e.getName());
        if (e.getDistance() < 250.0) {
            MovementFactory.getInstance().getStrategy(MovementType.MIRRORMOVEMENT).onScannedRobot(e);
        }
    }

    private Point2D.Double getNextPoint(int circleDir, Point2D.Double start, Point2D.Double center) {
        Point2D.Double nextPoint;
        double blindManStick;
        int maxTry = 175;
        double desiredDistance = this.holdingFire && this.myEnergy > 3.0 && this.skyClear ? this.holdFireDistance : 525.0;
        double getCloser = this.holdingFire && this.myEnergy > 3.0 && this.skyClear && start.distance(center) > desiredDistance + 60.0 ? -1.5707963267948966 : -0.1;
        double d = blindManStick = this.rammer ? RobocodeTools.bindToRange(this.distance / 2.0, 60.0, 170.0) : 170.0;
        double desiredAngle = 1.6707963267948966 + (this.rammer ? 1.5707963267948966 : (start.distance(center) > desiredDistance ? getCloser : 0.5));
        if (this.rammer) {
            while (!this.innerBF.contains(nextPoint = RobocodeTools.projectMotion(start, RobocodeTools.absoluteBearing(start, center) - (double)circleDir * (desiredAngle -= 0.1), blindManStick)) && --maxTry > 0) {
            }
        } else {
            while (!this.BF.contains(nextPoint = RobocodeTools.projectMotion(start, RobocodeTools.absoluteBearing(start, center) - (double)circleDir * (desiredAngle -= 0.1), blindManStick))) {
            }
        }
        return nextPoint;
    }

    public boolean goHunting() {
        return this.enemy.energy == 0.0 && this.enemy.isSkyClear() && this.me.getEnergy() > 3.0;
    }

    private Point2D.Double huntLocation() {
        return RobocodeTools.projectMotion(this.enemy.location, this.enemy.heading, this.enemy.velocity);
    }

    private Point2D.Double nextPosition(Point2D.Double start, int direction, EnemyWave wave, double heading, double velocity, double time, double maxVel) {
        Point2D.Double gunLocation = wave.getGunLocation();
        Point2D.Double nextPoint = new Point2D.Double(start.x, start.y);
        double wantedHeading = this.goHunting() ? RobocodeTools.absoluteBearing(nextPoint, this.huntLocation()) : RobocodeTools.absoluteBearing(nextPoint, this.getNextPoint(direction, nextPoint, gunLocation));
        boolean reverse = Math.abs(Utils.normalRelativeAngle((double)(wantedHeading - heading))) > 1.5707963267948966;
        heading = reverse ? Utils.normalRelativeAngle((double)(heading + Math.PI)) : heading;
        double maxT = RobocodeTools.maxTurn(velocity);
        double t = RobocodeTools.bindToRange(Math.tan(Utils.normalRelativeAngle((double)(wantedHeading - heading))), -maxT, maxT);
        heading = Utils.normalRelativeAngle((double)(heading + t));
        velocity *= (double)(reverse ? -1 : 1);
        velocity = maxVel == 0.0 ? (velocity < 0.0 ? Math.min(velocity + 2.0, 0.0) : Math.min(Math.max(maxVel, velocity - 2.0), velocity)) : (velocity < 0.0 ? Math.min(velocity + 2.0, 0.0) : Math.min(Math.max(maxVel, velocity - 2.0), velocity + 1.0));
        nextPoint = RobocodeTools.projectMotion(nextPoint, heading, velocity);
        return nextPoint;
    }

    private void updateDanger(EnemyWave wave) {
        this.flattener = this.enemy.flattenner();
        this.dangerForward = this.updateDanger(this.myLocation, this.enemy.myBearingDirection[0], wave, this.heading, this.velocity, this.time, 8.0);
        this.dangerBack = this.updateDanger(this.myLocation, -this.enemy.myBearingDirection[0], wave, this.heading, this.velocity, this.time, 8.0);
    }

    private double updateDanger(Point2D.Double start, int direction, EnemyWave wave, double heading, double velocity, double time, double maxVel) {
        double d;
        Point2D.Double gunLocation = wave.getGunLocation();
        Point2D.Double nextPoint = new Point2D.Double(start.x, start.y);
        do {
            double wantedheading;
            boolean reverse = Math.abs(Utils.normalRelativeAngle((double)((wantedheading = RobocodeTools.absoluteBearing(nextPoint, this.getNextPoint(direction, nextPoint, gunLocation))) - heading))) > 1.5707963267948966;
            heading = reverse ? Utils.normalRelativeAngle((double)(heading + Math.PI)) : heading;
            double maxT = RobocodeTools.maxTurn(velocity);
            double t = RobocodeTools.bindToRange(Math.tan(Utils.normalRelativeAngle((double)(wantedheading - heading))), -maxT, maxT);
            heading = Utils.normalRelativeAngle((double)(heading + t));
            velocity = velocity < 0.0 ? Math.min(velocity + 2.0, 0.0) : Math.min(Math.max(maxVel, (velocity *= (double)(reverse ? -1 : 1)) - 2.0), velocity + 1.0);
            nextPoint = RobocodeTools.projectMotion(nextPoint, heading, velocity);
            d = time;
            time = d + 1.0;
        } while (wave.distanceToImpact(nextPoint, d) > 18.0);
        double val = wave.danger(nextPoint);
        wave = this.enemy.getNearestWave(nextPoint, time);
        if (wave == null) {
            return val;
        }
        return val + Math.min(this.updateDanger(nextPoint, direction, wave, heading, velocity, time, maxVel), this.updateDanger(nextPoint, -direction, wave, heading, velocity, time, maxVel));
    }

    private GFLog getLog(String key) {
        if (this.logs.containsKey(key)) {
            return this.logs.get(key);
        }
        GFLog log = new GFLog(key);
        this.logs.put(key, log);
        return log;
    }

    public void onEnemyCreation(Enemy enemy) {
        enemy.logDuel = enemy.logDuel == null ? this.getLog(enemy.name) : enemy.logDuel;
    }

    public void execCondition() {
        this.synch();
        this.enemy = TargetSelector.getInstance(this.me, Tracker.getInstance()).getTarget();
        if (this.enemy != null) {
            EnemyWave wave = this.enemy.getNearestWave(this.myLocation, this.time);
            wave = wave == null && this.distance > 150.0 ? this.enemy.lastWave : wave;
            EnemyWave enemyWave = wave = wave == null && this.me.getOthers() == 0 || this.rammer ? this.enemy.lastWave : wave;
            this.score = this.me.getOthers() > 1 ? 0 : (wave == null || this.goHunting() ? 25 : 100);
        } else {
            this.score = Configuration.team ? 0 : 50;
        }
    }

    public int getScore() {
        return this.score;
    }

    public void onDeath(DeathEvent e) {
        Vector hitEvents = this.me.getHitByBulletEvents();
        Vector collisionEvents = this.me.getHitRobotEvents();
        if (!hitEvents.isEmpty()) {
            System.out.println("Death by bullet");
            HitByBulletEvent hitEv = (HitByBulletEvent)hitEvents.get(0);
            this.enemy.onHitByBullet(hitEv);
        } else if (!collisionEvents.isEmpty()) {
            System.out.println("Death by ramming");
        } else {
            System.out.println("Death by unknown source");
        }
    }
}

