/*
 * Decompiled with CFR 0.152.
 */
package gtf.robocode;

import gtf.robocode.Point;
import gtf.robocode.Util;
import gtf.robocode.Vector2D;
import robocode.AdvancedRobot;
import robocode.Condition;
import robocode.GunTurnCompleteCondition;

class Gun {
    protected AdvancedRobot robot;
    double power = 3.0;
    private Point target;

    Gun(AdvancedRobot robot) {
        this.robot = robot;
    }

    void setPower(double power) {
        this.power = power;
    }

    void setTarget(Vector2D target) {
        double newHeading = Util.toHeading(target.x, target.y);
        double turn = Util.normalize(newHeading - this.robot.getGunHeading());
        this.robot.setTurnGunRight(turn);
    }

    double getBulletSpeed() {
        return 20.0 - 3.0 * this.power;
    }

    boolean isReady() {
        return this.target == null && this.robot.getGunHeat() == 0.0;
    }

    void doFire() {
        if (this.robot.getEnergy() > this.power) {
            this.robot.fire(this.power);
        }
    }

    void doTurn() {
        long time = this.robot.getTime();
        this.robot.waitFor((Condition)new GunTurnCompleteCondition(this.robot));
    }
}

