/*
 * Decompiled with CFR 0.152.
 */
package catcat20.core.gun.waveGun;

import catcat20.core.bot.Bot;
import catcat20.core.gun.Gun;
import catcat20.core.gun.waveGun.GunGF;
import catcat20.core.gun.waveGun.GunWave;
import catcat20.core.gun.waveGun.Indice;
import catcat20.core.radar.Radar;
import catcat20.core.utils.LUtils;
import catcat20.core.utils.knn.KNNData;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Arrays;
import robocode.RoundEndedEvent;
import robocode.TeamRobot;
import robocode.util.Utils;

public class WaveGun
extends Gun {
    public Color color;
    public String label;
    public boolean antiSurfer = false;
    public GunWave currentWave;
    Color transRed = new Color(1.0f, 0.0f, 0.0f, 0.1f);
    Color transBlue = new Color(0.0f, 0.0f, 1.0f, 0.1f);
    Point2D.Double myPos;
    BasicStroke fillbs = new BasicStroke(10.0f);
    BasicStroke bs = new BasicStroke(2.5f);
    BasicStroke bsw = new BasicStroke(4.0f);

    public WaveGun(TeamRobot _robot, Color color, String label, boolean antiSurferModel) {
        super(_robot);
        this.color = color;
        this.label = label;
        this.antiSurfer = antiSurferModel;
    }

    @Override
    public void init() {
    }

    @Override
    public void execute() {
    }

    @Override
    public void onRoundEnded(RoundEndedEvent e) {
    }

    public void setWave(GunWave w) {
        this.currentWave = w;
    }

    @Override
    public double getAngle(double power) {
        if (this.currentWave != null) {
            this.myPos = new Point2D.Double(this._robot.getX(), this._robot.getY());
            Graphics2D g = this._robot.getGraphics();
            Point2D.Double drawPos = new Point2D.Double();
            Bot bot = Radar.nearestBot;
            if (bot != null && bot.currentState != null && bot.isAlive) {
                ArrayList<KNNData<GunGF>> nearestNeighbors = null;
                if (this.antiSurfer) {
                    k = bot.antiSurferModel.tree.size() / 10;
                    k = LUtils.limit(1, k, 16);
                    nearestNeighbors = bot.antiSurferModel.getNearestNeighborsList(this.currentWave, k);
                } else {
                    k = (int)Math.sqrt(bot.mainGunModel.tree.size());
                    k = LUtils.limit(1, k, 16);
                    nearestNeighbors = bot.mainGunModel.getNearestNeighborsList(this.currentWave, k);
                }
                double bestAngle = Double.POSITIVE_INFINITY;
                bestAngle = this.gaussDensity(nearestNeighbors);
                if (bestAngle == Double.POSITIVE_INFINITY || Double.isNaN(bestAngle)) {
                    return Double.POSITIVE_INFINITY;
                }
                Stroke reset = g.getStroke();
                g.setStroke(this.bsw);
                LUtils.projectWithCache(this.myPos, bestAngle, 1500.0, drawPos);
                g.setColor(Color.white);
                g.drawLine((int)this.myPos.x, (int)this.myPos.y, (int)drawPos.x, (int)drawPos.y);
                g.setStroke(this.bs);
                LUtils.projectWithCache(this.myPos, bestAngle, 1500.0, drawPos);
                g.setColor(this.getColor());
                g.drawLine((int)this.myPos.x, (int)this.myPos.y, (int)drawPos.x, (int)drawPos.y);
                g.setStroke(reset);
                return bestAngle;
            }
        }
        return Double.POSITIVE_INFINITY;
    }

    public double gaussDensity(ArrayList<KNNData<GunGF>> nearestNeighbors) {
        Graphics2D g = this._robot.getGraphics();
        Point2D.Double drawPos = new Point2D.Double();
        ArrayList<MeleeFiringAngle> firingAngles = new ArrayList<MeleeFiringAngle>();
        double totalWeight = 0.0;
        for (KNNData<GunGF> data : nearestNeighbors) {
            double gf = (((GunGF)data.data).maxGuessFactor + ((GunGF)data.data).minGuessFactor) / 2.0;
            double fireAngle = this.currentWave.firingAngle(gf);
            if (this.antiSurfer) {
                gf = (((GunGF)data.data).preciseMaxGuessFactor + ((GunGF)data.data).preciseMinGuessFactor) / 2.0;
                fireAngle = gf > 0.0 ? this.currentWave.directAngle - gf * (double)this.currentWave.direction * this.currentWave.meas[1] : this.currentWave.directAngle + gf * (double)this.currentWave.direction * this.currentWave.meas[0];
            }
            double scanWeight = 1.0 / Math.sqrt(data.distance);
            double bandwidth = ((GunGF)data.data).maxGuessFactor - ((GunGF)data.data).minGuessFactor;
            totalWeight += scanWeight;
            MeleeFiringAngle angle = new MeleeFiringAngle(fireAngle, 0.0, bandwidth, scanWeight);
            firingAngles.add(angle);
            LUtils.projectWithCache(this.myPos, angle.angle, 130.0, drawPos);
            g.setColor(this.transRed);
            if (this.antiSurfer) {
                g.setColor(this.transBlue);
            }
            double fireAngle1 = this.currentWave.firingAngle(((GunGF)data.data).minGuessFactor);
            double fireAngle2 = this.currentWave.firingAngle(((GunGF)data.data).maxGuessFactor);
            double width = ((GunGF)data.data).maxGuessFactor - ((GunGF)data.data).minGuessFactor;
            g.fillArc((int)this.myPos.x - 150, (int)this.myPos.y - 150, 300, 300, (int)Math.toDegrees(fireAngle1), (int)Math.toDegrees(width));
        }
        Double bestAngle = null;
        double bestDensity = Double.NEGATIVE_INFINITY;
        for (MeleeFiringAngle xFiringAngle : firingAngles) {
            double xDensity = 0.0;
            for (MeleeFiringAngle yFiringAngle : firingAngles) {
                double ux = Utils.normalRelativeAngle((double)(xFiringAngle.angle - yFiringAngle.angle)) / yFiringAngle.bandwidth;
                xDensity += yFiringAngle.scanWeight * Math.exp(-0.5 * ux * ux) / yFiringAngle.distance;
            }
            if (!(xDensity > bestDensity)) continue;
            bestAngle = xFiringAngle.angle;
            bestDensity = xDensity;
        }
        if (bestAngle == null) {
            return Double.POSITIVE_INFINITY;
        }
        return bestAngle;
    }

    public double maxOverlap(ArrayList<KNNData<GunGF>> nearestNeighbors) {
        if (nearestNeighbors.isEmpty()) {
            return Double.POSITIVE_INFINITY;
        }
        Graphics2D g = this._robot.getGraphics();
        Object[] indices = new Indice[nearestNeighbors.size() * 2];
        int k = nearestNeighbors.size();
        for (int i = 0; i < k; ++i) {
            KNNData<GunGF> e = nearestNeighbors.get(i);
            g.setColor(this.transRed);
            double fireAngle1 = this.currentWave.firingAngle(((GunGF)e.data).minGuessFactor);
            double fireAngle2 = this.currentWave.firingAngle(((GunGF)e.data).maxGuessFactor);
            double width = this.currentWave.maxEscapeAngle() * (((GunGF)e.data).maxGuessFactor - ((GunGF)e.data).minGuessFactor);
            g.fillArc((int)this.myPos.x - 150, (int)this.myPos.y - 150, 300, 300, (int)Math.toDegrees(fireAngle1), (int)Math.toDegrees(width));
            double weight = 1.0;
            Indice ind = new Indice();
            ind.position = ((GunGF)e.data).minGuessFactor;
            ind.height = weight;
            indices[i * 2] = ind;
            ind = new Indice();
            ind.position = ((GunGF)e.data).maxGuessFactor;
            ind.height = -weight;
            indices[i * 2 + 1] = ind;
        }
        Arrays.sort(indices);
        int maxIndex = indices.length / 2 - 1;
        double value = 0.0;
        double maxValue = 0.0;
        for (int i = 0; i < indices.length - 1; ++i) {
            if (!((value += ((Indice)indices[i]).height) >= maxValue)) continue;
            maxIndex = i;
            maxValue = value;
        }
        double fireGF = (((Indice)indices[maxIndex]).position + ((Indice)indices[maxIndex + 1]).position) / 2.0;
        System.out.println(fireGF);
        return this.currentWave.firingAngle(fireGF);
    }

    public void logHit(GunWave w) {
        Bot bot = Radar.nearestBot;
        if (bot != null && bot.currentState != null && bot.isAlive) {
            GunGF gf = new GunGF();
            gf.maxGuessFactor = w.maxGuessFactor;
            gf.minGuessFactor = w.minGuessFactor;
            gf.preciseMinGuessFactor = w.preciseMinGuessFactor;
            gf.preciseMaxGuessFactor = w.preciseMaxGuessFactor;
            if (this.antiSurfer) {
                bot.antiSurferModel.addPoint(w, gf);
            } else {
                bot.mainGunModel.addPoint(w, gf);
            }
        }
    }

    @Override
    public Color getColor() {
        return this.color;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public void onPaint(Graphics2D g) {
    }

    private static class MeleeFiringAngle {
        public final double angle;
        public final double distance;
        public final double bandwidth;
        public double scanWeight;

        public MeleeFiringAngle(double angle, double distance, double bandwidth, double scanWeight) {
            this.angle = angle;
            this.distance = distance;
            this.bandwidth = bandwidth;
            this.scanWeight = scanWeight;
        }
    }
}

