/*
 * Decompiled with CFR 0.152.
 */
package pedersen.core;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import pedersen.core.SnapshotHistoryBase;
import pedersen.core.Targetable;
import pedersen.debug.Debug;
import pedersen.divination.CombatWave;
import pedersen.divination.FiringAngle;
import pedersen.systems.FireControl;
import pedersen.tactics.grail.WaveAnalysis;
import pedersen.tactics.movement.MovementMethod;
import pedersen.tactics.movement.MovementMethodSet;
import pedersen.tactics.targeting.TargetingMethod;

public class TargetableBase
extends SnapshotHistoryBase
implements Targetable {
    private final WaveAnalysis offensiveWaveAnalysis = new WaveAnalysis();
    private final WaveAnalysis defensiveWaveAnalysis = new WaveAnalysis();
    protected MovementMethodSet movementMethods;
    protected List defensiveTargetingMethods;
    protected List offensiveTargetingMethods = new ArrayList();
    protected FireControl fireControl = null;
    private boolean isActive = true;
    private long lastShotFired = 0L;
    private double lastShotFirepower = 3.0;

    public TargetableBase() {
        this.defensiveTargetingMethods = new ArrayList();
    }

    public void attachFiringAngles(CombatWave wave) {
        Iterator iterator = this.defensiveTargetingMethods.iterator();
        while (iterator.hasNext()) {
            TargetingMethod targetingMethod = (TargetingMethod)iterator.next();
            FiringAngle firingAngle = targetingMethod.getFiringAngle(wave, 1L);
            if (firingAngle == null) continue;
            wave.addFiringAngle(firingAngle);
        }
    }

    public TargetingMethod getFavoredTargetingMethod() {
        TargetingMethod preferredTargetingMethod = null;
        double preferredSuccessRate = 0.0;
        Iterator iterator = this.defensiveTargetingMethods.iterator();
        while (iterator.hasNext()) {
            TargetingMethod targetingMethod = (TargetingMethod)iterator.next();
            double successRate = targetingMethod.getTargetingStatistics().getSuccessRate();
            if (preferredTargetingMethod != null && !(successRate > preferredSuccessRate)) continue;
            preferredTargetingMethod = targetingMethod;
            preferredSuccessRate = successRate;
        }
        return preferredTargetingMethod;
    }

    public void debug() {
        Debug.debug("Targetable Base:");
        Iterator iterator = this.defensiveTargetingMethods.iterator();
        while (iterator.hasNext()) {
            ((TargetingMethod)iterator.next()).debug();
        }
        iterator = this.movementMethods.getDynamicMovementMethods().iterator();
        while (iterator.hasNext()) {
            ((MovementMethod)iterator.next()).debug();
        }
        super.debug();
    }

    public WaveAnalysis getOffensiveWaveAnalysis() {
        return this.offensiveWaveAnalysis;
    }

    public WaveAnalysis getDefensiveWaveAnalysis() {
        return this.defensiveWaveAnalysis;
    }

    public void activate() {
        this.isActive = true;
    }

    public void deactivate() {
        this.isActive = false;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public List getDefensiveTargetingMethods() {
        return this.defensiveTargetingMethods;
    }

    public List getOffensiveTargetingMethods() {
        return this.offensiveTargetingMethods;
    }

    public void setFireControl(FireControl newFireControl) {
        this.fireControl = newFireControl;
    }

    public FireControl getFireControl() {
        return this.fireControl;
    }

    public void setLastShotFired(long time) {
        this.lastShotFired = time;
    }

    public long getLastShotFired() {
        return this.lastShotFired;
    }

    public void setLastShotFirepower(double firepower) {
        this.lastShotFirepower = firepower;
    }

    public double getLastShotFirepower() {
        return this.lastShotFirepower;
    }

    public MovementMethodSet getMovementMethods() {
        return this.movementMethods;
    }
}

