/*
 * Decompiled with CFR 0.152.
 */
package pedersen.tactics.grail;

import java.util.Iterator;
import pedersen.divination.WaveData;
import pedersen.tactics.grail.Segment;
import pedersen.tactics.grail.SegmentAccelerationImpl;
import pedersen.tactics.grail.SegmentBase;
import pedersen.tactics.targeting.TargetingMethod;

public class SegmentBulletFlightTimeImpl
extends SegmentBase
implements Segment {
    public static final double maximumValue = 100.0;
    private static final int maxBinSize = 10;

    public SegmentBulletFlightTimeImpl() {
        super(100.0, 10);
        this.zero = new SegmentAccelerationImpl();
        this.positive = new SegmentAccelerationImpl[0];
        this.negative = new SegmentAccelerationImpl[0];
        this.buildOrganicBins();
    }

    protected void buildOrganicBins() {
        if (this.positiveBinSize != this.positive.length) {
            this.positive = new SegmentAccelerationImpl[this.positiveBinSize];
            int i = 0;
            while (i < this.positiveBinSize) {
                this.positive[i] = new SegmentAccelerationImpl();
                ++i;
            }
            Iterator iterator = this.positiveWaveData.iterator();
            while (iterator.hasNext()) {
                this.addWaveDataBypass((WaveData)iterator.next());
            }
        }
        if (this.negativeBinSize != this.negative.length) {
            this.negative = new SegmentAccelerationImpl[this.negativeBinSize];
            int i = 0;
            while (i < this.negativeBinSize) {
                this.negative[i] = new SegmentAccelerationImpl();
                ++i;
            }
            Iterator iterator = this.negativeWaveData.iterator();
            while (iterator.hasNext()) {
                this.addWaveDataBypass((WaveData)iterator.next());
            }
        }
    }

    public void addWaveData(WaveData waveData) {
        super.addWaveData(waveData, waveData.originalTimeToTarget);
    }

    public void addWaveDataBypass(WaveData waveData) {
        super.addWaveDataBypass(waveData, waveData.originalTimeToTarget);
    }

    public double getMostVisitedBearingOffset(WaveData waveData) {
        return super.getMostVisitedBearingOffset(waveData, waveData.originalTimeToTarget);
    }

    public double getLeastVisitedBearingOffset(WaveData waveData) {
        return super.getLeastVisitedBearingOffset(waveData, waveData.originalTimeToTarget);
    }

    public double getMostVisitedLinearProjection(WaveData waveData) {
        return super.getMostVisitedLinearProjection(waveData, waveData.originalTimeToTarget);
    }

    public TargetingMethod getFavoredTargetingMethod(WaveData waveData) {
        return super.getFavoredTargetingMethod(waveData, waveData.originalTimeToTarget);
    }
}

