/*
 * Decompiled with CFR 0.152.
 */
package rsalesc.roborio.utils.colors;

import java.awt.Color;
import java.util.Arrays;
import rsalesc.roborio.utils.R;
import rsalesc.roborio.utils.colors.ColorUtils;

public class Gradient {
    private final GradientColor[] colors;

    public Gradient(GradientColor[] gradientColorArray) {
        Object[] objectArray = Arrays.copyOf(gradientColorArray, gradientColorArray.length);
        Arrays.sort(objectArray);
        this.colors = new GradientColor[gradientColorArray.length + 2];
        this.colors[0] = new GradientColor(((GradientColor)objectArray[0]).color, 0.0);
        this.colors[this.colors.length - 1] = new GradientColor(((GradientColor)objectArray[objectArray.length - 1]).color, 1.0);
        for (int i = 0; i < objectArray.length; ++i) {
            this.colors[i + 1] = objectArray[i];
        }
    }

    public Color evaluate(double d) {
        d = R.constrain(0.0, d, 1.0);
        GradientColor gradientColor = this.colors[0];
        for (int i = 1; i < this.colors.length; ++i) {
            if (d < this.colors[i].x) {
                if (R.isNear(this.colors[i].x, gradientColor.x)) {
                    return this.colors[i].color;
                }
                return ColorUtils.interpolateRGB(gradientColor.color, this.colors[i].color, (d - gradientColor.x) / (this.colors[i].x - gradientColor.x));
            }
            gradientColor = this.colors[i];
        }
        return gradientColor.color;
    }

    public static class GradientColor
    implements Comparable {
        private double x;
        private Color color;

        public GradientColor(Color color, double d) {
            this.x = d;
            this.color = color;
        }

        public int compareTo(Object object) {
            if (!(object instanceof GradientColor)) {
                throw new ClassCastException("Gradient object expected");
            }
            return (int)Math.signum(this.x - ((GradientColor)object).x);
        }
    }
}

