/*
 * Decompiled with CFR 0.152.
 */
package tcf;

import robocode.Rules;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;
import tcf.Bot;

class SimBot
implements Bot {
    String m_name;
    long m_time;
    double m_x;
    double m_y;
    double m_speed;
    double m_heading;

    SimBot() {
    }

    SimBot(Bot bot) {
        this.m_name = bot.name();
        this.m_time = bot.time();
        this.m_x = bot.x();
        this.m_y = bot.y();
        this.m_speed = bot.speed();
        this.m_heading = bot.heading();
    }

    SimBot(String string, long l, double d, double d2, double d3, double d4) {
        this.m_name = string;
        this.m_time = l;
        this.m_x = d;
        this.m_y = d2;
        this.m_speed = d4;
        this.m_heading = d3;
    }

    void init(String string, long l, double d, double d2, double d3, double d4) {
        this.m_name = string;
        this.m_time = l;
        this.m_x = d;
        this.m_y = d2;
        this.m_speed = d4;
        this.m_heading = d3;
    }

    void copyFrom(Bot bot) {
        this.m_name = bot.name();
        this.m_time = bot.time();
        this.m_x = bot.x();
        this.m_y = bot.y();
        this.m_speed = bot.speed();
        this.m_heading = bot.heading();
    }

    void copyFrom(ScannedRobotEvent scannedRobotEvent, Bot bot) {
        this.m_name = scannedRobotEvent.getName();
        this.m_time = scannedRobotEvent.getTime();
        double d = scannedRobotEvent.getBearingRadians() + bot.heading();
        this.m_x = bot.x() + scannedRobotEvent.getDistance() * Math.sin(d);
        this.m_y = bot.y() + scannedRobotEvent.getDistance() * Math.cos(d);
        this.m_speed = scannedRobotEvent.getVelocity();
        this.m_heading = scannedRobotEvent.getHeadingRadians();
    }

    public String name() {
        return this.m_name;
    }

    public long time() {
        return this.m_time;
    }

    public boolean isDead() {
        return false;
    }

    public double x() {
        return this.m_x;
    }

    public double y() {
        return this.m_y;
    }

    public double speed() {
        return this.m_speed;
    }

    public double heading() {
        return this.m_heading;
    }

    void next(double d, double d2) {
        double d3 = Utils.normalRelativeAngle((double)(d - this.m_heading));
        double d4 = Rules.getTurnRateRadians((double)this.m_speed);
        if (Math.abs(d3) > d4) {
            d3 = Math.signum(d3) * d4;
        }
        this.m_heading += d3;
        double d5 = d2 - this.m_speed;
        if (this.m_speed == 0.0) {
            if (Math.abs(d5) > 1.0) {
                d5 = Math.signum(d5);
            }
        } else if (this.m_speed < 0.0) {
            if (d5 < -1.0) {
                d5 = -1.0;
            } else if (d5 > 2.0) {
                d5 = 2.0;
            }
        } else if (d5 > 1.0) {
            d5 = 1.0;
        } else if (d5 < -2.0) {
            d5 = -2.0;
        }
        this.m_speed += d5;
        this.m_x += this.m_speed * Math.sin(this.m_heading);
        this.m_y += this.m_speed * Math.cos(this.m_heading);
    }
}

