/*
 * Decompiled with CFR 0.152.
 */
package catcat20.helios.rader;

import catcat20.helios.robot.Bot;
import catcat20.helios.robot.BotState;
import catcat20.helios.utils.HUtils;
import catcat20.jewel.iolite.radar.IoliteRadar;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import robocode.RobotDeathEvent;
import robocode.Rules;
import robocode.ScannedRobotEvent;
import robocode.TeamRobot;
import robocode.util.Utils;

public class HeliosRadar {
    public TeamRobot robot;
    public static Bot nearestBot;
    public static long dirChangeTime;
    public static ArrayList<BotState> oldMyStates;
    public static BotState currentMyState;
    public static HashMap<String, Bot> enemies;
    static LinkedHashMap<String, Double> enemyHashMap;
    static double scanDir;
    static Object sought;
    private static double power;

    public HeliosRadar(TeamRobot robot) {
        this.robot = robot;
        nearestBot = null;
        enemies = new HashMap();
    }

    public void init() {
        scanDir = 1.0;
        enemyHashMap = new LinkedHashMap(5, 2.0f, true);
        for (Bot bot : enemies.values()) {
            bot.alive = false;
            bot.currentState = null;
            bot.botStateLogs = new ArrayList();
        }
        oldMyStates = new ArrayList();
    }

    public void onTick() {
        Point2D.Double myPos = new Point2D.Double(this.robot.getX(), this.robot.getY());
        BotState myState = new BotState(this.robot.getTime(), this.robot.getEnergy(), myPos, this.robot.getVelocity(), this.robot.getHeadingRadians());
        oldMyStates.add(0, myState);
        if (currentMyState != null) {
            myState.currentGF = HeliosRadar.currentMyState.currentGF;
        }
        currentMyState = myState;
        if (this.robot.getOthers() > 1) {
            this.robot.setTurnRadarRightRadians(scanDir * Double.POSITIVE_INFINITY);
        } else if (nearestBot != null && HeliosRadar.nearestBot.currentState != null) {
            this.oneRadar(myPos, nearestBot);
        }
        Graphics2D g = this.robot.getGraphics();
        double others = this.robot.getOthers();
        String myName = this.robot.getName();
        double nearestDistance = Double.POSITIVE_INFINITY;
        for (Bot bot : enemies.values()) {
            double radius;
            BotState nbState;
            BotState state;
            if (!bot.alive) continue;
            bot.tickUpdate(this.robot);
            double distance = bot.currentState.getPosition().distance(myPos);
            if (distance < nearestDistance) {
                nearestDistance = distance;
                nearestBot = bot;
            }
            if ((state = bot.currentState) == null) continue;
            Bot nearBot = HeliosRadar.getBot(bot.nearestBotName);
            if (nearBot != null) {
                nbState = nearBot.currentState;
                if (nbState == null) continue;
                radius = nbState.getPosition().distance(state.getPosition());
                g.setColor(new Color(255, 0, 0, 60));
                g.fillOval((int)(state.getPosition().x - radius), (int)(state.getPosition().y - radius), (int)(radius * 2.0), (int)(radius * 2.0));
                continue;
            }
            if (!bot.nearestBotName.equals(myName) || (nbState = myState) == null) continue;
            radius = nbState.getPosition().distance(state.getPosition());
            g.setColor(new Color(255, 0, 0, 60));
            g.fillOval((int)(state.getPosition().x - radius), (int)(state.getPosition().y - radius), (int)(radius * 2.0), (int)(radius * 2.0));
        }
        this.updatePower();
    }

    public void updatePower() {
        power = 1.95;
        Point2D.Double myPos = new Point2D.Double(this.robot.getX(), this.robot.getY());
        int others = this.robot.getOthers();
        if (nearestBot != null && HeliosRadar.nearestBot.currentState != null) {
            double distance = HeliosRadar.nearestBot.currentState.getPosition().distance(myPos);
            if (others <= 1) {
                BotState en = HeliosRadar.nearestBot.currentState;
                power = 1.95;
                if (en != null) {
                    power = nearestBot.predictNextPower(this.robot, 1.95) + 0.05;
                    if (this.robot.getEnergy() <= 8.0) {
                        power = 0.1;
                    }
                    if (distance <= 110.0) {
                        power = 3.0;
                    }
                    if (distance <= 260.0) {
                        power = 2.95;
                    }
                    if (distance <= 325.0) {
                        power = 2.45;
                    }
                    double minimumKillPower = 0.001 + en.getEnergy() / 4.0;
                    if (en.getEnergy() > 4.0) {
                        minimumKillPower = 0.001 + (en.getEnergy() + 2.0) / 6.0;
                    }
                    power = Math.min(minimumKillPower, power);
                    power = Math.min(power, this.robot.getEnergy() - 0.15);
                }
            } else {
                power = 1.95;
                BotState en = HeliosRadar.nearestBot.currentState;
                if (this.robot.getEnergy() <= 16.0) {
                    power = 1.05;
                }
                if (this.robot.getEnergy() <= 8.0) {
                    power = 0.1;
                }
                if (en != null) {
                    if (distance >= 650.0) {
                        power = 1.05;
                    }
                    if (en.getEnergy() <= 8.0) {
                        power = en.getEnergy() / 4.0;
                    }
                    if (IoliteRadar.others >= 5.0) {
                        power = 2.95;
                    } else if (IoliteRadar.others >= 2.0) {
                        power = 0.95 + IoliteRadar.others * 0.2;
                    }
                    if (distance <= 325.0) {
                        power = 2.999999;
                    }
                    if (distance <= 175.0) {
                        power = 3.0;
                    }
                }
                power = Math.min(this.robot.getEnergy() - 0.05, power);
            }
        }
    }

    public static double calculatePower() {
        return power;
    }

    public void oneRadar(Point2D.Double myPos, Bot bot) {
        double angleToEnemy = HUtils.absoluteBearing(myPos, bot.currentState.getPosition());
        double radarTurn = Utils.normalRelativeAngle((double)(angleToEnemy - this.robot.getRadarHeadingRadians()));
        double extraTurn = Math.min(Math.atan(36.0 / myPos.distance(bot.currentState.getPosition())), Rules.RADAR_TURN_RATE_RADIANS);
        radarTurn = radarTurn < 0.0 ? (radarTurn -= extraTurn) : (radarTurn += extraTurn);
        this.robot.setTurnRadarRightRadians(radarTurn);
    }

    public static Bot getBot(String name) {
        return enemies.get(name);
    }

    public void onScannedRobotEvent(ScannedRobotEvent e) {
        if (!enemies.containsKey(e.getName())) {
            enemies.put(e.getName(), new Bot());
        }
        HeliosRadar.enemies.get((Object)e.getName()).alive = true;
        enemies.get(e.getName()).scannedUpdate(this.robot, e);
        HeliosRadar.enemies.get((Object)e.getName()).lastScanTime = e.getTime();
        String name = e.getName();
        LinkedHashMap<String, Double> ehm = enemyHashMap;
        ehm.put(name, this.robot.getHeadingRadians() + e.getBearingRadians());
        if ((name == sought || sought == null) && ehm.size() == this.robot.getOthers()) {
            scanDir = Utils.normalRelativeAngle((double)(ehm.values().iterator().next() - this.robot.getRadarHeadingRadians()));
            sought = ehm.keySet().iterator().next();
        }
    }

    public void onRobotDeath(RobotDeathEvent e) {
        enemyHashMap.remove(e.getName());
        sought = null;
        if (enemies.containsKey(e.getName())) {
            HeliosRadar.enemies.get((Object)e.getName()).alive = false;
        }
    }

    static {
        power = 1.95;
    }
}

