/*
 * Decompiled with CFR 0.152.
 */
package catcat20.jewel.iolite.utils;

import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import robocode.AdvancedRobot;
import robocode.util.Utils;

public class IUtils {
    public static final double HALF_PI = 1.5707963267948966;
    public static final double TWO_PI = Math.PI * 2;

    public static double[] intersectSegCircle(double cx, double cy, double r, double lax, double lay, double lbx, double lby) {
        double a0;
        double l;
        double a1;
        double discr;
        double diffx = cx - lax;
        double diffy = cy - lay;
        double dirx = lbx - lax;
        double diry = lby - lay;
        if ((discr = (a1 = diffx * (dirx /= (l = Math.sqrt(dirx * dirx + diry * diry))) + diffy * (diry /= l)) * a1 - (a0 = diffx * diffx + diffy * diffy - r * r)) > 0.0) {
            double lengthSq = (lbx - lax) * (lbx - lax) + (lby - lay) * (lby - lay);
            discr = Math.sqrt(discr);
            double m1 = a1 - discr;
            double m2 = a1 + discr;
            if (m1 > 0.0 && m1 * m1 < lengthSq && m2 > 0.0 && m2 * m2 < lengthSq) {
                return new double[]{lax + m1 * dirx, lay + m1 * diry, lax + m2 * dirx, lay + m2 * diry};
            }
            if (m1 > 0.0 && m1 * m1 < lengthSq) {
                return new double[]{lax + m1 * dirx, lay + m1 * diry};
            }
            if (m2 > 0.0 && m2 * m2 < lengthSq) {
                return new double[]{lax + m2 * dirx, lay + m2 * diry};
            }
        } else if (discr == 0.0) {
            double lengthSq = (lbx - lax) * (lbx - lax) + (lby - lay) * (lby - lay);
            if (a1 > 0.0 && a1 * a1 < lengthSq) {
                return new double[]{lax + a1 * dirx, lay + a1 * diry};
            }
        }
        return new double[0];
    }

    public static Line2D.Double projection(double x, double y, double angle, double dist) {
        Line2D.Double line = new Line2D.Double();
        line.x1 = x;
        line.y1 = y;
        line.x2 = x + Math.sin(angle) * dist;
        line.y2 = y + Math.cos(angle) * dist;
        return line;
    }

    public static final Line2D.Double projection(double x, double y, double angle, double dist1, double dist2) {
        Line2D.Double line = new Line2D.Double();
        line.x1 = x + Math.sin(angle) * dist1;
        line.y1 = y + Math.cos(angle) * dist1;
        line.x2 = x + Math.sin(angle) * dist2;
        line.y2 = y + Math.cos(angle) * dist2;
        return line;
    }

    public static void goTo(AdvancedRobot robot, Point2D.Double pos) {
        pos.x -= robot.getX();
        pos.y -= robot.getY();
        double goAngle = Utils.normalRelativeAngle((double)(Math.atan2(pos.x, pos.y) - robot.getHeadingRadians()));
        robot.setTurnRightRadians(Math.atan(Math.tan(goAngle)));
        robot.setAhead(Math.cos(goAngle) * Math.hypot(pos.x, pos.y));
    }

    public static double accel(double velocity, double previousVelocity) {
        double accel = velocity - previousVelocity;
        accel = previousVelocity == 0.0 ? Math.abs(accel) : (accel *= Math.signum(previousVelocity));
        return accel;
    }

    public static final double getWallDistance(Point2D.Double center, Rectangle2D.Double field, double eDist, double eAngle, double oDir) {
        double WALL_MARGIN = 18.0;
        return Math.min(Math.min(Math.min(IUtils.distanceWest(field.getMaxY() - 18.0 - center.y, eDist, eAngle - 1.5707963267948966, oDir), IUtils.distanceWest(field.getMaxX() - 18.0 - center.x, eDist, eAngle + Math.PI, oDir)), IUtils.distanceWest(center.y - 18.0, eDist, eAngle + 1.5707963267948966, oDir)), IUtils.distanceWest(center.x - 18.0, eDist, eAngle, oDir));
    }

    private static final double distanceWest(double toWall, double eDist, double eAngle, double oDir) {
        if (eDist <= toWall) {
            return Double.POSITIVE_INFINITY;
        }
        double wallAngle = Math.acos(-oDir * toWall / eDist) + oDir * 1.5707963267948966;
        return Utils.normalAbsoluteAngle((double)(oDir * (wallAngle - eAngle)));
    }

    public static double cube(double d) {
        return d * d * d;
    }

    public static double[] generateFiringAngles(int numAngles, double maxEscapeAngle) {
        int gfZero = (numAngles - 1) / 2;
        double[] firingAngles = new double[numAngles];
        for (int x = 0; x < numAngles; ++x) {
            firingAngles[x] = (double)(x - gfZero) / (double)gfZero * maxEscapeAngle;
        }
        return firingAngles;
    }

    public static double maxEscapeAngle(double bulletVelocity) {
        return Math.asin(8.0 / bulletVelocity);
    }

    public static Point2D.Double project(Point2D.Double sourceLocation, double angle, double length) {
        return new Point2D.Double(sourceLocation.x + Math.sin(angle) * length, sourceLocation.y + Math.cos(angle) * length);
    }

    public static Point2D.Double projectWithCache(Point2D.Double sourceLocation, double angle, double length, Point2D.Double cache) {
        cache.setLocation(sourceLocation.x + Math.sin(angle) * length, sourceLocation.y + Math.cos(angle) * length);
        return cache;
    }

    public static double absoluteBearing(Point2D.Double source, Point2D.Double target) {
        return Math.atan2(target.x - source.x, target.y - source.y);
    }

    public static int sign(double v) {
        return v < 0.0 ? -1 : 1;
    }

    public static double limit(double min, double value, double max) {
        return Math.max(min, Math.min(value, max));
    }

    public static double botWidthAimAngle(double distance) {
        return Math.abs(18.0 / distance);
    }

    public static double normalizeAngle(double angle, double reference) {
        double normDiff = reference - angle;
        while (Math.abs(normDiff) > Math.PI) {
            normDiff = reference - (angle += Math.signum(normDiff) * (Math.PI * 2));
        }
        return angle;
    }

    public static double distanceToWall(Point2D.Double enemyLocation, Rectangle2D.Double battleField) {
        return Math.abs(Math.min(Math.min(enemyLocation.x - 18.0, battleField.width - 18.0 - enemyLocation.x), Math.min(enemyLocation.y - 18.0, battleField.height - 18.0 - enemyLocation.y)));
    }

    public static void setBackAsFront(AdvancedRobot robot, double goAngle) {
        double angle = Utils.normalRelativeAngle((double)(goAngle - robot.getHeadingRadians()));
        if (Math.abs(angle) > 1.5707963267948966) {
            if (angle < 0.0) {
                robot.setTurnRightRadians(Math.PI + angle);
            } else {
                robot.setTurnLeftRadians(Math.PI - angle);
            }
            robot.setBack(100.0);
        } else {
            if (angle < 0.0) {
                robot.setTurnLeftRadians(-1.0 * angle);
            } else {
                robot.setTurnRightRadians(angle);
            }
            robot.setAhead(100.0);
        }
    }
}

