/*
 * Decompiled with CFR 0.152.
 */
package ola;

import java.util.HashMap;
import java.util.Map;
import ola.Coordinate;
import ola.Direction;
import ola.Log;
import ola.MovingObject;
import ola.Movment;
import robocode.AdvancedRobot;
import robocode.ScannedRobotEvent;

public abstract class Base
extends AdvancedRobot {
    private static final double FULL_TURN = 360.0;
    protected Map<String, MovingObject> targets = new HashMap<String, MovingObject>();

    public void run() {
        this.init();
        while (true) {
            this.logTurnStart();
            this.action();
            this.execute();
        }
    }

    protected abstract void action();

    private void logTurnStart() {
        this.logTitle("Turn start");
        this.logValue("time", this.getTime());
        this.logValue("pos", this.getCurrentPos());
        this.logValue("movement", this.getCurrentMovment());
    }

    protected void logTitle(String msg) {
        this.out.printf("-- %-15s --------------------------%n", msg);
    }

    protected Movment getCurrentMovment() {
        return new Movment(this.getHeading(), this.getVelocity());
    }

    protected void logValue(String name, Object value) {
        this.out.printf("  %-10s: %s%n", name, value);
    }

    private void init() {
        Log.setOut(this.out);
        this.setAdjustRadarForGunTurn(true);
        this.setAdjustGunForRobotTurn(true);
        this.setTurnRadarRight(Double.POSITIVE_INFINITY);
        this.setTurnRight(Double.MAX_VALUE);
        this.setAhead(Double.MAX_VALUE);
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        MovingObject target = this.getTargetInfo(e);
        this.storeTarget(target);
        this.swapRadarDir();
    }

    private void swapRadarDir() {
        this.setTurnRadarLeft(this.getRadarTurnRemaining());
    }

    private boolean radarTurningRight() {
        return this.getTurnRemaining() > 0.0;
    }

    private void storeTarget(MovingObject target) {
        this.targets.put(target.getName(), target);
    }

    protected void turnGunTo(Direction aimAt) {
        double difference = aimAt.difference(this.getCurrentGunHeading());
        this.setTurnGunRight(difference);
    }

    public Direction getCurrentGunHeading() {
        return new Direction(this.getGunHeading());
    }

    private MovingObject getTargetInfo(ScannedRobotEvent e) {
        Direction absoluteBaring = this.getCurrentHeading().turn(e.getBearing());
        Coordinate targetPos = this.getCurrentPos().move(e.getDistance(), absoluteBaring);
        Movment movment = new Movment(e.getHeading(), e.getVelocity());
        return new MovingObject(e.getTime(), targetPos, movment, e.getName());
    }

    public Direction getCurrentHeading() {
        return new Direction(this.getHeading());
    }

    public Coordinate getCurrentPos() {
        double myX = this.getX();
        double myY = this.getY();
        Coordinate coordinate = new Coordinate(myX, myY);
        return coordinate;
    }
}

