/*
 * Decompiled with CFR 0.152.
 */
package br2;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class MD_AStarNode {
    public int m_row;
    public int m_column;
    public int m_index;
    public int m_pixelCount;
    public int m_gridCount;
    public double m_H_heuristic;
    public double m_G_movementCost;
    public double m_G_dangerCost;
    public double m_G_edgeCost;
    public double m_F_sum;
    public MD_AStarNode m_parent;
    public boolean m_startLocation;
    public boolean m_finalDestination;

    public MD_AStarNode(int row, int column, int pix, int gridCount) {
        this.m_row = row;
        this.m_column = column;
        this.m_index = row * gridCount + column;
        this.m_pixelCount = pix;
        this.m_gridCount = gridCount;
        this.m_H_heuristic = 0.0;
        this.m_G_movementCost = 0.0;
        this.m_G_dangerCost = 0.0;
        this.m_G_edgeCost = 0.0;
        if (row == 0 || row == gridCount - 1 || column == 0 || column == gridCount - 1) {
            this.m_G_edgeCost = 60.0;
        }
        this.m_F_sum = 0.0;
        this.m_parent = null;
        this.m_startLocation = false;
        this.m_finalDestination = false;
    }

    public Point2D.Double getNodeCenter() {
        return new Point2D.Double(this.m_column * this.m_pixelCount + this.m_pixelCount / 2, this.m_row * this.m_pixelCount + this.m_pixelCount / 2);
    }

    public void onPaintPath(Graphics2D g) {
        int blue = 255;
        if ((this.m_row + this.m_column) % 2 == 0) {
            blue = 128;
        }
        g.setColor(new Color(0, 0, blue, 112));
        g.fill(new Rectangle2D.Double(this.m_column * this.m_pixelCount, this.m_row * this.m_pixelCount, this.m_pixelCount, this.m_pixelCount));
    }

    public void onPaintDanger(Graphics2D g) {
        int red = 255;
        double cost = (this.m_G_dangerCost + this.m_G_edgeCost) / 90.0;
        if ((red = (int)((double)red * (cost * cost))) > 255) {
            red = 255;
        }
        g.setColor(new Color(255, 0, 0, red));
        g.fill(new Rectangle2D.Double(this.m_column * this.m_pixelCount, this.m_row * this.m_pixelCount, this.m_pixelCount, this.m_pixelCount));
    }
}

