/*
 * Decompiled with CFR 0.152.
 */
package rz.a;

import rz.a.AbstractRobot;
import rz.a.Point;

public class Wave {
    public Point gunLocation;
    public Point referencePoint;
    public double absBearing;
    public double dangerBearing;
    public double bulletVelocity;
    public double bearingDirection;
    public long shotTime;
    public double[] hitFactors;
    public double[] flatFactors;
    public int flat;
    public int size;
    public int mid;
    public boolean passed;
    public boolean done;

    public double danger(int i) {
        return this.hitFactors[i - 1] / (double)2 + this.hitFactors[i] + this.hitFactors[i + 1] / (double)2;
    }

    public boolean testFar(Point pos, long time) {
        boolean bl = false;
        if (this.travel(time) >= this.gunLocation.distance(pos) + 50.0) {
            bl = true;
        }
        return bl;
    }

    public boolean testHit(Point pos, long time) {
        boolean bl = false;
        if (this.travel(time) >= this.gunLocation.distance(pos)) {
            bl = true;
        }
        return bl;
    }

    public double travel(long time) {
        return this.bulletVelocity * (double)(time - this.shotTime);
    }

    public void updateStats(AbstractRobot ar, double[] factors, double bulletHeading, int factor) {
        int hitIndex = this.getIndex(ar, bulletHeading);
        int i = 0;
        while (i < this.size) {
            factors[i] = i == hitIndex ? this.rollingAverage(factors[i], factor, 1) : this.rollingAverage(factors[i], factor, 0);
            ++i;
        }
    }

    public double rollingAverage(double value, int factor, int weight) {
        return (value * (double)factor + (double)weight) / (double)(factor + 1);
    }

    public int getIndex(AbstractRobot ar, double angle) {
        return (int)Math.max(0L, Math.min(Math.round(AbstractRobot.normalAngle(angle - this.absBearing) / this.bearingDirection) + (long)this.mid, (long)(this.size - 1)));
    }

    public Wave(Point p, double angle, double vel, double dir, long time, double[] hitFac, double[] flat, boolean distr) {
        this.gunLocation = new Point(p.x, p.y);
        this.absBearing = angle;
        this.bulletVelocity = vel;
        this.bearingDirection = dir;
        this.shotTime = time;
        this.hitFactors = hitFac;
        this.flatFactors = flat;
        this.flat = 1 - distr;
        this.passed = false;
        this.done = false;
        this.size = hitFac.length;
        int dangerIndex = this.mid = (this.size - 1) / 2;
        int i = 1;
        while (i < this.size - 1) {
            if (this.danger(i) > this.danger(dangerIndex)) {
                dangerIndex = i;
            }
            ++i;
        }
        this.dangerBearing = (double)(dangerIndex - this.mid) * this.bearingDirection + this.absBearing;
    }

    public Wave(Point p, double angle, double vel, double dir, long time, double[] hitFac) {
        this.gunLocation = new Point(p.x, p.y);
        this.absBearing = angle;
        this.bulletVelocity = vel;
        this.bearingDirection = dir;
        this.shotTime = time;
        this.hitFactors = hitFac;
    }
}

