/*
 * Decompiled with CFR 0.152.
 */
package uji;

import java.awt.Color;
import robocode.AdvancedRobot;
import robocode.HitRobotEvent;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;
import robocode.WinEvent;

public class YellohFellah
extends AdvancedRobot {
    String[] names = new String[0];
    double[] distance = new double[0];
    double[] bearing = new double[0];
    double[] dirOnScan = new double[0];
    double lastDir = 1.0;
    int shortest = 0;
    boolean hasFound = false;
    boolean turn = false;
    double width;
    double height;

    public void run() {
        this.width = this.getBattleFieldWidth();
        this.height = this.getBattleFieldHeight();
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForRobotTurn(true);
        this.setColors(new Color(120, 24, 74), new Color(227, 11, 92), new Color(212, 175, 55));
        while (true) {
            this.setTurnRadarRight(360.0);
            if (this.hasFound) {
                if (this.getX() < 75.0 || this.getY() < 75.0 || this.getX() > this.width - 75.0 || this.getY() > this.height - 75.0) {
                    this.setMaxVelocity(4.0);
                    this.setTurnLeft(180.0 * this.lastDir);
                    this.out.println("inside");
                } else {
                    this.out.println("outside");
                    this.setTurnLeft(this.bearing[this.shortest]);
                    this.lastDir = this.bearing[this.shortest] > 0.0 ? -1.0 : 1.0;
                    this.setMaxVelocity(8.0);
                }
                this.setAhead(100.0);
                double gunBearing = this.getGunHeading() - this.dirOnScan[this.shortest];
                this.setTurnGunRight(this.bearing[this.shortest] - gunBearing);
                if (this.getGunHeat() <= 0.0 && gunBearing - this.bearing[this.shortest] <= 1.0 && gunBearing - this.bearing[this.shortest] >= -1.0) {
                    this.fire(400.0 / this.distance[this.shortest]);
                }
            }
            this.doNothing();
        }
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        this.hasFound = true;
        if (this.isFound(e)) {
            int i = 0;
            while (i < this.names.length) {
                if (this.names[i].equals(e.getName())) {
                    this.distance[i] = e.getDistance();
                    this.bearing[i] = e.getBearing();
                    this.dirOnScan[i] = this.getHeading();
                    break;
                }
                ++i;
            }
        }
        this.shortest = this.findShortest();
    }

    public void onHitRobot(HitRobotEvent e) {
        if (this.turn) {
            this.setTurnLeft(90.0);
        } else {
            this.setTurnRight(90.0);
        }
        this.turn = !this.turn;
        this.setMaxVelocity(8.0);
        this.back(50.0);
    }

    public void onRobotDeath(RobotDeathEvent e) {
        this.names = new String[0];
        this.distance = new double[0];
        this.bearing = new double[0];
        this.dirOnScan = new double[0];
        this.hasFound = false;
        this.shortest = 0;
        this.turnRadarRight(360.0);
    }

    boolean isFound(ScannedRobotEvent e) {
        int i = 0;
        while (i < this.names.length) {
            if (this.names[i].equals(e.getName())) {
                return true;
            }
            ++i;
        }
        String[] temp = this.names;
        double[] tempDist = this.distance;
        double[] tempBear = this.bearing;
        double[] tempDirOnScan = this.dirOnScan;
        this.names = new String[this.names.length + 1];
        this.distance = new double[this.distance.length + 1];
        this.bearing = new double[this.bearing.length + 1];
        this.dirOnScan = new double[this.dirOnScan.length + 1];
        int i2 = 0;
        while (i2 < temp.length) {
            this.names[i2] = temp[i2];
            this.distance[i2] = tempDist[i2];
            this.bearing[i2] = tempBear[i2];
            this.dirOnScan[i2] = tempDirOnScan[i2];
            ++i2;
        }
        this.names[this.names.length - 1] = e.getName();
        this.distance[this.distance.length - 1] = e.getDistance();
        this.bearing[this.bearing.length - 1] = e.getBearing();
        this.dirOnScan[this.dirOnScan.length - 1] = this.getHeading();
        return false;
    }

    int findShortest() {
        int shortestIndex = 0;
        double lowest = this.distance[0];
        int i = 0;
        while (i < this.distance.length) {
            if (this.distance[i] < lowest) {
                shortestIndex = i;
                lowest = this.distance[i];
            }
            ++i;
        }
        return shortestIndex;
    }

    public void onWin(WinEvent e) {
        this.setTurnGunRight(0.0);
        this.setTurnRight(0.0);
        this.setTurnRadarRight(0.0);
        this.ahead(10.0);
        this.back(10.0);
        this.ahead(10.0);
        this.back(10.0);
        this.ahead(10.0);
        this.back(10.0);
        this.ahead(10.0);
        this.back(10.0);
    }
}

