/*
 * Decompiled with CFR 0.152.
 */
package de.simpleworks.robocode.botUtil;

import de.simpleworks.robocode.botUtil.Coordinate;
import de.simpleworks.robocode.botUtil.CsCalc;
import de.simpleworks.robocode.botUtil.Targeter;
import robocode.ScannedRobotEvent;

public class PredictiveLinearTargeter
extends Targeter {
    private double getAngleToTarget(double _targetBearing, double bHeading) {
        double res = bHeading + _targetBearing;
        if (res < 0.0) {
            res += 360.0;
        }
        if (res >= 360.0) {
            res -= 360.0;
        }
        return res;
    }

    private Coordinate getTargetPosition(ScannedRobotEvent _sre, Coordinate _startPoint, double _bHeading) {
        double targetheading = this.getAngleToTarget(_sre.getBearing(), _bHeading);
        return CsCalc.calcEndPoint(_startPoint, _sre.getDistance(), targetheading);
    }

    @Override
    public void calculate(ScannedRobotEvent _sre, double xb, double yb, double bPower, double bHeading, double angularVelocity_deg_per_sec) {
        this.bulletStartingPoint.set(xb, yb);
        this.targetStartingPoint = this.getTargetPosition(_sre, this.bulletStartingPoint, bHeading);
        this.targetHeading = _sre.getHeading();
        this.targetVelocity = _sre.getVelocity();
        this.bulletPower = bPower;
        this.impactTime = this.getImpactTime(10.0, 20.0, 0.01);
        this.impactPoint = this.getEstimatedPosition(this.impactTime);
        double dX = this.impactPoint.x() - this.bulletStartingPoint.x();
        double dY = this.impactPoint.y() - this.bulletStartingPoint.y();
        this.distance = Math.sqrt(dX * dX + dY * dY);
        this.bulletHeading_deg = Math.toDegrees(Math.atan2(dX, dY));
    }

    public boolean canHit(double bfHeight, double bfWid) {
        return this.impactPoint.x() > 0.0 && this.impactPoint.x() < bfWid && this.impactPoint.y() > 0.0 && this.impactPoint.y() < bfHeight;
    }
}

