/*
 * Decompiled with CFR 0.152.
 */
package pulsar.gf;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import pulsar.PulsarMax;
import pulsar.util.DynMultiDimArray;
import pulsar.util.Util;
import pulsar.util.Wave;

public class GFUtil {
    private static final float HIT_VALUE = 100.0f;
    private static final float MISS_VALUE = 0.0f;
    private static Map guessFactors = new HashMap();
    private static Map hitsOrVisits = new HashMap();

    public static int[] getHitsOrVisits(String target, String key) {
        int[] val = (int[])hitsOrVisits.get(target + "|" + key);
        if (val == null) {
            val = new int[1];
            hitsOrVisits.put(target + "|" + key, val);
        }
        return val;
    }

    public static int getGuessFactorIndex(double guessFactor, int nFactors) {
        return (int)Math.round(guessFactor * (double)(nFactors - 1) / 2.0 + (double)(nFactors - 1) / 2.0);
    }

    public static double getGuessFactor(int index, int nFactors) {
        double middleGuess = ((double)nFactors - 1.0) / (double)2;
        return ((double)index - middleGuess) / middleGuess;
    }

    private static List getHitFactors(String target, String subid, int[] segmentation, int factors) {
        List currentGuessFactors = (List)guessFactors.get(target + "|" + subid);
        if (currentGuessFactors == null) {
            currentGuessFactors = GFUtil.createFactorsForSegmentation(new ArrayList(segmentation[0]), 0, segmentation, factors);
            guessFactors.put(target + "|" + subid, currentGuessFactors);
        }
        return currentGuessFactors;
    }

    private static float[] getFactorsForGFIndexes(List list, int[] gfIndexes) {
        int i = 0;
        while (i < gfIndexes.length - 1) {
            Object o = list.get(gfIndexes[i]);
            if (!(o instanceof List)) break;
            list = (List)o;
            ++i;
        }
        return (float[])list.get(gfIndexes[gfIndexes.length - 1]);
    }

    private static List createFactorsForSegmentation(List list, int index, int[] segmentation, int factors) {
        if (index == segmentation.length - 1) {
            int i = 0;
            while (i < segmentation[index]) {
                list.add(new float[factors]);
                ++i;
            }
        } else {
            int i = 0;
            while (i < segmentation[index]) {
                ArrayList list2 = new ArrayList(segmentation[index + 1]);
                list.add(list2);
                GFUtil.createFactorsForSegmentation(list2, index + 1, segmentation, factors);
                ++i;
            }
        }
        return list;
    }

    private static List getVisitFactors(String target, String subid, int[] segmentation, int factors) {
        return GFUtil.getHitFactors(target, subid + "_visits", segmentation, factors);
    }

    public static void initHOA(String target, String strategyName, int[] segmentation, int factors) {
        int[] n = GFUtil.getHitsOrVisits(target, strategyName + DynMultiDimArray.arrayToString(new int[]{0}));
        if (n[0] == 0) {
            ((float[])GFUtil.getHitFactors((String)target, (String)strategyName, (int[])segmentation, (int)factors).get((int)0))[factors / 2] = 10.0f;
            n[0] = n[0] + 1;
        }
    }

    public static int[] getGuessFactorIndex(Wave wave, double x, double y, boolean useRobotSize, int nFactors) {
        return GFUtil.getGuessFactorIndex(wave.origin, wave.locAtFireTime, wave.startBearing, wave.firePower, wave.firedAtCircleDir, x, y, useRobotSize, nFactors);
    }

    public static int[] getGuessFactorIndex(Point2D.Double origin, Point2D.Double locAtFireTime, double startBearing, double firePower, double firedAtCircleDir, double x, double y, boolean useRobotSize, int nFactors) {
        double currentAbsBearing = Util.absbearing(origin.getX(), origin.getY(), x, y);
        double robotAbsbearingAtFireTime = startBearing;
        double distance = origin.distance(x, y);
        double angleOffset = firedAtCircleDir * Util.normalizeRelativeAngle(currentAbsBearing - robotAbsbearingAtFireTime);
        double angleOffset1 = firedAtCircleDir * Util.normalizeRelativeAngle(Math.atan((double)18 / distance) + currentAbsBearing - robotAbsbearingAtFireTime);
        double angleOffset2 = firedAtCircleDir * Util.normalizeRelativeAngle(-Math.atan((double)18 / distance) + currentAbsBearing - robotAbsbearingAtFireTime);
        double maxEsc = Util.maxEscapeAngle(firePower);
        double guessFactor1 = Math.max((double)-1, Math.min(1.0, angleOffset1 / maxEsc));
        double guessFactor2 = Math.max((double)-1, Math.min(1.0, angleOffset2 / maxEsc));
        double currentGuessFactor = angleOffset / maxEsc;
        if (!(currentGuessFactor <= 1.0) || currentGuessFactor < (double)-1) {
            if (!(currentGuessFactor <= 1.2) || currentGuessFactor < -1.2) {
                PulsarMax.println("Guess factor out of range: " + currentGuessFactor + " Time: " + PulsarMax.time + " Coord: " + x + ", " + y + " origin: " + origin.getX() + "," + origin.getY() + " firetimeLoc: " + locAtFireTime.getX() + "," + locAtFireTime.getY() + " myCircleDirection: " + firedAtCircleDir + " angleOffset: " + angleOffset + " maxEscapeAngle: " + Util.maxEscapeAngle(firePower));
                return null;
            }
            currentGuessFactor = Math.max((double)-1, Math.min(1.0, currentGuessFactor));
        }
        int[] currentGuessFactorIndex = null;
        if (useRobotSize) {
            int index1 = Math.min(GFUtil.getGuessFactorIndex(guessFactor1, nFactors), GFUtil.getGuessFactorIndex(guessFactor2, nFactors));
            int index2 = Math.max(GFUtil.getGuessFactorIndex(guessFactor1, nFactors), GFUtil.getGuessFactorIndex(guessFactor2, nFactors));
            currentGuessFactorIndex = new int[index2 - index1 + 1];
            int i = 0;
            while (i < currentGuessFactorIndex.length) {
                currentGuessFactorIndex[i] = index1 + i;
                ++i;
            }
        } else {
            currentGuessFactorIndex = new int[]{GFUtil.getGuessFactorIndex(currentGuessFactor, nFactors)};
        }
        return currentGuessFactorIndex;
    }

    public static int updateWaveHit(String strategyName, int[] segmentation, String targetName, double x, double y, Wave wave, boolean botSize, int nFactors, int samples, double nonVirtualWeight, double pow) {
        int[] currFactors = GFUtil.getGuessFactorIndex(wave, x, y, botSize, nFactors);
        if (currFactors == null) {
            return -1;
        }
        int lastHitGFIndex = currFactors[currFactors.length / 2];
        List guessFactorArray = GFUtil.getHitFactors(targetName, strategyName, segmentation, nFactors);
        int[] gfIndex = (int[])wave.gfIndexes.get(strategyName);
        if (nonVirtualWeight >= 0.0) {
            String nName = strategyName + DynMultiDimArray.arrayToString(gfIndex);
            int[] nArray = GFUtil.getHitsOrVisits(targetName, nName);
            nArray[0] = nArray[0] + 1;
        }
        GFUtil.updateWave(gfIndex, wave, currFactors, guessFactorArray, samples, nFactors, nonVirtualWeight, pow);
        return lastHitGFIndex;
    }

    public static void updateWaveVisit(String strategyName, int[] segmentation, String targetName, double x, double y, Wave wave, boolean botSize, int nFactors, int samples, double nonVirtualWeight, double pow) {
        int[] currFactors;
        if (samples < 0) {
            return;
        }
        int[] gfIndex = (int[])wave.gfIndexes.get(strategyName);
        if (nonVirtualWeight >= 0.0) {
            String nName = strategyName + DynMultiDimArray.arrayToString(gfIndex);
            int[] nArray = GFUtil.getHitsOrVisits(targetName, nName + "_visits");
            nArray[0] = nArray[0] + 1;
        }
        if ((currFactors = GFUtil.getGuessFactorIndex(wave, x, y, botSize, nFactors)) == null) {
            return;
        }
        List guessFactorArray = GFUtil.getVisitFactors(targetName, strategyName, segmentation, nFactors);
        GFUtil.updateWave(gfIndex, wave, currFactors, guessFactorArray, samples, nFactors, nonVirtualWeight, botSize ? pow : Double.POSITIVE_INFINITY);
    }

    public static void updateWave(int[] gfIndex, Wave wave, int[] currFactors, List guessFactorArray, int samples, int nFactors, double nonVirtualWeight, double pow) {
        int middleVal = currFactors[currFactors.length / 2];
        double weight = wave.virtual ? (double)(nonVirtualWeight >= 0.0 ? 1 : -1) : nonVirtualWeight;
        float[] factors = GFUtil.getFactorsForGFIndexes(guessFactorArray, gfIndex);
        if (samples == 0) {
            if (pow == Double.POSITIVE_INFINITY) {
                int n = middleVal;
                factors[n] = (float)((double)factors[n] + weight);
            } else {
                int z = 0;
                while (z < currFactors.length) {
                    double f = Util.getDeclineFactor(middleVal, currFactors[z], pow);
                    int n = currFactors[z];
                    factors[n] = (float)((double)factors[n] + f * weight);
                    ++z;
                }
            }
        } else {
            if (pow == Double.POSITIVE_INFINITY) {
                pow = 10;
            }
            int z = 0;
            while (z < nFactors) {
                if (z >= currFactors[0] && z <= currFactors[currFactors.length - 1]) {
                    double f = Util.getDeclineFactor(middleVal, z, pow);
                    factors[z] = (float)Util.getRollingAverage(factors[z], f * (double)100.0f, samples, weight);
                } else {
                    factors[z] = (float)Util.getRollingAverage(factors[z], 0.0f, samples, weight);
                }
                ++z;
            }
        }
    }

    public static float[] getGuessFactorValue(String strategyName, int[] currFactors, boolean botSize, int lastHitGFIndex, String target, int[] gfIndex, int index, double pow, double hitWeight, double visitWeight, int[] seg, int nFactors, boolean rolling) {
        List hitFactors = null;
        int nHits = -1;
        if (hitWeight > 0.0) {
            hitFactors = GFUtil.getHitFactors(target, strategyName, seg, nFactors);
            nHits = GFUtil.getHitsOrVisits(target, strategyName + DynMultiDimArray.arrayToString(gfIndex))[0];
        }
        List visitFactors = null;
        int nVisits = -1;
        if (visitWeight > 0.0) {
            visitFactors = GFUtil.getVisitFactors(target, strategyName, seg, nFactors);
            nVisits = GFUtil.getHitsOrVisits(target, strategyName + DynMultiDimArray.arrayToString(gfIndex) + "_visits")[0];
        }
        return GFUtil.getGuessFactorValue(lastHitGFIndex, currFactors, botSize, hitFactors, visitFactors, gfIndex, index, pow, hitWeight, visitWeight, nHits, nVisits, nFactors, rolling);
    }

    private static float[] getGuessFactorValue(int lastHitGFIndex, int[] currFactors, boolean botSize, List guessFactors, List visitFactors, int[] gfIndex, int index, double pow, double hitWeight, double visitWeight, int nHits, int nVisits, int nFactors, boolean rolling) {
        double factorVisitsO;
        double factorHitsO;
        float[] result = new float[nFactors];
        float[] factors = null;
        if (guessFactors != null) {
            factors = GFUtil.getFactorsForGFIndexes(guessFactors, gfIndex);
        }
        float[] visitfactors = null;
        if (visitFactors != null) {
            visitfactors = GFUtil.getFactorsForGFIndexes(visitFactors, gfIndex);
        }
        if (rolling) {
            factorHitsO = nHits > 0 ? 1 : 0;
            factorVisitsO = nVisits > 0 ? 1 : 0;
        } else {
            factorHitsO = nHits > 0 ? 1.0 / (double)nHits : 0.0;
            factorVisitsO = nVisits > 0 ? 1.0 / (double)nVisits : 0.0;
        }
        double factorHits = factorHitsO;
        double factorVisits = factorVisitsO;
        if (nHits <= 0 && nVisits <= 0) {
            return result;
        }
        int startVal = index >= 0 ? index : 0;
        int endVal = index >= 0 ? index + 1 : nFactors;
        int j = startVal;
        while (j < endVal) {
            int i = 0;
            while (i < nFactors) {
                block11: {
                    block10: {
                        block9: {
                            if (pow != Double.POSITIVE_INFINITY) break block9;
                            if (i == j) break block10;
                            break block11;
                        }
                        double f = Math.abs(i - j) <= currFactors.length / 2 && botSize ? Util.getDeclineFactor(j, i, pow / (double)2) : Util.getDeclineFactor(j, i, pow);
                        factorHits = factorHitsO * f;
                        factorVisits = factorVisitsO * f;
                    }
                    if (factors != null) {
                        int n = j;
                        result[n] = (float)((double)result[n] + hitWeight * (double)factors[i] * factorHits);
                    }
                    if (visitfactors != null) {
                        int n = j;
                        result[n] = (float)((double)result[n] + visitWeight * (double)visitfactors[i] * factorVisits);
                    }
                }
                ++i;
            }
            ++j;
        }
        return result;
    }
}

