/*
 * Decompiled with CFR 0.152.
 */
package Krabb.sliNk;

import Krabb.sliNk.DataHandling;
import Krabb.sliNk.MyBullet;
import Krabb.sliNk.MyDAArray;
import Krabb.sliNk.MyIAArray;
import Krabb.sliNk.SegmentationValues;
import Krabb.sliNk.StaticMovementStatistics;
import Krabb.sliNk.Stats;

class KomariousMovementStatistics
extends StaticMovementStatistics {
    KomariousMovementStatistics(int gf_type, double dept) {
        this.gf_type = gf_type;
        this.dept = dept;
        this.bins_number = 151;
        this.segments_number = 4;
        int[] dimension = new int[]{5, 3, 4, 3};
        this.stats = new MyDAArray(dimension, this.bins_number);
        this.hits = new MyIAArray(dimension, 1);
        this.rating = new MyDAArray(dimension, 1);
        this.weight_real = 4.0;
        this.weight_virtual = 0.5;
    }

    protected int[] getSegmentationValues(MyBullet bullet, int enemy) {
        SegmentationValues segval = bullet.segmentationvalues[enemy];
        Stats stats_source = bullet.source_stats_segmentation;
        Stats stats_object = bullet.victim_stats_segmentation[enemy];
        int[] segmentations = new int[this.segments_number];
        double delta_change_time = segval.getLastVelocityChange_V();
        double acceleration = segval.getAcceleration_V();
        if (delta_change_time == 0.0) {
            segmentations[0] = 0;
            if (acceleration > 0.0) {
                segmentations[0] = 1;
            }
        } else {
            segmentations[0] = delta_change_time < 5.0 ? 2 : 3;
        }
        double velocity_lateral = Math.abs(segval.getLateralVelocity_V());
        segmentations[1] = 2;
        if (velocity_lateral < 1.0) {
            segmentations[1] = 0;
        } else if (velocity_lateral < 5.0) {
            segmentations[1] = 1;
        }
        double distance = segval.getDistance();
        int bin_walldistance = DataHandling.collidesWallAtDistance(stats_source.location, DataHandling.absoluteAngle(stats_source.location, stats_object.location), stats_object.velocity, distance, 0.20358498553, stats_object.heading) ? (DataHandling.collidesWallAtDistance(stats_source.location, DataHandling.absoluteAngle(stats_source.location, stats_object.location), stats_object.velocity, distance, 0.40716997107, stats_object.heading) ? (DataHandling.collidesWallAtDistance(stats_source.location, DataHandling.absoluteAngle(stats_source.location, stats_object.location), stats_object.velocity, distance, 0.61075495659, stats_object.heading) ? 3 : 2) : 1) : 0;
        segmentations[2] = Math.max(0, Math.min(bin_walldistance, 3));
        segmentations[3] = 2;
        if (distance < 150.0) {
            segmentations[3] = 0;
        } else if (distance < 400.0) {
            segmentations[3] = 1;
        }
        return segmentations;
    }
}

