/*
 * Decompiled with CFR 0.152.
 */
package areb;

import java.io.PrintStream;
import java.util.Arrays;

public class WaveStats {
    public static final int E_VELS = 4;
    public static final int E_DISTS = 4;
    public static final int E_ACCELS = 3;
    public static final int B_POWERS = 3;
    public static final int FW_DISTS = 4;
    public static final int BW_DISTS = 4;
    public static final double[] distance = new double[]{225.0, 400.0, 575.0, 10000.0};
    public static final double[] velocity = new double[]{2.0, 4.0, 6.0, 8.0};
    public static final int[] accel = new int[]{1, 0, -1};
    public static final double[] bulletPower = new double[]{1.0, 2.0, 3.0};
    public static final double[] wallDistance = new double[]{100.0, 200.0, 300.0, 10000.0};
    private static double battleFieldX;
    private static double battleFieldY;
    private static int BIN_COUNT;
    private static double BIN_START;
    private static double BIN_END;
    private static double binInc;
    private static int LAST_N;
    private static int[][] s2Count;
    private static int[][][] s3Count;
    private static int[][][][] s4Count;
    private static int[][][][][] s5Count;
    private static int[][][][][][] s6Count;
    private static int[] s1Bin;
    private static int[][][] s2Bin;
    private static int[][][][] s3Bin;
    private static int[][][][][] s4Bin;
    private static int[][][][][][] s5Bin;
    private static int[][][][][][][] s6Bin;
    private static int totalCount;
    private static int hitCount;
    private static int missCount;
    private static int streak;
    private boolean LOGGING;
    public static PrintStream out;

    public WaveStats(double d, double d2, boolean bl) {
        battleFieldX = d;
        battleFieldY = d2;
        this.LOGGING = bl;
        binInc = (BIN_END - BIN_START) / ((double)BIN_COUNT - 2.0);
    }

    public void addWave(int n, int n2, int n3, int n4, int n5, int n6, double d) {
        Wave wave = new Wave(d);
        if (this.LOGGING) {
            out.println((int)distance[n] + "," + (int)velocity[n2] + "," + accel[n3] + "," + (int)bulletPower[n4] + "," + d + "," + hitCount + "," + missCount);
        }
        int n7 = -1;
        if (d < BIN_START) {
            n7 = 0;
        } else if (d > BIN_END) {
            n7 = BIN_COUNT - 1;
        } else {
            for (int i = 1; i < BIN_COUNT - 1; ++i) {
                double d2 = BIN_START + binInc * (double)i;
                if (!(d < d2)) continue;
                n7 = i;
                break;
            }
        }
        ++totalCount;
        int n8 = n7;
        s1Bin[n8] = s1Bin[n8] + 1;
        int[] nArray = s2Count[n2];
        int n9 = n3;
        nArray[n9] = nArray[n9] + 1;
        int[] nArray2 = s2Bin[n2][n3];
        int n10 = n7;
        nArray2[n10] = nArray2[n10] + 1;
        int[] nArray3 = s3Count[n][n2];
        int n11 = n3;
        nArray3[n11] = nArray3[n11] + 1;
        int[] nArray4 = s3Bin[n][n2][n3];
        int n12 = n7;
        nArray4[n12] = nArray4[n12] + 1;
        int[] nArray5 = s4Count[n][n2][n3];
        int n13 = n5;
        nArray5[n13] = nArray5[n13] + 1;
        int[] nArray6 = s4Bin[n][n2][n3][n5];
        int n14 = n7;
        nArray6[n14] = nArray6[n14] + 1;
        int[] nArray7 = s5Count[n][n2][n3][n4];
        int n15 = n5;
        nArray7[n15] = nArray7[n15] + 1;
        int[] nArray8 = s5Bin[n][n2][n3][n4][n5];
        int n16 = n7;
        nArray8[n16] = nArray8[n16] + 1;
        int[] nArray9 = s6Count[n][n2][n3][n4][n5];
        int n17 = n6;
        nArray9[n17] = nArray9[n17] + 1;
        int[] nArray10 = s6Bin[n][n2][n3][n4][n5][n6];
        int n18 = n7;
        nArray10[n18] = nArray10[n18] + 1;
    }

    private void countReport(int n, int n2, int n3, int n4, int n5, int n6) {
    }

    public void addHit() {
        ++hitCount;
        streak = streak > 0 ? ++streak : 1;
    }

    public void addMiss() {
        ++missCount;
        streak = streak < 0 ? --streak : -1;
    }

    public double[] getShotGuess(int n, int n2, int n3, int n4, int n5, int n6) {
        double[] dArray;
        if (totalCount < 1) {
            dArray = new double[]{0.0, 1.0, 0.5, -0.5};
        } else if (s6Count[n][n2][n3][n4][n5][n6] >= 2) {
            int[] nArray = this.getBinOrder(s6Bin[n][n2][n3][n4][n5][n6]);
            dArray = this.getAverageAngle(nArray);
        } else if (s5Count[n][n2][n3][n4][n5] >= 2) {
            int[] nArray = this.getBinOrder(s5Bin[n][n2][n3][n4][n5]);
            dArray = this.getAverageAngle(nArray);
        } else if (s4Count[n][n2][n3][n5] >= 2) {
            int[] nArray = this.getBinOrder(s4Bin[n][n2][n3][n5]);
            dArray = this.getAverageAngle(nArray);
        } else if (s3Count[n][n2][n3] >= 2) {
            int[] nArray = this.getBinOrder(s3Bin[n][n2][n3]);
            dArray = this.getAverageAngle(nArray);
        } else if (s2Count[n2][n3] >= 2) {
            int[] nArray = this.getBinOrder(s2Bin[n2][n3]);
            dArray = this.getAverageAngle(nArray);
        } else {
            int[] nArray = this.getBinOrder(s1Bin);
            dArray = this.getAverageAngle(nArray);
        }
        return dArray;
    }

    private int[] getBinOrder(int[] nArray) {
        int[] nArray2 = (int[])nArray.clone();
        int[] nArray3 = (int[])nArray.clone();
        int[] nArray4 = new int[nArray.length];
        Arrays.sort(nArray3);
        block0: for (int i = 0; i < nArray.length; ++i) {
            for (int j = 0; j < nArray.length; ++j) {
                if (nArray3[i] != nArray2[j]) continue;
                nArray4[i] = j;
                nArray2[j] = -1;
                continue block0;
            }
        }
        return nArray4;
    }

    private double[] getAverageAngle(int[] nArray) {
        double[] dArray = new double[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            dArray[nArray.length - 1 - i] = BIN_START - binInc + (double)nArray[i] * binInc + binInc * 0.5;
        }
        return dArray;
    }

    public int getEDist(double d) {
        for (int i = 0; i < 4; ++i) {
            if (!(d <= distance[i])) continue;
            return i;
        }
        return -1;
    }

    public int getEVel(double d) {
        for (int i = 0; i < 4; ++i) {
            if (!(d <= velocity[i])) continue;
            return i;
        }
        return -1;
    }

    public int getEAccel(double d, double d2) {
        int n = d > d2 ? 0 : (d == d2 ? 1 : 2);
        return n;
    }

    public int getBPower(double d) {
        if (d <= 1.0) {
            return 0;
        }
        if (d <= 2.0) {
            return 1;
        }
        return 2;
    }

    public int getFwDist(double d) {
        return this.getWDist(d);
    }

    public int getBwDist(double d) {
        return this.getWDist(d);
    }

    public int getWDist(double d) {
        for (int i = 0; i < 4; ++i) {
            if (!(d < wallDistance[i])) continue;
            return i;
        }
        return -1;
    }

    static {
        BIN_COUNT = 13;
        BIN_START = -1.0;
        BIN_END = 1.2;
        LAST_N = 10;
        s2Count = new int[4][3];
        s3Count = new int[4][4][3];
        s4Count = new int[4][4][3][4];
        s5Count = new int[4][4][3][3][4];
        s6Count = new int[4][4][3][3][4][4];
        s1Bin = new int[BIN_COUNT];
        s2Bin = new int[4][3][BIN_COUNT];
        s3Bin = new int[4][4][3][BIN_COUNT];
        s4Bin = new int[4][4][3][4][BIN_COUNT];
        s5Bin = new int[4][4][3][3][4][BIN_COUNT];
        s6Bin = new int[4][4][3][3][4][4][BIN_COUNT];
    }

    class Wave {
        private double angle;

        Wave(double d) {
            this.angle = d;
        }

        public double getAngle() {
            return this.angle;
        }
    }
}

