/*
 * Decompiled with CFR 0.152.
 */
package ds.movement;

import ds.Math2;
import ds.movement.MovingAntiGravityObject;
import ds.movement.Vector2D;
import ds.targeting.IVirtualBot;
import java.awt.geom.Point2D;
import robocode.util.Utils;

public class MovingPerpendicularAntiGravityObject
extends MovingAntiGravityObject {
    private IVirtualBot m_originBot;

    public MovingPerpendicularAntiGravityObject(IVirtualBot originBot, double weight, double gravityType) {
        super(weight, gravityType);
        this.m_originBot = originBot;
    }

    @Override
    public Vector2D getForceVector(Point2D.Double referent) {
        double distance = referent.distance(this.getPosition());
        double angle = this.m_movingObject.getHeadingRadians();
        angle = Utils.normalRelativeAngle((double)angle);
        Vector2D vectRef = new Vector2D(referent.getX() - this.getPosition().getX(), referent.getY() - this.getPosition().getY());
        double angleRef = vectRef.getTheta();
        angleRef = Math2.getAbsoluteTargetBearing(referent, new Point2D.Double(this.getPosition().getX(), this.getPosition().getY()));
        double angleDiff = Utils.normalRelativeAngle((double)(angle - angleRef));
        angle = angleDiff > 0.0 ? (angle += 1.5707963267948966) : (angle -= 1.5707963267948966);
        float X = (float)Math.sin(angle);
        float Y = (float)Math.cos(angle);
        Vector2D vect = new Vector2D(X, Y);
        vect.multiply(100.0);
        double pow = Math.pow(distance, this.m_gravityType);
        vect.multiply(this.getWeight() / pow);
        if (this.getStartPosition().distance(this.getPosition()) > this.getStartPosition().distance(referent) + 15.0) {
            vect.divide(10.0);
        }
        return vect;
    }

    public double absbearing(Point2D pt1, Point2D pt2) {
        double xo = pt2.getX() - pt1.getX();
        double yo = pt2.getY() - pt1.getY();
        double h = pt1.distance(pt2);
        if (xo > 0.0 && yo > 0.0) {
            return Math.asin(xo / h);
        }
        if (xo > 0.0 && yo < 0.0) {
            return Math.PI - Math.asin(xo / h);
        }
        if (xo < 0.0 && yo < 0.0) {
            return Math.PI + Math.asin(-xo / h);
        }
        if (xo < 0.0 && yo > 0.0) {
            return Math.PI * 2 - Math.asin(-xo / h);
        }
        return 0.0;
    }
}

