/*
 * Decompiled with CFR 0.152.
 */
package xander.core.track;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import xander.core.drive.Direction;
import xander.core.drive.OrbitalDrivePredictor;
import xander.core.math.RCMath;
import xander.core.math.RCPhysics;
import xander.core.track.BulletShadow;
import xander.core.track.Snapshot;
import xander.core.track.WaveState;

public class Wave {
    private Point2D.Double origin;
    private long originTime;
    private double originDistance;
    private double bulletPower;
    private double bulletVelocity;
    private double initialDefenderBearing;
    private Direction surfDirection;
    private Snapshot initialAttackerSnapshot;
    private Snapshot initialDefenderSnapshot;
    WaveState state = WaveState.LEADING;
    private List<BulletShadow> bulletShadows = new ArrayList<BulletShadow>();

    public Wave(Point2D.Double origin, long originTime, double originDistance, double bulletPower, double initialDefenderBearing, Direction surfDirection) {
        this.origin = origin;
        this.originTime = originTime;
        this.originDistance = originDistance;
        this.bulletPower = bulletPower;
        this.bulletVelocity = RCPhysics.getBulletVelocity(bulletPower);
        this.initialDefenderBearing = initialDefenderBearing;
        this.surfDirection = surfDirection;
    }

    public Wave(Snapshot defenderSnapshot, Snapshot attackerSnapshot, double bulletPower, long bulletFiredTime) {
        this.initialAttackerSnapshot = attackerSnapshot;
        this.initialDefenderSnapshot = defenderSnapshot;
        this.origin = new Point2D.Double(attackerSnapshot.getX(), attackerSnapshot.getY());
        this.originTime = bulletFiredTime;
        this.originDistance = RCMath.getDistanceBetweenPoints(attackerSnapshot.getLocation(), defenderSnapshot.getLocation());
        this.bulletPower = bulletPower;
        this.bulletVelocity = RCPhysics.getBulletVelocity(bulletPower);
        this.initialDefenderBearing = RCMath.getRobocodeAngle(attackerSnapshot.getX(), attackerSnapshot.getY(), defenderSnapshot.getX(), defenderSnapshot.getY());
        this.surfDirection = OrbitalDrivePredictor.getOribitalDirection(attackerSnapshot.getX(), attackerSnapshot.getY(), defenderSnapshot.getX(), defenderSnapshot.getY(), defenderSnapshot.getVelocity(), defenderSnapshot.getHeadingRoboDegrees());
    }

    public Snapshot getInitialAttackerSnapshot() {
        return this.initialAttackerSnapshot;
    }

    public Snapshot getInitialDefenderSnapshot() {
        return this.initialDefenderSnapshot;
    }

    public void addBulletShadow(BulletShadow bulletShadow) {
        this.bulletShadows.add(bulletShadow);
    }

    public List<BulletShadow> getBulletShadows() {
        return this.bulletShadows;
    }

    public Point2D.Double getOrigin() {
        return this.origin;
    }

    public double getOriginX() {
        return this.origin.x;
    }

    public double getOriginY() {
        return this.origin.y;
    }

    public long getOriginTime() {
        return this.originTime;
    }

    public WaveState getState() {
        return this.state;
    }

    public boolean isLeading() {
        return this.state == WaveState.LEADING;
    }

    public boolean isPassed() {
        return this.state == WaveState.PASSED;
    }

    public double getOriginDistance() {
        return this.originDistance;
    }

    public double getBulletPower() {
        return this.bulletPower;
    }

    public double getBulletVelocity() {
        return this.bulletVelocity;
    }

    public double getInitialDefenderBearing() {
        return this.initialDefenderBearing;
    }

    public Direction getSurfDirection() {
        return this.surfDirection;
    }

    public long getTimeUntilMatched(double x, double y, long currentTime) {
        double distanceBetween = RCMath.getDistanceBetweenPoints(this.origin.x, this.origin.y, x, y);
        double distanceTravelled = (double)(currentTime - this.originTime) * this.bulletVelocity;
        return Math.round((distanceBetween - distanceTravelled) / this.bulletVelocity);
    }

    public long getTimeUntilHit(double x, double y, long currentTime) {
        double distanceBetween = RCMath.getDistanceBetweenPoints(this.origin.x, this.origin.y, x, y);
        double distanceTravelled = (double)(currentTime - this.originTime) * this.bulletVelocity;
        return Math.round(((distanceBetween -= 20.0) - distanceTravelled) / this.bulletVelocity);
    }

    public long getTimeUntilPassed(double x, double y, long currentTime) {
        double distanceBetween = RCMath.getDistanceBetweenPoints(this.origin.x, this.origin.y, x, y);
        double distanceTravelled = (double)(currentTime - this.originTime) * this.bulletVelocity;
        return Math.round(((distanceBetween += 20.0) - distanceTravelled) / this.bulletVelocity);
    }

    public double getBulletTravelDistance(long time) {
        return (double)(time - this.originTime) * this.bulletVelocity;
    }
}

