/*
 * Decompiled with CFR 0.152.
 */
package xander.gfws.segment;

import java.awt.geom.Rectangle2D;
import xander.core.log.Logger;
import xander.core.math.RCPhysics;
import xander.core.track.Wave;
import xander.gfws.segment.AbstractSegmenter;

public class BulletTravelTimeSegmenter
extends AbstractSegmenter {
    public BulletTravelTimeSegmenter(int numSegments, Rectangle2D.Double battlefieldBounds) {
        super(numSegments, 1.0, Math.sqrt(battlefieldBounds.getWidth() * battlefieldBounds.getWidth() + battlefieldBounds.getHeight() * battlefieldBounds.getHeight()) / RCPhysics.MIN_BULLET_VELOCITY);
    }

    @Override
    public String getName() {
        return "Bullet Travel Time Segmenter";
    }

    @Override
    public double getSegmentValue(Wave wave) {
        double distance = Math.max(wave.getInitialAttackerSnapshot().getDistance(), wave.getInitialDefenderSnapshot().getDistance());
        return distance / wave.getBulletVelocity();
    }

    @Override
    protected String getDescriptionForRange(int segmentIndex, double rangeStart, double rangeStop) {
        return "Bullet Travel Time " + Logger.format(rangeStart, 0) + " to " + Logger.format(rangeStop, 0);
    }
}

