/*
 * Decompiled with CFR 0.152.
 */
package fnc.bandit2002;

import fnc.bandit2002.Attractor;
import fnc.bandit2002.Force;
import fnc.bandit2002.ForceField;
import fnc.bandit2002.Position;
import fnc.bandit2002.Util;
import java.awt.Color;
import robocode.AdvancedRobot;
import robocode.BulletHitEvent;
import robocode.BulletMissedEvent;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;
import robocode.WinEvent;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Bandit2002
extends AdvancedRobot {
    ForceField thefield;
    long scantime;
    double power;
    Position position;
    Attractor target;
    Attractor scantarget;
    boolean forwards;
    boolean talkative;
    boolean frozen;
    final int MaxNumberOfRobots = 60;
    int[] number_of_shots_missed;
    int[] number_of_shots_hit;
    long start_round_time;

    public void run() {
        this.talkative = true;
        this.frozen = false;
        this.start_round_time = 0L;
        this.number_of_shots_missed = new int[60];
        this.number_of_shots_hit = new int[60];
        this.position = new Position(this.getX(), this.getY());
        this.thefield = new ForceField(this.out, this.getBattleFieldWidth(), this.getBattleFieldHeight());
        this.setColors(Color.white, Color.white, Color.white);
        this.turnRadarLeft(360.0);
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        this.thefield.countZero();
        while (true) {
            this.precision_scan();
            this.execute();
            this.selectTarget();
            if (this.target != null) {
                this.target.dump(this.out);
            }
            while (this.getGunHeat() > 0.0) {
                this.thefield.countZero();
                this.precision_scan();
                if (this.target != null) {
                    this.target.analyse();
                }
                this.aim();
                this.move();
                this.execute();
            }
            int wd = 10;
            while (this.target != null && !this.aim() && wd > 0) {
                this.precision_scan();
                this.move();
                this.execute();
                if (this.target != null) {
                    this.target.analyse();
                }
                --wd;
            }
            if (wd == 0) {
                this.out.println("aim takes too long");
            }
            if (this.target == null) continue;
            this.target.firedOn();
            this.fire(this.power);
        }
    }

    public void statistics(int i) {
        if (this.number_of_shots_hit != null && this.number_of_shots_missed != null && i > 0 && i < 60) {
            int fired = this.number_of_shots_hit[i] + this.number_of_shots_missed[i];
            if (fired > 0) {
                this.out.print("[" + i + "] HitRatio: ");
                double ratio = (double)this.number_of_shots_hit[i] / (double)fired;
                this.out.print(Util.round(ratio));
                if (this.getTime() - this.start_round_time > 0L) {
                    this.out.println("   Rate: " + Util.round((double)fired / (double)(this.getTime() - this.start_round_time)));
                } else {
                    this.out.println("");
                }
                this.start_round_time = this.getTime();
            } else {
                this.out.println("[" + i + "] No shots fired");
                this.start_round_time = this.getTime();
            }
        }
    }

    public void turnRadarTo(Position arg_p, double arg_delta) {
        double heading = this.getRadarHeadingRadians();
        this.position.x = this.getX();
        this.position.y = this.getY();
        double wanted_heading = this.position.bearing(arg_p);
        double offset = Util.offset(heading, wanted_heading);
        offset = offset < 0.0 ? (offset -= arg_delta) : (offset += arg_delta);
        this.setTurnRadarRightRadians(offset);
    }

    public void precision_scan() {
        this.position.x = this.getX();
        this.position.y = this.getY();
        this.scantarget = this.thefield.findScanTarget(this.getTime());
        if (this.scantarget != null) {
            if (this.getTime() - this.scantarget.getScanTime() > (long)5) {
                this.setTurnRadarLeft(360.0);
            } else {
                this.turnRadarTo(this.scantarget.getPosition(), 0.39269908169872414);
            }
        } else {
            this.setTurnRadarLeft(360.0);
        }
        if (this.getTime() - this.scantime > 10L) {
            this.setTurnRadarLeft(360.0);
        }
    }

    public void move() {
        this.position.x = this.getX();
        this.position.y = this.getY();
        Force f = this.thefield.force(this.position, this.getTime());
        if (f.strength() > 0.001) {
            double offset;
            double heading = this.getHeadingRadians();
            double wanted_heading = f.bearing();
            if (!this.forwards && (wanted_heading += Math.PI) > Math.PI * 2) {
                wanted_heading -= Math.PI * 2;
            }
            if (Math.abs(offset = Util.offset(heading, wanted_heading)) > 1.5707963267948966) {
                this.forwards ^= true;
                offset -= Math.PI;
            }
            if (Math.abs(offset) > 0.06283185307179587) {
                if (offset > 0.0) {
                    this.setTurnRightRadians(offset);
                } else {
                    this.setTurnLeftRadians(-offset);
                }
            }
            if (!this.frozen) {
                if (this.forwards) {
                    this.setAhead(90.0);
                } else {
                    this.setBack(90.0);
                }
            }
        } else {
            this.setAhead(0.0);
        }
    }

    public final void selectTarget() {
        double heading = this.getGunHeadingRadians();
        this.position.x = this.getX();
        this.position.y = this.getY();
        if (this.target != null) {
            this.target.untarget();
        }
        this.target = this.thefield.findTarget(this.position, heading);
        if (this.target != null) {
            this.target.istarget();
        }
    }

    public boolean aim() {
        if (this.target != null) {
            this.position.x = this.getX();
            this.position.y = this.getY();
            this.power = this.target.firePower(this.position);
            double heading = this.getGunHeadingRadians();
            double offset = this.target.gunOffset(this.position, heading, this.power, this.getTime());
            if (offset > 0.0) {
                this.turnGunRightRadians(offset);
            } else {
                this.turnGunLeftRadians(-offset);
            }
            boolean bl = false;
            if (Math.abs(offset) < 0.5) {
                bl = true;
            }
            return bl;
        }
        return false;
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        String ename = e.getName();
        double absbearing_rad = (this.getHeadingRadians() + e.getBearingRadians()) % (Math.PI * 2);
        double x = this.getX() + Math.sin(absbearing_rad) * e.getDistance();
        double y = this.getY() + Math.cos(absbearing_rad) * e.getDistance();
        if (!this.thefield.contains(ename)) {
            Position p = new Position(x, y, this.getTime());
            Attractor a = new Attractor(ename, p, e.getEnergy(), this.getBattleFieldWidth(), this.getBattleFieldHeight(), this.out);
            this.thefield.addAttractor(a);
        } else {
            this.position.x = this.getX();
            this.position.y = this.getY();
            Attractor a = this.thefield.getAttractor(ename);
            a.update(e, x, y, this.getTime(), this.position);
        }
        this.scantime = this.getTime();
    }

    public void onHitByBullet(HitByBulletEvent e) {
        String ename = e.getName();
        Attractor a = this.thefield.getAttractor(ename);
        if (a != null) {
            a.hasHit(this.position);
        }
    }

    public void onBulletHit(BulletHitEvent e) {
        String ename = e.getName();
        Attractor a = this.thefield.getAttractor(ename);
        if (a != null) {
            this.position.x = this.getX();
            this.position.y = this.getY();
            a.hit(e, this.getTime(), this.position);
        }
        int n = this.thefield.count();
        this.number_of_shots_hit[n] = this.number_of_shots_hit[n] + 1;
    }

    public void onBulletMissed(BulletMissedEvent e) {
        int n = this.thefield.count();
        this.number_of_shots_missed[n] = this.number_of_shots_missed[n] + 1;
    }

    public void onHitRobot(HitRobotEvent e) {
        String ename = e.getName();
        if (this.thefield.contains(ename)) {
            if (this.target != null) {
                this.target.untarget();
            }
            this.target = this.thefield.getAttractor(ename);
            if (this.target != null) {
                this.target.istarget();
                this.position.x = this.getX();
                this.position.y = this.getY();
                this.target.rammed(this.position, e);
            }
        }
    }

    public void onWin(WinEvent e) {
    }

    public void onRobotDeath(RobotDeathEvent e) {
        String ename = e.getName();
        if (this.target != null) {
            if (ename.equals(this.target.getName())) {
                this.target.deathStatistics(this.out);
                this.target = null;
            } else if (this.thefield.contains(ename)) {
                Attractor t = this.thefield.getAttractor(ename);
                t.deathStatistics(this.out);
            }
        }
        if (this.talkative) {
            this.statistics(this.thefield.count());
        }
        this.thefield.removeAttractor(ename);
    }

    private final /* synthetic */ void this() {
        this.MaxNumberOfRobots = 60;
    }

    public Bandit2002() {
        this.this();
    }
}

